/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.excel.ExcelUiUtils;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.ui.BulkDeploy;
import com.tridium.template.ui.BulkDeployUtil;
import com.tridium.template.ui.BulkDeployWorkbook;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;

public class UpdateConfigs
extends BulkDeploy {
    private static final int DEPTH_FROM_STATION_TO_APPLICATION_SERVICE_TEMPLATE_CONFIG = 4;

    public UpdateConfigs(BWidget owner, String label) {
        super(owner, label);
    }

    public UpdateConfigs(BWidget owner, Lexicon lexicon, String keyBase) {
        super(owner, lexicon, keyBase);
    }

    @Override
    public CommandArtifact doInvoke() throws Exception {
        if (ExcelUiUtils.informIfNoExcelSupportIsInstalledLocally(this.getOwner())) {
            return null;
        }
        LOG.log(this.IMPORT_LOG_LEVEL, "Update Configurations");
        BComponent root = this.initBulkDeploy();
        if (root == null) {
            return null;
        }
        BulkDeployWorkbook deployWorkbook = this.getDeployWorkbook();
        if (deployWorkbook == null) {
            return null;
        }
        List<BulkDeployUtil.DeployedWorksheet> deployedWorksheets = this.deployUtil.loadDeployedWorksheets(deployWorkbook);
        for (BulkDeployUtil.DeployedWorksheet deployedWorksheet : deployedWorksheets) {
            for (BulkDeployUtil.DeployedRoot deployedRoot : deployedWorksheet.deployedRoots) {
                BComponent deployedTemplateComponent = this.findTemplateInstance(deployedWorksheet, deployedRoot, root);
                if (deployedTemplateComponent == null || deployedTemplateComponent instanceof BStation) continue;
                UpgradeUtil.deleteTemplateInputLinks((BComponent)deployedTemplateComponent, deployedWorksheet.inputDefs);
                UpgradeUtil.deleteTemplateOutputLinks((BComponent)deployedTemplateComponent, deployedWorksheet.outputDefs);
                UpgradeUtil.deleteTemplateInputRelations((BComponent)deployedTemplateComponent, deployedWorksheet.relationDefs);
                UpgradeUtil.deleteTemplateOutputRelations((BComponent)deployedTemplateComponent, deployedWorksheet.relationDefs);
            }
        }
        HashMap<BComponent, BNameMap> displayNames = new HashMap<BComponent, BNameMap>();
        int deployedRootCount = 0;
        int updatedRootCount = 0;
        StringBuilder errorDetailMessage = new StringBuilder();
        for (BulkDeployUtil.DeployedWorksheet deployedWorksheet : deployedWorksheets) {
            for (BulkDeployUtil.DeployedRoot deployedRoot : deployedWorksheet.deployedRoots) {
                ++deployedRootCount;
                BComponent deployedTemplateComponent = this.findTemplateInstance(deployedWorksheet, deployedRoot, root);
                if (deployedTemplateComponent == null) {
                    errorDetailMessage.append("\n");
                    errorDetailMessage.append(deployedRoot.getParentComponentSlotPath());
                    errorDetailMessage.append("/");
                    errorDetailMessage.append(deployedRoot.getDeployName());
                    continue;
                }
                ++updatedRootCount;
                deployedRoot.setDeployedTemplate(deployedTemplateComponent);
                this.deployUtil.updateConfigurations(deployedWorksheet, deployedRoot);
                if (deployedTemplateComponent instanceof BStation) continue;
                BulkDeployUtil.setComponentPosition(deployedTemplateComponent, deployedRoot.getPosition());
                HashMap<String, BFormat> componentDisplayNames = new HashMap<String, BFormat>();
                BComponent deployedRootComponent = this.resolveDeployComponent(deployedWorksheet, deployedRoot, root);
                if (deployedRoot.getDisplayName() != null && !deployedRoot.getDisplayName().isEmpty()) {
                    String escapedName = SlotPath.escape((String)deployedRoot.getDeployName());
                    try {
                        componentDisplayNames.put(deployedRootComponent.getProperty(escapedName).getName(), BFormat.make((String)deployedRoot.getDisplayName()));
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, LEX.getText("bulkDeploy.excelImport.displayNameError", new Object[]{deployedRoot.getDisplayName(), deployedRoot.getDeployName()}), e);
                    }
                }
                if (componentDisplayNames.isEmpty()) continue;
                BNameMap nameMap = BNameMap.make(componentDisplayNames);
                if (displayNames.containsKey(deployedRootComponent)) {
                    BNameMap mergedNameMap = BNameMap.make((BNameMap)((BNameMap)displayNames.get(deployedRootComponent)), (BNameMap)nameMap);
                    displayNames.put(deployedRootComponent, mergedNameMap);
                    continue;
                }
                displayNames.put(deployedRootComponent, nameMap);
            }
        }
        if (!displayNames.isEmpty()) {
            displayNames.forEach((key, value) -> {
                LOG.log(this.IMPORT_LOG_LEVEL, String.format("Component: %s, Updated display name: %s", key.getName(), value.encodeToString()));
                this.deployUtil.updateTemplateDisplayNames((BComponent)key, (BNameMap)value);
            });
        }
        if (deployedRootCount == updatedRootCount) {
            switch (deployedRootCount) {
                case 0: {
                    BDialog.error((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.configsUpdatedForNone"));
                    break;
                }
                case 1: {
                    BDialog.message((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.configsUpdatedForOne"));
                    break;
                }
                default: {
                    BDialog.message((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.configsUpdatedForMany", new Object[]{deployedRootCount}));
                    break;
                }
            }
        } else if (updatedRootCount == 0) {
            if (deployedRootCount == 1) {
                BDialog.error((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.ErrorConfigsUpdatedForNoneOfOne"));
            } else {
                BDialog.error((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.ErrorConfigsUpdatedForNoneOfMany", new Object[]{deployedRootCount}));
            }
        } else {
            String details = errorDetailMessage.toString();
            if (details.isEmpty()) {
                BDialog.warning((BWidget)this.getOwner(), null, (Object)LEX.getText("bulkDeploy.excelImport.ErrorConfigsUpdatedForSome", new Object[]{updatedRootCount, deployedRootCount}));
            } else {
                BDialog.warning((BWidget)this.getOwner(), null, (Object)LEX.getText("bulkDeploy.excelImport.ErrorConfigsUpdatedDetails", new Object[]{updatedRootCount, deployedRootCount, details}));
            }
        }
        return null;
    }

    private BComponent findTemplateInstance(BulkDeployUtil.DeployedWorksheet deployedWorksheet, BulkDeployUtil.DeployedRoot deployedRoot, BComponent root) {
        BComponent deployedTemplateComponent = null;
        BComponent deployedRootComponent = this.resolveDeployComponent(deployedWorksheet, deployedRoot, root);
        if (deployedRootComponent instanceof BStation) {
            deployedTemplateComponent = deployedRootComponent;
        } else if (deployedRootComponent != null) {
            String escapedName = SlotPath.escape((String)deployedRoot.getDeployName());
            try {
                deployedTemplateComponent = deployedRootComponent.get(escapedName).asComponent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (deployedTemplateComponent == null) {
            LOG.log(Level.WARNING, LEX.getText("bulkDeploy.excelImport.templateNotResolvedError", new Object[]{deployedRoot.getDeployName(), deployedWorksheet.title}));
        } else {
            deployedTemplateComponent.lease(4);
            BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployedTemplateComponent);
            if (templateConfig == null) {
                LOG.log(Level.WARNING, LEX.getText("bulkDeploy.excelImport.invalidTemplateError", new Object[]{deployedTemplateComponent.getName()}));
                deployedTemplateComponent = null;
            } else if (!Objects.equals(templateConfig.getUID(), deployedWorksheet.uid)) {
                LOG.log(Level.WARNING, LEX.getText("bulkDeploy.excelImport.invalidTemplateId", new Object[]{deployedTemplateComponent.getName()}));
                deployedTemplateComponent = null;
            }
        }
        return deployedTemplateComponent;
    }

    protected BComponent resolveDeployComponent(BulkDeployUtil.DeployedWorksheet deployedWorksheet, BulkDeployUtil.DeployedRoot deployedRoot, BComponent root) {
        BComponent deployedRootComponent = null;
        switch (deployedWorksheet.templateType) {
            case "Application": {
                deployedRootComponent = root;
                break;
            }
            default: {
                BOrd deployRootOrd = BOrd.make((String)(root.getSlotPathOrd() + deployedRoot.getParentComponentSlotPath()));
                LOG.log(this.IMPORT_LOG_LEVEL, "deployRootOrd = " + deployRootOrd);
                try {
                    deployedRootComponent = deployRootOrd.resolve((BObject)root).getComponent();
                    break;
                }
                catch (UnresolvedException unresolvedException) {
                    // empty catch block
                }
            }
        }
        if (deployedRootComponent == null) {
            LOG.log(Level.WARNING, LEX.getText("bulkDeploy.excelImport.rootNotResolvedError", new Object[]{deployedRoot.getDeployName(), deployedWorksheet.title}));
        }
        return deployedRootComponent;
    }
}

