/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.template.ui.BTemplateDeployProgressDialog;
import com.tridium.template.ui.BulkDeployUtil;
import com.tridium.template.ui.BulkDeployWorkbook;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.baja.sys.BComponent;
import javax.baja.ui.BProgressDialog;

public class TemplateDeployWorker
extends BProgressDialog.Worker {
    private BulkDeployWorkbook workbook;
    private BComponent root;
    private boolean isRunning = false;
    private boolean canceled = false;
    private BulkDeployUtil deployUtil;

    public TemplateDeployWorker(BulkDeployWorkbook workbook, BComponent root, BulkDeployUtil deployUtil) {
        this.workbook = workbook;
        this.root = root;
        this.deployUtil = deployUtil;
    }

    public void doRun() {
        this.isRunning = true;
        this.canceled = false;
        this.deployUtil.deployTemplatesFromExcel(this.workbook, this.root, this);
        this.isRunning = false;
    }

    public void doCancel() {
        this.isRunning = false;
        this.canceled = true;
    }

    public String getMaxMessage() {
        Map<String, String> templateTitles = this.deployUtil.getTemplateTitlesFromExcel(this.workbook);
        AtomicReference<String> message = new AtomicReference<String>();
        message.set("");
        templateTitles.forEach((title, deployName) -> {
            String progressMessage = BulkDeployUtil.lex.getText("bulkDeploy.progress.update.config", new Object[]{title, deployName});
            if (progressMessage.length() > ((String)message.get()).length()) {
                message.set(progressMessage);
            }
        });
        return (String)message.get();
    }

    public void setDialog(BTemplateDeployProgressDialog dialog) {
        this.dialog = dialog;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

