/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.excel.EncryptedDocumentException;
import com.tridium.excel.ExcelFileObject;
import com.tridium.excel.ExcelUtils;
import com.tridium.excel.Name;
import com.tridium.excel.Workbook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public class BulkDeployWorkbook
implements Closeable {
    private static final String TEMPLATE_EXPORT_VERSION_NAME = "version";
    private static final String TEMPLATE_TYPE_NAME = "templateType";
    private static final String KEEP_PRIVATE_NAME = "keepPrivate";
    private static final String TEMPLATE_TYPE_COMPONENT = "Component";
    private static final String TEMPLATE_TYPE_DEVICE = "Device";
    private static final String TEMPLATE_TYPE_APPLICATION = "Application";
    private final String name;
    private final boolean isEncrypted;
    private final boolean wrongPassword;
    private final boolean usesOldExcelFormat;
    private final String templateExportVersion;
    private final boolean keepPrivate;
    private Workbook workbook;
    private InputStream workbookStream;

    public static BulkDeployWorkbook load(File workbookFile, String password) throws IOException {
        return new BulkDeployWorkbook(workbookFile.getName(), workbookFile, password);
    }

    public static BulkDeployWorkbook load(File workbookFile) throws IOException {
        return BulkDeployWorkbook.load(workbookFile, null);
    }

    public static BulkDeployWorkbook load(String name, InputStream inputStream) throws IOException {
        return BulkDeployWorkbook.load(name, inputStream, null);
    }

    public static BulkDeployWorkbook load(String name, InputStream inputStream, String password) throws IOException {
        return new BulkDeployWorkbook(name, inputStream, password);
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                exception = e;
            }
            this.workbook = null;
        }
        if (this.workbookStream != null) {
            try {
                this.workbookStream.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                }
                e.addSuppressed(exception);
                exception = e;
            }
            this.workbookStream = null;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean wrongPassword() {
        return this.wrongPassword;
    }

    public boolean usesOldExcelFormat() {
        return this.usesOldExcelFormat;
    }

    public boolean isValid() {
        return this.workbook != null;
    }

    public String getTemplateExportVersion() {
        return this.templateExportVersion;
    }

    public boolean hasApplicationTemplate() {
        return this.hasNamedRangeValue(TEMPLATE_TYPE_NAME, TEMPLATE_TYPE_APPLICATION);
    }

    public boolean hasComponentTemplate() {
        return this.hasNamedRangeValue(TEMPLATE_TYPE_NAME, TEMPLATE_TYPE_COMPONENT);
    }

    public boolean hasDeviceTemplate() {
        return this.hasNamedRangeValue(TEMPLATE_TYPE_NAME, TEMPLATE_TYPE_DEVICE);
    }

    public boolean hasPrivateData() {
        return this.keepPrivate;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private BulkDeployWorkbook(String name, Object workbookSource, String password) throws IOException {
        this.name = name;
        this.workbook = null;
        this.workbookStream = null;
        boolean usePassword = false;
        boolean failed = false;
        boolean encrypted = false;
        do {
            try {
                if (workbookSource instanceof File) {
                    this.workbook = ExcelUtils.createWorkbook((File)((File)workbookSource), (String)(usePassword ? password : null));
                } else if (workbookSource instanceof InputStream) {
                    if (this.workbookStream == null) {
                        InputStream is = (InputStream)workbookSource;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        int b = is.read();
                        while (b != -1) {
                            byteArrayOutputStream.write(b);
                            b = is.read();
                        }
                        this.workbookStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        this.workbookStream.mark(this.workbookStream.available());
                    } else {
                        this.workbookStream.reset();
                    }
                    this.workbook = ExcelUtils.createWorkbook((InputStream)this.workbookStream, (String)(usePassword ? password : null));
                }
            }
            catch (EncryptedDocumentException e) {
                this.workbook = null;
                if (usePassword) {
                    failed = true;
                }
                encrypted = true;
            }
            usePassword = true;
        } while (this.workbook == null && password != null && !failed);
        this.isEncrypted = encrypted;
        this.wrongPassword = failed;
        this.usesOldExcelFormat = !ExcelUtils.isXmlFormat((ExcelFileObject)this.workbook);
        this.templateExportVersion = this.loadTemplateExportVersion();
        if (this.templateExportVersion == null) {
            this.close();
            System.gc();
            this.workbook = null;
        }
        this.keepPrivate = this.loadKeepPrivateFlag();
    }

    private String loadTemplateExportVersion() {
        return this.getWorkbookConstant(TEMPLATE_EXPORT_VERSION_NAME);
    }

    private boolean loadKeepPrivateFlag() {
        return Boolean.parseBoolean(this.getWorkbookConstant(KEEP_PRIVATE_NAME));
    }

    private String getWorkbookConstant(String name) {
        return this.getSheetOrWorkbookConstant(-1, name);
    }

    private String getSheetOrWorkbookConstant(int sheetIndex, String name) {
        Name constantName = this.getNamedRange(sheetIndex, name);
        if (constantName == null) {
            return null;
        }
        return BulkDeployWorkbook.extractStringValue(constantName.getRefersToFormula());
    }

    private Name getNamedRange(int sheetIndex, String nameName) {
        Name foundName = null;
        if (this.workbook != null) {
            List names = this.workbook.getNames(nameName);
            for (Name name : names) {
                if (name.getSheetIndex() != sheetIndex) continue;
                foundName = name;
                break;
            }
        }
        return foundName;
    }

    private boolean hasNamedRangeValue(String nameName, String nameValue) {
        if (this.workbook == null) {
            return false;
        }
        List names = this.workbook.getNames(nameName);
        for (Name name : names) {
            if (!Objects.equals(nameValue, BulkDeployWorkbook.extractStringValue(name.getRefersToFormula()))) continue;
            return true;
        }
        return false;
    }

    private static String extractStringValue(String formula) {
        if (formula == null || formula.length() < 2 || !formula.startsWith("\"") || !formula.endsWith("\"")) {
            return null;
        }
        return formula.substring(1, formula.length() - 1);
    }
}

