/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.template.ui.BTemplateManager;
import com.tridium.workbench.shell.BFontSize;
import com.tridium.workbench.shell.BGeneralOptions;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;

public class BSelectFromListDialog
extends BDialog {
    public static final Action save = BSelectFromListDialog.newAction((int)0, null);
    public static final Action cancel = BSelectFromListDialog.newAction((int)0, null);
    public static final Action updateCommands = BSelectFromListDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSelectFromListDialog.class);
    private static Lexicon lex = Lexicon.make((String)"template");
    protected ArrayList choiceList;
    private static BImage searchIcon = BImage.make((String)"module://icons/x16/find.png");
    private static BImage infoIcon = BImage.make((String)"module://icons/x16/info.png");
    protected BFlowPane header;
    private BTextField searchEntryField;
    protected String searchEntry;
    protected BTable choicesTable;
    protected SelectModel tableModel;
    private FilterSubscriber subscriber;
    private static IRectGeom lastBounds;
    private static String lastSearch;
    private int results = 0;
    protected BButton btnSave;
    protected BButton btnCancel;
    protected boolean isInput;
    protected boolean isRelation;
    protected boolean allowMultiple;
    protected boolean isDeploy = true;
    protected String info;
    private BCheckBox rememberCB;
    private BCheckBox dontAskAgainCB;
    protected static boolean rememberSelected;
    protected static boolean dontAskAgainSelected;

    public void save() {
        this.invoke(save, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSelectFromListDialog() {
    }

    public ArrayList openDialog() {
        int confirm;
        if (lastBounds == null) {
            this.setBoundsCenteredOnOwner();
            lastBounds = this.getScreenBounds();
        }
        double width = lastBounds.width() < 500.0 ? 500.0 : lastBounds.width();
        double height = lastBounds.height() < 300.0 ? 300.0 : lastBounds.height();
        this.setScreenBounds(lastBounds.x(), lastBounds.y(), width, height);
        if (lastSearch != null) {
            this.setSearchEntry(lastSearch);
        }
        do {
            this.open();
            if (this.getResult() != 1) continue;
            return this.tableModel.getChoices();
        } while (this.isDeploy && (confirm = BDialog.confirm((BWidget)this.getOwner(), (Object)lex.getText("templateManager.confirm.abort.deploy"))) != 4);
        return null;
    }

    public BSelectFromListDialog(BWidget parent, String title, String subtitle, String info, boolean isInput, boolean isRelation, boolean allowMultiple, ArrayList list, boolean allowRemember, boolean showDontAsk) {
        super(parent, title, true);
        this.choiceList = this.makeChoiceArray(list);
        this.isInput = isInput;
        this.isRelation = isRelation;
        this.allowMultiple = allowMultiple;
        this.info = info;
        if (parent instanceof BTemplateManager) {
            this.isDeploy = false;
            ((BTemplateManager)parent).setIsDeploy(false);
        }
        BEdgePane rootPane = new BEdgePane();
        BEdgePane headerPane = new BEdgePane();
        BFlowPane infoPane = null;
        if (info != null && !info.isEmpty()) {
            infoPane = new BFlowPane();
            infoPane.add(null, (BValue)new BLabel(infoIcon, ""));
            infoPane.add(null, (BValue)new BLabel(info));
        }
        this.header = new BFlowPane();
        this.subscriber = new FilterSubscriber((BWidget)this);
        if (this.showSearch()) {
            this.searchEntryField = new BSearchTextField();
            this.searchEntryField.setVisibleColumns(10);
            this.searchEntry = "";
            this.header.add(null, (BValue)new BLabel(searchIcon, ""));
            this.header.add(null, (BValue)this.searchEntryField);
            this.subscriber.subscribe((BComponent)this.searchEntryField);
        }
        this.fillInHeader(this.header);
        if (infoPane != null) {
            headerPane.setTop((BWidget)infoPane);
        }
        headerPane.setCenter((BWidget)this.header);
        boolean isLargeFont = BGeneralOptions.make().getFontSize() == BFontSize.large;
        BInsets headerInsets = isLargeFont ? BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0) : BInsets.make((double)5.0, (double)5.0, (double)10.0, (double)5.0);
        rootPane.setTop((BWidget)new BBorderPane((BWidget)headerPane, headerInsets));
        this.tableModel = this.makeModel(this.choiceList);
        this.choicesTable = this.makeTable(this.tableModel);
        this.choicesTable.setController(this.makeController());
        this.initHeader();
        BTitlePane choicePane = BTitlePane.makePane((String)subtitle, (BTable)this.choicesTable);
        rootPane.setCenter((BWidget)choicePane);
        rootPane.setBottom((BWidget)this.buildButtonPane());
        this.subscriber.subscribe((BComponent)this.rememberCB);
        this.subscriber.subscribe((BComponent)this.dontAskAgainCB);
        this.rememberCB.setVisible(allowRemember);
        this.rememberCB.setSelected(rememberSelected);
        this.dontAskAgainCB.setVisible(showDontAsk);
        this.setContent((BWidget)rootPane);
    }

    public void setIsDeploy(boolean isDeploy) {
        this.isDeploy = isDeploy;
    }

    protected SelectModel makeModel(ArrayList list) {
        return new SelectModel(list);
    }

    protected TableController makeController() {
        return new SelectController();
    }

    protected BTable makeTable(TableModel model) {
        return new BTable(model);
    }

    protected void initHeader() {
    }

    protected void setLastSearch(String value) {
        lastSearch = value;
    }

    public boolean getRemember() {
        rememberSelected = this.rememberCB.isSelected();
        return rememberSelected;
    }

    public boolean getDontAskAgain() {
        dontAskAgainSelected = this.dontAskAgainCB.isSelected();
        return dontAskAgainSelected;
    }

    protected ArrayList makeChoiceArray(ArrayList choices) {
        return choices;
    }

    protected boolean showSearch() {
        return true;
    }

    protected void fillInHeader(BFlowPane header) {
    }

    public String getSearchEntry() {
        return this.searchEntry;
    }

    public void setSearchEntry(String searchEntry) {
        if (this.searchEntryField != null) {
            this.searchEntry = searchEntry;
            this.searchEntryField.setText(searchEntry);
            this.searchUpdate();
        }
    }

    public ArrayList<BComponent> getSelectedResults() {
        return null;
    }

    public int getResult() {
        return this.results;
    }

    public BTable getTable() {
        return this.choicesTable;
    }

    protected void searchUpdate() {
    }

    public void doSave() {
        this.results = 1;
        this.close();
    }

    public void doCancel() {
        this.results = 2;
        this.close();
    }

    private BPane buildButtonPane() {
        BEdgePane edgePane = new BEdgePane();
        BGridPane gPane = new BGridPane(1);
        this.rememberCB = new BCheckBox(lex.getText("templateManager.reuseSelection"));
        this.rememberCB.setVisible(false);
        gPane.add(null, (BValue)this.rememberCB);
        String slotType = this.isRelation ? lex.getText("slot.relation") : (this.isInput ? lex.getText("slot.input") : lex.getText("slot.output"));
        this.dontAskAgainCB = new BCheckBox(lex.getText("templateManager.dontAskAgain") + ' ' + slotType);
        this.dontAskAgainCB.setVisible(false);
        gPane.add(null, (BValue)this.dontAskAgainCB);
        edgePane.setTop((BWidget)gPane);
        BFlowPane pane = new BFlowPane();
        pane.setAlign(BHalign.center);
        pane.add(null, (BValue)this.makeSaveButton());
        pane.add(null, (BValue)this.makeCancelButton());
        edgePane.setBottom((BWidget)pane);
        return edgePane;
    }

    protected BButton makeCancelButton() {
        this.btnCancel = new BButton(new Command((BWidget)this, lex, "templateManager.cancel"));
        this.linkTo((BComponent)this.btnCancel, (Slot)BButton.actionPerformed, (Slot)cancel);
        return this.btnCancel;
    }

    protected BButton makeSaveButton() {
        this.btnSave = new BButton(new Command((BWidget)this, lex, "templateManager.save"));
        this.linkTo((BComponent)this.btnSave, (Slot)BButton.actionPerformed, (Slot)save);
        this.btnSave.setEnabled(true);
        return this.btnSave;
    }

    public void close() {
        lastBounds = this.getScreenBounds();
        if (lastBounds.width() < 350.0) {
            lastBounds = new RectGeom(lastBounds.x(), lastBounds.y(), 350.0, lastBounds.height());
        }
        lastSearch = this.getSearchEntry();
        super.close();
    }

    public void doUpdateCommands() {
    }

    static {
        rememberSelected = true;
        dontAskAgainSelected = false;
    }

    class FilterSubscriber
    extends WidgetSubscriber {
        BWidget owner;

        FilterSubscriber(BWidget owner) {
            this.owner = owner;
        }

        public void mousePressed(BMouseEvent event) {
            BWidget widget = event.getWidget();
            if (widget.equals((Object)BSelectFromListDialog.this.rememberCB)) {
                BSelectFromListDialog.this.dontAskAgainCB.setEnabled(BSelectFromListDialog.this.rememberCB.isSelected());
                if (!BSelectFromListDialog.this.dontAskAgainCB.getEnabled()) {
                    BSelectFromListDialog.this.dontAskAgainCB.setSelected(false);
                }
            } else if (widget.equals((Object)BSelectFromListDialog.this.dontAskAgainCB) && !BSelectFromListDialog.this.dontAskAgainCB.isSelected()) {
                BSelectFromListDialog.this.rememberCB.setSelected(false);
            }
        }

        public void keyTyped(BKeyEvent event) {
            if (event.getWidget().equals((Object)BSelectFromListDialog.this.searchEntryField)) {
                BSelectFromListDialog.this.searchEntry = BSelectFromListDialog.this.searchEntryField.getText();
                BSelectFromListDialog.this.searchUpdate();
            }
        }
    }

    protected class SelectController
    extends TableController {
        protected SelectController() {
        }
    }

    protected class SelectModel
    extends TableModel {
        private ArrayList choices;

        public SelectModel() {
        }

        public SelectModel(ArrayList list) {
            this.choices = list;
        }

        public Object getSubject(int row) {
            return this.choices.get(row);
        }

        public void setSelectChoices(ArrayList choices) {
            this.choices = choices;
        }

        public ArrayList getChoices() {
            return this.choices;
        }

        public int getRowCount() {
            return this.choices.size();
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int col) {
            return null;
        }

        public Object getValueAt(int row, int col) {
            return null;
        }

        public boolean isColumnSortable(int col) {
            return col == 0;
        }

        public synchronized void sortByColumn(int col, boolean ascending) {
            if (this.choices == null) {
                return;
            }
            if (ascending) {
                Collections.sort(this.choices);
            } else {
                Collections.reverse(this.choices);
            }
        }
    }

    private static class BSearchTextField
    extends BTextField {
        BSearchTextField() {
        }
    }
}

