/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BIcon;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

public abstract class ApplicationNavTreeNode
extends NavTreeNode {
    private static final BIcon DEFAULT_ICON = BIcon.std((String)"object.png");
    static final BIcon ADD_BADGE_ICON = BIcon.std((String)"badges/add.png");
    static final BIcon REMOVE_BADGE_ICON = BIcon.std((String)"badges/remove.png");
    static final BIcon OPTIONAL_BADGE_ICON = BIcon.std((String)"badges/ellipsis.png");
    private final BINavNode navNode;
    private BIcon icon;
    private BImage iconImage;

    ApplicationNavTreeNode(NavTreeModel model, NavTreeNode parent, BINavNode navNode) {
        super(model, parent, navNode);
        this.navNode = navNode;
    }

    public abstract ApplicationNavTreeNode makeChildNode(NavTreeModel var1, BINavNode var2);

    protected abstract BIcon getBadge();

    public BImage getIcon() {
        BIcon badge;
        BIcon icon = this.navNode.getNavIcon();
        if (icon == null) {
            icon = DEFAULT_ICON;
        }
        if ((badge = this.getBadge()) != null) {
            icon = BIcon.make((BIcon)icon, (BIcon)badge);
        }
        if (icon != this.icon) {
            this.icon = icon;
            this.iconImage = BImage.make((BIcon)icon);
            this.iconImage.sync();
        }
        if (this.navNode instanceof BISpaceNode && ((BISpaceNode)this.navNode).isPendingMove()) {
            return this.iconImage.getDisabledImage();
        }
        return this.iconImage;
    }
}

