/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.rsp;

import com.tridium.andoverInfinity.identify.BInfinityPointId;
import com.tridium.andoverInfinity.point.BInfinityProxyExt;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import javax.baja.control.BControlPoint;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BString;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BInfinityReadPointResponse
extends BDdfResponse
implements BIDdfReadResponse {
    public static final Type TYPE = Sys.loadType(BInfinityReadPointResponse.class);
    static final Lexicon lex = Lexicon.make(BInfinityReadPointResponse.class);
    private String answer;

    public Type getType() {
        return TYPE;
    }

    public BInfinityReadPointResponse() {
    }

    public BInfinityReadPointResponse(String txt) {
        this.answer = txt;
    }

    public BStatusValue parseReadValue(IDdfReadable readableSource) {
        if (readableSource instanceof BInfinityProxyExt) {
            BInfinityProxyExt ext = (BInfinityProxyExt)readableSource;
            BControlPoint controlPoint = ext.getParentPoint();
            BInfinityPointId id = (BInfinityPointId)ext.getPointId();
            id.setRawResponse(this.answer);
            int indexOfEquals = this.answer.indexOf(61);
            if (indexOfEquals == -1) {
                return null;
            }
            String rightSide = this.answer.substring(indexOfEquals + 1).trim();
            int split = rightSide.indexOf(" ");
            String valStr = split == -1 ? rightSide : rightSide.substring(0, split);
            if (controlPoint instanceof BStringPoint) {
                return new BStatusString(rightSide);
            }
            if (controlPoint instanceof BINumeric) {
                return this.parseNumeric(valStr);
            }
            if (controlPoint instanceof BIBoolean) {
                return this.parseBoolean(valStr);
            }
            if (controlPoint instanceof BIEnum) {
                return this.parseEnum(valStr, ext);
            }
        }
        return null;
    }

    private BStatusNumeric parseNumeric(String valStr) throws NumberFormatException {
        return new BStatusNumeric(this.stringToNumeric(valStr));
    }

    private BStatusEnum parseEnum(String valStr, BInfinityProxyExt ext) throws NumberFormatException {
        BStatusEnum sv = (BStatusEnum)ext.getReadValue().newCopy();
        try {
            BDouble value = BDouble.make((double)this.stringToNumeric(valStr));
            sv = (BStatusEnum)ext.getReadValue().newCopy();
            BDynamicEnum en = sv.getValue();
            sv.setValue(en.getRange().get((int)value.getDouble()));
        }
        catch (NumberFormatException e) {
            BEnum myEnum = this.getEnum(valStr, ((BControlPoint)this.getParent()).getFacets());
            sv.setValue(myEnum);
        }
        return sv;
    }

    private double stringToNumeric(String valStr) throws NumberFormatException {
        if (valStr.endsWith("%")) {
            valStr = valStr.substring(0, valStr.length() - 1);
        }
        try {
            int i = Integer.parseInt(valStr);
            return i;
        }
        catch (NumberFormatException i) {
            try {
                double d = Double.parseDouble(valStr);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                if (valStr.equalsIgnoreCase("On") || valStr.equalsIgnoreCase("True")) {
                    return 1.0;
                }
                if (valStr.equalsIgnoreCase("-On")) {
                    return -1.0;
                }
                if (valStr.equalsIgnoreCase("Off") || valStr.equalsIgnoreCase("False")) {
                    return 0.0;
                }
                throw new NumberFormatException("not a number");
            }
        }
    }

    private BStatusBoolean parseBoolean(String valStr) throws NumberFormatException {
        try {
            BStatusNumeric numeric = this.parseNumeric(valStr);
            return (double)Math.round(numeric.getValue()) == 0.0 ? new BStatusBoolean(false) : new BStatusBoolean(true);
        }
        catch (NumberFormatException e) {
            try {
                BFacets facets = ((BControlPoint)this.getParent()).getFacets();
                boolean b = this.getBoolean(valStr, facets);
                return new BStatusBoolean(b);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    private BEnum getEnum(String text, BFacets facets) throws NumberFormatException {
        if (facets != null) {
            try {
                BEnumRange range = (BEnumRange)facets.get("range");
                BEnum myEnum = range.get(text);
                return myEnum;
            }
            catch (InvalidEnumException e) {
                throw new NumberFormatException("answer does not match an enum tag");
            }
        }
        throw new NumberFormatException("No Enum Defined");
    }

    private boolean getBoolean(String text, BFacets facets) throws NumberFormatException {
        if (facets != null) {
            BString trueText = (BString)facets.get("trueText");
            BString falseText = (BString)facets.get("falseText");
            if (trueText != null && falseText != null) {
                if (text.equalsIgnoreCase(trueText.getString())) {
                    return true;
                }
                if (text.equalsIgnoreCase(falseText.getString())) {
                    return false;
                }
            }
        }
        if (lex.getText("point.boolean.define." + text) == "1") {
            return true;
        }
        if (lex.getText("point.boolean.define." + text) == "0") {
            return false;
        }
        throw new NumberFormatException("cannot convert string to boolean");
    }
}

