/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinityPingResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityDevicePingRequest
extends BDdfPingRequest
implements Vt100Const,
RequiresNetworkAccess,
BIDdfCustomRequest {
    public static final Type TYPE = Sys.loadType(BInfinityDevicePingRequest.class);
    private static String ONLINE = "OnLine";
    private static String OFFLINE = "OffLine";
    BInfinityNetwork network;
    int recoveryCount = 0;

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityDevicePingRequest.processReceive(),mode=" + cursorModes[mode]);
        int line = this.network.getScreen().getCursorLine();
        String responseLine = "";
        switch (mode) {
            case 4: {
                BInfinityDeviceId networkId = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
                String name = this.network.getScreen().parseNetworkControllerNameFromLine1();
                if (name != null) {
                    networkId.setControllerName(name);
                }
                responseLine = this.network.getScreen().getFullLine(line - 1);
                try {
                    responseLine = responseLine.substring(1, responseLine.length() - 1).trim();
                    if (responseLine.equalsIgnoreCase(ONLINE)) {
                        return new BInfinityPingResponse();
                    }
                    if (responseLine.equalsIgnoreCase(OFFLINE)) {
                        throw new DdfResponseException("Device OffLine");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                line = this.network.getScreen().findLastPromptLine();
                responseLine = this.network.getScreen().getFullLine(line - 1);
                try {
                    responseLine = responseLine.substring(1, responseLine.length() - 1).trim();
                    if (responseLine.equalsIgnoreCase(ONLINE)) {
                        return new BInfinityPingResponse();
                    }
                    if (responseLine.equalsIgnoreCase(OFFLINE)) {
                        throw new DdfResponseException("Device OffLine");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                break;
            }
            default: {
                ++this.recoveryCount;
                if (this.recoveryCount > 2) {
                    this.network.getScreen().clearScreenBuffer();
                    throw new DdfResponseException("error, recoveryCount exceeded, resetting VT100 buffer...");
                }
                return new BInfinityAckWithData(this.network.getScreen().getRecovery(mode));
            }
        }
        throw new DdfResponseException("error, response:" + responseLine.trim() + " mode:" + cursorModes[mode]);
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        StringBuffer sb = new StringBuffer();
        this.network.getLogger().fine("BInfinityDevicePingRequest:toByteArray(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 10: 
            case 11: {
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            case 0: 
            case 1: 
            case 138: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window\u001b6" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (!this.network.getScreen().integrityCheck()) {
                    sb.append("\u001a");
                }
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                BInfinityDeviceId networkId = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
                String name = this.network.getScreen().parseNetworkControllerNameFromLine1();
                if (name == null) break;
                networkId.setControllerName(name);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                ++this.recoveryCount;
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        BInfinityDeviceId deviceId = (BInfinityDeviceId)this.getDeviceId();
        sb.append("Print ");
        if (deviceId.getControllerName().length() != 0) {
            sb.append(deviceId.getControllerName()).append(" ");
        }
        sb.append("CommStatus\r");
        return sb.toString().getBytes();
    }

    public void processErrorResponse(DdfResponseException errorRsp) {
    }

    public void processLateResponse(BIDdfResponse ddfRsp) {
    }

    public void processResponse(BIDdfResponse ddfRsp) {
    }

    public void processTimeout() {
        this.network.setConnected(false);
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

