/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity;

import com.tridium.andoverInfinity.BInfinetDevice;
import com.tridium.andoverInfinity.BInfinityDeviceFolder;
import com.tridium.andoverInfinity.BInfinityNetworkDevice;
import com.tridium.andoverInfinity.comm.BInfinityCommunicator;
import com.tridium.andoverInfinity.comm.BInfinityLine;
import com.tridium.andoverInfinity.comm.BVt100;
import com.tridium.andoverInfinity.comm.CursorPosition;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.BInfinityInitializeScreenRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityKeystrokeRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityPollForControllerInfoRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityReloadInfinetRequest;
import com.tridium.andoverInfinity.comm.req.BInfinitySaveInfinetRequest;
import com.tridium.andoverInfinity.comm.req.BInfinitySetTimeRequest;
import com.tridium.andoverInfinity.discover.BInfinityDeviceDiscoveryPreferences;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddfSerial.BDdfSerialNetwork;
import com.tridium.ddfSerial.comm.BDdfSerialCommunicator;
import com.tridium.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BInfinityNetwork
extends BDdfSerialNetwork {
    public static final Property communicator = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityCommunicator(), null);
    public static final Property discoveryPreferences = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityDeviceDiscoveryPreferences(), null);
    public static final Property automaticallySetTime = BInfinityNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property syncTimeFrequency = BInfinityNetwork.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property restoreFile = BInfinityNetwork.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property networkDevice = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityNetworkDevice(), null);
    public static final Property backupModeActive = BInfinityNetwork.newProperty((int)6, (boolean)false, null);
    public static final Property pageUpPageDown = BInfinityNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"use esc seq", (String)"use control code"));
    public static final Action syncTime = BInfinityNetwork.newAction((int)0, null);
    public static final Action refresh = BInfinityNetwork.newAction((int)0, null);
    public static final Action setTerminalModeActive = BInfinityNetwork.newAction((int)4, (BValue)BBoolean.FALSE, null);
    public static final Action backupModeActivate = BInfinityNetwork.newAction((int)4, null);
    public static final Action reload = BInfinityNetwork.newAction((int)2052, (BValue)BBlob.DEFAULT, null);
    public static final Action abortReload = BInfinityNetwork.newAction((int)4, null);
    public static final Action retrieveNetworkDeviceInfo = BInfinityNetwork.newAction((int)0, null);
    public static final Action dumpScreenBuffer = BInfinityNetwork.newAction((int)0, null);
    public static final Action keystrokesCommand = BInfinityNetwork.newAction((int)2052, (BValue)BString.make((String)""), null);
    public static final Action getMode = BInfinityNetwork.newAction((int)0, null);
    public static final Action loadScreenBufferFromFile = BInfinityNetwork.newAction((int)2052, (BValue)BBlob.DEFAULT, null);
    public static final Action saveScreenBufferToFile = BInfinityNetwork.newAction((int)2052, null);
    public static final Topic terminalUpdated = BInfinityNetwork.newTopic((int)4, null);
    public static final Topic backupModeDone = BInfinityNetwork.newTopic((int)4, null);
    public static final Topic reloadModeDone = BInfinityNetwork.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType(BInfinityNetwork.class);
    private boolean connected = true;
    private BVt100 screen;
    private Object stringLock = new Object();
    private String keystrokes = "";
    private boolean terminalModeActive = false;
    private boolean reloadModeActive = false;
    private Clock.Ticket timeSyncTicket;
    private boolean shouldAbortReload = false;

    public BValue getCommunicator() {
        return this.get(communicator);
    }

    public void setCommunicator(BValue v) {
        this.set(communicator, v, null);
    }

    public BDdfDiscoveryPreferences getDiscoveryPreferences() {
        return (BDdfDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BDdfDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    public boolean getAutomaticallySetTime() {
        return this.getBoolean(automaticallySetTime);
    }

    public void setAutomaticallySetTime(boolean v) {
        this.setBoolean(automaticallySetTime, v, null);
    }

    public BRelTime getSyncTimeFrequency() {
        return (BRelTime)this.get(syncTimeFrequency);
    }

    public void setSyncTimeFrequency(BRelTime v) {
        this.set(syncTimeFrequency, (BValue)v, null);
    }

    public BOrd getRestoreFile() {
        return (BOrd)this.get(restoreFile);
    }

    public void setRestoreFile(BOrd v) {
        this.set(restoreFile, (BValue)v, null);
    }

    public BInfinityNetworkDevice getNetworkDevice() {
        return (BInfinityNetworkDevice)this.get(networkDevice);
    }

    public void setNetworkDevice(BInfinityNetworkDevice v) {
        this.set(networkDevice, (BValue)v, null);
    }

    public boolean getBackupModeActive() {
        return this.getBoolean(backupModeActive);
    }

    public void setBackupModeActive(boolean v) {
        this.setBoolean(backupModeActive, v, null);
    }

    public boolean getPageUpPageDown() {
        return this.getBoolean(pageUpPageDown);
    }

    public void setPageUpPageDown(boolean v) {
        this.setBoolean(pageUpPageDown, v, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public void setTerminalModeActive(BBoolean activate) {
        this.invoke(setTerminalModeActive, (BValue)activate, null);
    }

    public void backupModeActivate() {
        this.invoke(backupModeActivate, null, null);
    }

    public void reload(BBlob file) {
        this.invoke(reload, (BValue)file, null);
    }

    public void abortReload() {
        this.invoke(abortReload, null, null);
    }

    public void retrieveNetworkDeviceInfo() {
        this.invoke(retrieveNetworkDeviceInfo, null, null);
    }

    public void dumpScreenBuffer() {
        this.invoke(dumpScreenBuffer, null, null);
    }

    public void keystrokesCommand(BString newCmd) {
        this.invoke(keystrokesCommand, (BValue)newCmd, null);
    }

    public void getMode() {
        this.invoke(getMode, null, null);
    }

    public void loadScreenBufferFromFile(BBlob bufferBytes) {
        this.invoke(loadScreenBufferFromFile, (BValue)bufferBytes, null);
    }

    public BBlob saveScreenBufferToFile() {
        return (BBlob)this.invoke(saveScreenBufferToFile, null, null);
    }

    public void fireTerminalUpdated(BValue event) {
        this.fire(terminalUpdated, event, null);
    }

    public void fireBackupModeDone(BValue event) {
        this.fire(backupModeDone, event, null);
    }

    public void fireReloadModeDone(BValue event) {
        this.fire(reloadModeDone, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "andoverInfinity");
    }

    public void started() throws Exception {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setFlags((Slot)ping, 4);
        this.screen = new BVt100();
        this.screen.setNetwork(this);
        if (this.getAutomaticallySetTime()) {
            this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
        }
        super.started();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.refresh();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.timeSyncTicket != null) {
            this.timeSyncTicket.cancel();
        }
        this.timeSyncTicket = null;
    }

    public void changed(Property p, Context cx) {
        if ((p == syncTimeFrequency || p == automaticallySetTime) && this.isRunning()) {
            if (this.timeSyncTicket != null) {
                this.timeSyncTicket.cancel();
            }
            if (this.getAutomaticallySetTime()) {
                this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
            }
        }
        super.changed(p, cx);
    }

    public final Type getDeviceType() {
        return BInfinetDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BInfinityDeviceFolder.TYPE;
    }

    public void doRefresh() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doRefresh");
        }
        BInfinityInitializeScreenRequest initReq = new BInfinityInitializeScreenRequest(this);
        if (this.getDdfCommunicator() == null) {
            System.out.println("communicator is null");
        }
        try {
            this.getDdfCommunicator().communicate((BIDdfRequest)initReq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSetTerminalModeActive(BBoolean activate) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doSetTerminalModeActive");
        }
        this.terminalModeActive = activate.getBoolean();
    }

    public void doBackupModeActivate() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doBackupModeActivate");
        }
        BInfinitySaveInfinetRequest req = new BInfinitySaveInfinetRequest();
        BDdfSerialCommunicator communicator = (BDdfSerialCommunicator)this.getDdfCommunicator();
        communicator.communicate((BIDdfRequest)req);
    }

    public void doReload(BBlob blob) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doReload");
        }
        System.out.println(new String(blob.copyBytes()));
        BInfinityReloadInfinetRequest req = new BInfinityReloadInfinetRequest();
        req.setFileContents(blob);
        this.getDdfCommunicator().communicate((BIDdfRequest)req);
    }

    public void doAbortReload() {
        this.setShouldAbortReload(true);
    }

    public void doKeystrokesCommand(BString cmd) {
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doKeystrokesCommand");
        }
        System.out.println("doKeystrokes:" + cmd.getString());
        if (this.terminalModeActive || this.getBackupModeActive() || this.reloadModeActive) {
            if (this.terminalModeActive) {
                System.out.println("doKeystrokesCommand:terminalModeActive");
            }
            if (this.getBackupModeActive()) {
                System.out.println("doKeystrokesCommand:backupModeActive");
            }
            if (this.reloadModeActive) {
                System.out.println("doKeystrokesCommand:reloadModeActive");
            }
            this.receiveKeystrokes(cmd.getString());
            BInfinityKeystrokeRequest rawReq = new BInfinityKeystrokeRequest(this.getKeystrokes().getBytes());
            this.getDdfCommunicator().communicate((BIDdfRequest)rawReq);
        }
    }

    public void doRetrieveNetworkDeviceInfo() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doRetrieveNetworkDeviceInfo");
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPollForControllerInfoRequest());
    }

    public void doSyncTime() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doSyncTime");
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinitySetTimeRequest());
    }

    public BBlob doSaveScreenBufferToFile() {
        return BBlob.make((byte[])this.getScreen().screenBufferToString().getBytes());
    }

    public void doLoadScreenBufferFromFile(BBlob fileBlob) {
        int i;
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doLoadTestBuffer");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileBlob.copyBytes())));
        String[] buffer = new String[49];
        int newLine = 1;
        int newCol = 1;
        for (i = 0; i < 49; ++i) {
            if (i < 24) {
                try {
                    buffer[i] = in.readLine().substring(0, 80);
                    this.getScreen().setContentLine(i, buffer[i]);
                }
                catch (IOException e) {
                    this.getScreen().setContentLine(i, " ");
                }
                continue;
            }
            if (i < 48) {
                try {
                    buffer[i] = in.readLine().substring(0, 80);
                    this.getScreen().setFormatLine(i - 24, buffer[i]);
                }
                catch (IOException e) {
                    this.getScreen().setContentLine(i, " ");
                }
                continue;
            }
            if (i != 48) continue;
            try {
                buffer[i] = in.readLine();
                int start = buffer[i].indexOf(91);
                int colon = buffer[i].indexOf(58, start);
                int end = buffer[i].indexOf(93);
                newLine = Integer.parseInt(buffer[i].substring(start + 1, colon));
                newCol = Integer.parseInt(buffer[i].substring(colon + 1, end));
                this.getScreen().setPosition(new CursorPosition(newLine, newCol));
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        for (i = 0; i < 24; ++i) {
            this.fireTerminalUpdated((BValue)new BInfinityLine(i, i, newLine, newCol, buffer[i], buffer[i + 24]));
        }
    }

    public BINavNode[] getNavChildren() {
        Object[] kids = super.getNavChildren();
        return (BINavNode[])ArrayUtil.addOne((Object[])kids, (Object)((Object)this.getNetworkDevice()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveKeystrokes(String more) {
        Object object = this.stringLock;
        synchronized (object) {
            this.keystrokes = this.keystrokes + more;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeystrokes() {
        String latestKeystrokes;
        Object object = this.stringLock;
        synchronized (object) {
            latestKeystrokes = this.keystrokes;
            this.keystrokes = "";
        }
        return latestKeystrokes;
    }

    public BVt100 getScreen() {
        return this.screen;
    }

    public int getLine() {
        return this.screen.getCursorPosition().getLine();
    }

    public CursorPosition getCursorPosition() {
        return this.screen.getCursorPosition();
    }

    public void doDumpScreenBuffer() {
        this.getScreen().doDumpScreen();
    }

    public void doGetMode() {
        System.out.println("Mode:" + Vt100Const.cursorModes[this.getScreen().getMode()]);
        System.out.println("Insert is " + (this.getScreen().isInsertMode() ? "on" : "off"));
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        if (!this.isRunning()) {
            return;
        }
        if (connected) {
            if (this.isDown()) {
                this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPollForControllerInfoRequest());
            }
            this.pingOk();
        } else {
            this.pingFail("not connected");
        }
        this.connected = connected;
    }

    public boolean isTerminalModeActive() {
        return this.terminalModeActive;
    }

    public boolean isReloadModeActive() {
        return this.reloadModeActive;
    }

    public void setReloadModeActive(boolean reloadModeActive) {
        this.reloadModeActive = reloadModeActive;
    }

    public Logger getLogger() {
        return super.getLogger();
    }

    public boolean isShouldAbortReload() {
        return this.shouldAbortReload;
    }

    public void setShouldAbortReload(boolean shouldAbortReload) {
        this.shouldAbortReload = shouldAbortReload;
    }
}

