/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.sys.Nre;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BBaseBoard
extends BComponent {
    public static final Property productModel = BBaseBoard.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BBaseBoard.class);
    private static Hashtable<String, BBaseBoard> boardTypes = new Hashtable();
    private static Hashtable<String, String> platJars = new Hashtable();
    private static String[] jarFiles = new String[]{"module://platHwScan/rc/platHwScanPlatformJars.xml"};
    protected static final int FLAGS = 3;
    protected Array<String> configParams = null;
    protected boolean simulation = false;
    protected int nextLanPort;
    protected int nextLonPort;
    protected int nextSerialPort;

    public String getProductModel() {
        return this.getString(productModel);
    }

    public void setProductModel(String v) {
        this.setString(productModel, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array<String> configParams, boolean simulation) {
        this.simulation = simulation;
        this.configParams = configParams;
        this.setProductModel(BHardwareScanService.lex.getText(Nre.getHostModel()));
    }

    public String getBoardCode() {
        return null;
    }

    public Vector<BHardwareRef> getHardwareRefs() {
        return new Vector<BHardwareRef>();
    }

    public String getView(BObject v) {
        return BHardwareScanService.lex.getText("pxView");
    }

    public String getImagesDirectory() {
        return null;
    }

    public static BBaseBoard lookup(String boardCode) {
        BBaseBoard obj;
        if (boardTypes.isEmpty()) {
            BBaseBoard.queryRegistry();
        }
        if ((obj = boardTypes.get(boardCode.toUpperCase())) == null) {
            return null;
        }
        return obj;
    }

    private static void queryRegistry() {
        TypeInfo[] types;
        boardTypes = new Hashtable();
        for (TypeInfo type : types = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo())) {
            BBaseBoard instance = (BBaseBoard)type.getInstance();
            try {
                String boardCode = instance.getBoardCode();
                if (boardCode == null) continue;
                boardTypes.put(boardCode.toUpperCase(), instance);
            }
            catch (Exception e) {
                BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("BaseBoard.registrationError", new Object[]{instance}));
            }
        }
    }

    public static Object lookupModelJar(String code) {
        if (platJars.isEmpty()) {
            for (String jarFile : jarFiles) {
                try {
                    Hashtable<String, String> ht = BBaseBoard.parsePlatformJarsFile(jarFile);
                    if (ht == null) continue;
                    Enumeration<String> keys = ht.keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement().toUpperCase();
                        if (platJars.get(key) != null) {
                            BHardwareScanService.log.warning(BHardwareScanService.lex.getText("BaseBoard.duplicatePlatformCode", new Object[]{key, jarFile}));
                        }
                        platJars.put(key, ht.get(key));
                    }
                }
                catch (Exception e) {
                    BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("parsingError", new Object[]{e.getClass().getName(), jarFile}));
                    e.printStackTrace();
                }
            }
        }
        return platJars.get(code.toUpperCase());
    }

    private static Hashtable<String, String> parsePlatformJarsFile(String filePath) throws Exception {
        XElem[] elements;
        XElem root;
        BHardwareScanService.log.fine(BHardwareScanService.lex.getText("parsingNotification", new Object[]{filePath}));
        try {
            BOrd fileOrd = BOrd.make((String)filePath);
            BIFile file = (BIFile)fileOrd.get();
            root = XParser.make((InputStream)file.getInputStream()).parse();
        }
        catch (Exception e) {
            if (e instanceof UnresolvedException) {
                BHardwareScanService.log.fine(BHardwareScanService.lex.getText("fileDoesNotExist", new Object[]{filePath}));
                return null;
            }
            if (e instanceof EOFException) {
                BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("unexpectedEof", new Object[]{filePath}));
                return null;
            }
            throw e;
        }
        if (!root.name().equalsIgnoreCase("hwScanPlatformJars")) {
            BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("fileFormatError", new Object[]{filePath, root.name(), "hwScanPlatformJars"}));
            return null;
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (XElem nextElement : elements = root.elems()) {
            String name = nextElement.name();
            if (!name.equalsIgnoreCase("platform")) continue;
            try {
                ht.put(nextElement.get("code").toUpperCase(), nextElement.get("module"));
            }
            catch (Exception e) {
                BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("parsingError", new Object[]{nextElement.toString()}));
            }
        }
        return ht;
    }

    protected String buildPortRefDescription(BPort port) {
        StringBuilder sb = new StringBuilder(port.getName());
        if (!port.getHasConnector()) {
            sb.append(" ").append(BHardwareScanService.lex.getText("HardwareRef.noConnector"));
        }
        return sb.toString();
    }

    protected String getBaseUnitText() {
        return BHardwareScanService.lex.getText("HardwareRef.baseUnit");
    }

    public boolean isSerialShellJumperPresent() {
        try {
            BComplex parent = this.getParent();
            while (!(parent instanceof BPlatformServiceContainer)) {
                parent = parent.getParent();
            }
            BPlatformServiceContainer container = (BPlatformServiceContainer)parent;
            container.lease();
            BPlatformService[] svcs = (BPlatformService[])container.getChildren(BHardwareScanService.serialPortSvcTypeSpec.getResolvedType().getTypeClass());
            svcs[0].checkPropertiesLoaded();
            svcs[0].lease(2);
            BComponent com1 = (BComponent)svcs[0].get("COM1");
            return ((BString)com1.get("owner")).getString().trim().equalsIgnoreCase("dbgjmpr");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    protected BHardwareRef makeBaseboardCommRef(int refNo, BPort port) {
        return new BHardwareRef(refNo, this.getBaseUnitText(), this.buildPortRefDescription(port), port.getPortType(), port.getStatus());
    }

    protected BHardwareRef makeJumperRef(int refNo) {
        return new BHardwareRef(refNo, this.getBaseUnitText(), BHardwareScanService.lex.getText("HardwareRef.serialShellJumper"), BPortTypeEnum.noPort, this.isSerialShellJumperPresent() ? BHwScanStatusEnum.serialShell : BHwScanStatusEnum.normalOperation);
    }

    protected String makePortName(int index, String portPrefix) {
        int portIndex = index;
        if (portPrefix.startsWith("COM")) {
            portIndex = this.nextSerialPort++;
        } else if (portPrefix.startsWith("LON")) {
            portIndex = this.nextLonPort++;
        } else if (portPrefix.startsWith("LAN")) {
            portIndex = this.nextLanPort++;
        }
        return portPrefix + portIndex;
    }

    protected BHardwareRef makePortRef(int refNo, int portNo, BPort port) {
        return this.makePortRef(String.valueOf(refNo), portNo, port);
    }

    protected BHardwareRef makePortRef(String ref, int portNo, BPort port) {
        String location = this.getBaseUnitText();
        for (BComplex parent = port.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BOptionSlot)) continue;
            location = parent.getDisplayName(null);
            break;
        }
        return new BHardwareRef(ref + "-" + portNo, location, this.buildPortRefDescription(port), port.getPortType(), port.getStatus());
    }

    protected BHardwareRef makeSlotRef(int refNo, BOptionSlot slot) {
        BHardwareRef ref = new BHardwareRef();
        ref.setReference(String.valueOf(refNo));
        ref.setLocation(slot.getDisplayName(null));
        if (slot.isEmpty()) {
            ref.setDescription(BHardwareScanService.lex.getText(BHwScanStatusEnum.empty.getTag()));
        } else {
            ref.setDescription(((BOptionCard)slot.getContents()).getDescription());
        }
        return ref;
    }
}

