/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.offnormal;

import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BTwoStateAlgorithm
extends BOffnormalAlgorithm {
    public static final Type TYPE = Sys.loadType(BTwoStateAlgorithm.class);
    TwoState current = new NormalState();

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (currentState == BAlarmState.offnormal) {
            this.current = new OffnormalState();
        }
    }

    @Override
    public BAlarmState checkAlarms(BStatusValue out, long toAlarmTimeDelay, long toNormalTimeDelay) {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (this.current instanceof ValidateOffnormalState) {
            return this.current.evaluate(this.isNormal(out), toAlarmTimeDelay);
        }
        if (this.current instanceof ValidateReturnFromOffnormalState) {
            return this.current.evaluate(this.isNormal(out), toNormalTimeDelay);
        }
        if (currentState == BAlarmState.offnormal) {
            this.current = new OffnormalState();
            return this.current.evaluate(this.isNormal(out), toNormalTimeDelay);
        }
        this.current = new NormalState();
        return this.current.evaluate(this.isNormal(out), toAlarmTimeDelay);
    }

    protected abstract boolean isNormal(BStatusValue var1);

    protected boolean isCurrentOffnormal() {
        return this.current instanceof OffnormalState;
    }

    private void transition(TwoState state) {
        this.current = state;
    }

    private class ValidateReturnFromOffnormalState
    extends ValidateState {
        public ValidateReturnFromOffnormalState(long timeDelay) {
            BTwoStateAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateReturnFromOffnormalState";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV, long timeDelay) {
            if (normalPV) {
                if (BTwoStateAlgorithm.this.isTimerExpired()) {
                    BTwoStateAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            } else {
                BTwoStateAlgorithm.this.transition(new OffnormalState());
                return null;
            }
            return null;
        }
    }

    private class OffnormalState
    extends TwoState {
        private OffnormalState() {
        }

        @Override
        public String tag() {
            return "OffnormalState";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV, long timeDelay) {
            if (normalPV) {
                if (timeDelay == 0L) {
                    BTwoStateAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BTwoStateAlgorithm.this.transition(new ValidateReturnFromOffnormalState(timeDelay));
                return null;
            }
            return null;
        }
    }

    private class ValidateOffnormalState
    extends ValidateState {
        public ValidateOffnormalState(long timeDelay) {
            BTwoStateAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateOffnormalState";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV, long timeDelay) {
            if (normalPV) {
                BTwoStateAlgorithm.this.transition(new NormalState());
                return null;
            }
            if (BTwoStateAlgorithm.this.isTimerExpired()) {
                BTwoStateAlgorithm.this.transition(new OffnormalState());
                return BAlarmState.offnormal;
            }
            return null;
        }
    }

    private class NormalState
    extends TwoState {
        private NormalState() {
        }

        @Override
        public String tag() {
            return "Normal";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV, long timeDelay) {
            if (!normalPV) {
                if (timeDelay == 0L) {
                    BTwoStateAlgorithm.this.transition(new OffnormalState());
                    return BAlarmState.offnormal;
                }
                BTwoStateAlgorithm.this.transition(new ValidateOffnormalState(timeDelay));
                return null;
            }
            return null;
        }
    }

    private abstract class ValidateState
    extends TwoState {
        private ValidateState() {
        }
    }

    private abstract class TwoState {
        public TwoState() {
            BTwoStateAlgorithm.this.cancelTimer();
        }

        public abstract String tag();

        public abstract BAlarmState evaluate(boolean var1, long var2);
    }
}

