/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext;

import java.util.Map;
import java.util.logging.Logger;
import javax.baja.alarm.ext.BAlarmAlgorithm;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.control.BControlPoint;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOffnormalAlgorithm
extends BAlarmAlgorithm {
    public static final Type TYPE = Sys.loadType(BOffnormalAlgorithm.class);
    long endTime;
    Clock.Ticket ticket;
    protected static Logger log = Logger.getLogger("control");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAlarmSourceExt;
    }

    @Override
    public boolean isGrandparentLegal(BComponent grandparent) {
        return true;
    }

    public final BAlarmState checkAlarmState(BStatusValue out, long toAlarmTimeDelay, long toNormalDelay) {
        return this.checkAlarms(out, toAlarmTimeDelay, toNormalDelay);
    }

    @Deprecated
    public final BAlarmState checkAlarmState(BStatusValue out, long toAlarmTimeDelay) {
        return this.checkAlarms(out, toAlarmTimeDelay, toAlarmTimeDelay);
    }

    @Deprecated
    public BAlarmState checkAlarms(BStatusValue out, long toAlarmTimeDelay) {
        return null;
    }

    public BAlarmState checkAlarms(BStatusValue out, long toAlarmTimeDelay, long toNormalTimeDelay) {
        return this.checkAlarms(out, toAlarmTimeDelay);
    }

    public void writeAlarmData(BStatusValue out, Map map) {
    }

    protected void startTimer(long timeDelay) {
        this.endTime = Clock.ticks() + timeDelay;
        BControlPoint cp = this.getParentPoint();
        if (cp != null && this.isRunning()) {
            this.ticket = Clock.schedule((BComponent)cp, (BRelTime)BRelTime.make((long)timeDelay), (Action)BControlPoint.execute, null);
        }
    }

    protected void cancelTimer() {
        this.endTime = -1L;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    protected boolean isTimerExpired() {
        long now = Clock.ticks();
        if (this.endTime == -1L) {
            throw new IllegalStateException();
        }
        return now >= this.endTime;
    }
}

