/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.alarm.BSourceState;
import javax.baja.sys.BBitString;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BAlarmTransitionBits
extends BBitString {
    public static final int TO_OFFNORMAL = 1;
    public static final int TO_FAULT = 2;
    public static final int TO_NORMAL = 4;
    public static final int TO_ALERT = 8;
    public static final BAlarmTransitionBits toOffnormal = new BAlarmTransitionBits(1);
    public static final BAlarmTransitionBits toFault = new BAlarmTransitionBits(2);
    public static final BAlarmTransitionBits toNormal = new BAlarmTransitionBits(4);
    public static final BAlarmTransitionBits toAlert = new BAlarmTransitionBits(8);
    public static final String SHOW_OFF_NORMAL = "showOffNormal";
    public static final String SHOW_NORMAL = "showNormal";
    public static final String SHOW_FAULT = "showFault";
    public static final String SHOW_ALERT = "showAlert";
    public static final BAlarmTransitionBits DEFAULT = new BAlarmTransitionBits(15);
    public static final BAlarmTransitionBits EMPTY = new BAlarmTransitionBits(0);
    public static final BAlarmTransitionBits ALL = DEFAULT;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;
    private int bits;

    public static BAlarmTransitionBits make(boolean v) {
        if (v) {
            return ALL;
        }
        return EMPTY;
    }

    public static BAlarmTransitionBits make(int bits) {
        if (bits == BAlarmTransitionBits.ALL.bits) {
            return ALL;
        }
        if (bits == BAlarmTransitionBits.EMPTY.bits) {
            return EMPTY;
        }
        return new BAlarmTransitionBits(bits);
    }

    public static BAlarmTransitionBits make(BAlarmTransitionBits old, BAlarmTransitionBits nBits, boolean set) {
        if (set) {
            return new BAlarmTransitionBits(old.getBits() | nBits.getBits());
        }
        return new BAlarmTransitionBits(old.getBits() & ~nBits.getBits());
    }

    private BAlarmTransitionBits(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public boolean includes(BSourceState state) {
        if (state == BSourceState.offnormal) {
            return this.isToOffnormal();
        }
        if (state == BSourceState.fault) {
            return this.isToFault();
        }
        if (state == BSourceState.normal) {
            return this.isToNormal();
        }
        if (state == BSourceState.alert) {
            return this.isToAlert();
        }
        return false;
    }

    public boolean isToOffnormal() {
        return (this.bits & 1) != 0;
    }

    public boolean isToFault() {
        return (this.bits & 2) != 0;
    }

    public boolean isToNormal() {
        return (this.bits & 4) != 0;
    }

    public boolean isToAlert() {
        return (this.bits & 8) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BAlarmTransitionBits.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public String getEmptyTag() {
        return "none";
    }

    public boolean isNull() {
        return this.bits == 0;
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BAlarmTransitionBits) {
            return ((BAlarmTransitionBits)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public String toString(Context context) {
        BFacets facets = null;
        if (context != null) {
            facets = context.getFacets();
        }
        if (this.bits == 0) {
            return "{}";
        }
        StringBuffer s = new StringBuffer();
        s.append('{');
        if (this.isToAlert() && (facets == null || facets.getb(SHOW_ALERT, true))) {
            s.append("alert ");
        }
        if (this.isToOffnormal() && (facets == null || facets.getb(SHOW_OFF_NORMAL, true))) {
            s.append("toOffnormal ");
        }
        if (this.isToFault() && (facets == null || facets.getb(SHOW_FAULT, true))) {
            s.append("toFault ");
        }
        if (this.isToNormal() && (facets == null || facets.getb(SHOW_NORMAL, true))) {
            s.append("toNormal ");
        }
        s.setCharAt(s.length() - 1, '}');
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BAlarmTransitionBits.make(in.readInt());
    }

    public String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BAlarmTransitionBits.make(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "toOffnormal");
        support.add(2, "toFault");
        support.add(4, "toNormal");
        support.add(8, "toAlert");
        TYPE = Sys.loadType(BAlarmTransitionBits.class);
    }
}

