/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmSchema;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timestamp", type="baja:AbsTime", flags=8, defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="uuid", type="baja:Uuid", defaultValue="BUuid.make()"), @NiagaraProperty(name="sourceState", type="alarm:SourceState", defaultValue="BSourceState.offnormal"), @NiagaraProperty(name="ackState", type="alarm:AckState", defaultValue="BAckState.unacked"), @NiagaraProperty(name="ackRequired", type="boolean", defaultValue="true"), @NiagaraProperty(name="source", type="baja:OrdList", flags=8, defaultValue="BOrdList.DEFAULT", facets={@Facet(name="\"width\"", value="BInteger.make(512)")}), @NiagaraProperty(name="alarmClass", type="String", flags=8, defaultValue="defaultAlarmClass", facets={@Facet(name="\"width\"", value="BInteger.make(256)")}), @NiagaraProperty(name="priority", type="int", flags=8, defaultValue="0"), @NiagaraProperty(name="normalTime", type="baja:AbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="ackTime", type="baja:AbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="user", type="String", defaultValue="Unknown User"), @NiagaraProperty(name="alarmData", type="baja:Facets", defaultValue="BFacets.DEFAULT", facets={@Facet(name="\"width\"", value="BInteger.make(1024)")}), @NiagaraProperty(name="alarmTransition", type="alarm:SourceState", defaultValue="BSourceState.offnormal"), @NiagaraProperty(name="lastUpdate", type="baja:AbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.TRUE")})})
public final class BAlarmRecord
extends BStruct {
    public static final Property timestamp = BAlarmRecord.newProperty((int)8, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property uuid = BAlarmRecord.newProperty((int)0, (BValue)BUuid.make(), null);
    public static final Property sourceState = BAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, null);
    public static final Property ackState = BAlarmRecord.newProperty((int)0, (BValue)BAckState.unacked, null);
    public static final Property ackRequired = BAlarmRecord.newProperty((int)0, (boolean)true, null);
    public static final Property source = BAlarmRecord.newProperty((int)8, (BValue)BOrdList.DEFAULT, (BFacets)BFacets.make((String)"width", (BIDataValue)BInteger.make((int)512)));
    public static final Property alarmClass = BAlarmRecord.newProperty((int)8, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"width", (BIDataValue)BInteger.make((int)256)));
    public static final Property priority = BAlarmRecord.newProperty((int)8, (int)0, null);
    public static final Property normalTime = BAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property ackTime = BAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property user = BAlarmRecord.newProperty((int)0, (String)"Unknown User", null);
    public static final Property alarmData = BAlarmRecord.newProperty((int)0, (BValue)BFacets.DEFAULT, (BFacets)BFacets.make((String)"width", (BIDataValue)BInteger.make((int)1024)));
    public static final Property alarmTransition = BAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, null);
    public static final Property lastUpdate = BAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BAlarmRecord.class);
    public static final Context DATA_RECOVERY_CX = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "Context.dataRecovery";
        }
    };
    private static final int SERIAL_VERSION_ID = 0;
    public static final BFacets TIMESTAMP_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    public static final String MSG_TEXT = "msgText";
    public static final String FROM_STATE = "fromState";
    public static final String TO_STATE = "toState";
    public static final String NOTIFY_TYPE = "notifyType";
    public static final String STATUS = "status";
    public static final String NEW_VALUE = "newValue";
    public static final String SETPT_VALUE = "setptValue";
    public static final String SETPT_NUMERIC = "setpointNumeric";
    public static final String ERROR_LIMIT = "errorLimit";
    public static final String DEADBAND = "deadband";
    public static final String COUNT = "Count";
    public static final String HIGH_LIMIT = "highLimit";
    public static final String LOW_LIMIT = "lowLimit";
    public static final String HIGH_DIFF_LIMIT = "highDiffLimit";
    public static final String LOW_DIFF_LIMIT = "lowDiffLimit";
    public static final String ALARM_VALUE = "alarmValue";
    public static final String OFFNORMAL_VALUE = "offnormalValue";
    public static final String FAULT_VALUE = "faultValue";
    public static final String PRESENT_VALUE = "presentValue";
    public static final String NUMERIC_VALUE = "numericValue";
    public static final String FEEDBACK_VALUE = "feedbackValue";
    public static final String FEEDBACK_NUMERIC = "feedbackNumeric";
    public static final String CONTROLLED_VALUE = "controlledValue";
    public static final String HYPERLINK_ORD = "hyperlinkOrd";
    public static final String SOUND_FILE = "soundFile";
    public static final String ICON = "icon";
    public static final String SOURCE_NAME = "sourceName";
    public static final String NOTES = "notes";
    public static final String INSTRUCTIONS = "instructions";
    public static final String TIME_ZONE = "TimeZone";
    public static final String TIME_DELAY = "timeDelay";
    public static final String TIME_DELAY_TO_NORMAL = "timeDelayToNormal";

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    public BSourceState getSourceState() {
        return (BSourceState)this.get(sourceState);
    }

    public void setSourceState(BSourceState v) {
        this.set(sourceState, (BValue)v, null);
    }

    public BAckState getAckState() {
        return (BAckState)this.get(ackState);
    }

    public void setAckState(BAckState v) {
        this.set(ackState, (BValue)v, null);
    }

    public boolean getAckRequired() {
        return this.getBoolean(ackRequired);
    }

    public void setAckRequired(boolean v) {
        this.setBoolean(ackRequired, v, null);
    }

    public BOrdList getSource() {
        return (BOrdList)this.get(source);
    }

    public void setSource(BOrdList v) {
        this.set(source, (BValue)v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public int getPriority() {
        return this.getInt(priority);
    }

    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    public BAbsTime getNormalTime() {
        return (BAbsTime)this.get(normalTime);
    }

    public void setNormalTime(BAbsTime v) {
        this.set(normalTime, (BValue)v, null);
    }

    public BAbsTime getAckTime() {
        return (BAbsTime)this.get(ackTime);
    }

    public void setAckTime(BAbsTime v) {
        this.set(ackTime, (BValue)v, null);
    }

    public String getUser() {
        return this.getString(user);
    }

    public void setUser(String v) {
        this.setString(user, v, null);
    }

    public BFacets getAlarmData() {
        return (BFacets)this.get(alarmData);
    }

    public void setAlarmData(BFacets v) {
        this.set(alarmData, (BValue)v, null);
    }

    public BSourceState getAlarmTransition() {
        return (BSourceState)this.get(alarmTransition);
    }

    public void setAlarmTransition(BSourceState v) {
        this.set(alarmTransition, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmRecord() {
        this(BUuid.DEFAULT);
    }

    public BAlarmRecord(BUuid uuid) {
        this(BOrd.make((String)""), "defaultAlarmClass", BFacets.DEFAULT, uuid);
    }

    public BAlarmRecord(BComponent comp, String alarmClass, BFacets alarmData) {
        this(comp, alarmClass, alarmData, BUuid.DEFAULT);
    }

    public BAlarmRecord(BComponent comp, String alarmClass, BFacets alarmData, BUuid uuid) {
        this(BOrd.make((OrdQuery)comp.getSlotPath()), alarmClass, alarmData, uuid);
    }

    public BAlarmRecord(BOrd source, String alarmClass, BFacets alarmData) {
        this(source, alarmClass, alarmData, BUuid.DEFAULT);
    }

    public BAlarmRecord(BOrd source, String alarmClass, BFacets alarmData, BUuid uuid) {
        this.setSource(BOrdList.make((BOrd)source));
        this.setAlarmClass(alarmClass);
        this.setAlarmData(alarmData);
        BAbsTime time = Clock.time();
        this.setUuid(uuid);
        this.setTimestamp(time);
        this.setLastUpdate(time);
    }

    public boolean isFixedSize() {
        return false;
    }

    public int getRecordSize() {
        return -1;
    }

    public void ackAlarm() {
        this.ackAlarm(this.getUser());
    }

    public void ackAlarm(String user) {
        BAbsTime time = Clock.time();
        if (this.getAckRequired()) {
            this.setAckState(BAckState.ackPending);
        } else {
            this.setAckState(BAckState.acked);
        }
        this.setUser(user);
        this.setAckTime(time);
        this.setLastUpdate(time);
    }

    public boolean isAlarm() {
        return this.getSourceState() != BSourceState.normal && this.getAckState() != BAckState.acked;
    }

    public boolean isAcknowledged() {
        return this.getAckState() == BAckState.acked;
    }

    public boolean isAckPending() {
        return this.getAckState() == BAckState.ackPending;
    }

    public boolean isNormal() {
        return this.getSourceState() == BSourceState.normal;
    }

    public boolean isOpen() {
        boolean acked;
        boolean bl = acked = this.getAckState() == BAckState.acked;
        if (this.getSourceState() == BSourceState.alert && !acked) {
            return true;
        }
        return !acked && this.getAckRequired() || this.getSourceState() != BSourceState.normal && this.getSourceState() != BSourceState.alert;
    }

    public void addAlarmFacet(String key, BIDataValue value) {
        this.setAlarmData(BFacets.make((BFacets)this.getAlarmData(), (String)key, (BIDataValue)value));
    }

    public BObject getAlarmFacet(String key) {
        return this.getAlarmData().get(key);
    }

    public BObject getAlarmValue() {
        BObject ret = this.getAlarmFacet(ALARM_VALUE);
        if (ret != null) {
            return ret;
        }
        ret = this.getAlarmFacet(OFFNORMAL_VALUE);
        if (ret != null) {
            return ret;
        }
        return this.getAlarmFacet(FAULT_VALUE);
    }

    public void removeAlarmFacet(String key) {
        this.setAlarmData(BFacets.makeRemove((BFacets)this.getAlarmData(), (String)key));
    }

    public String toString(Context ctxt) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("timestamp = ");
        sbuf.append(this.getTimestamp()).append(", ");
        sbuf.append("sourceState = ");
        sbuf.append((Object)this.getSourceState()).append(", ");
        sbuf.append("ackState = ");
        sbuf.append((Object)this.getAckState()).append(", ");
        sbuf.append("ackRequired = ");
        sbuf.append(this.getAckRequired()).append(", ");
        sbuf.append("source = ");
        sbuf.append(this.getSource()).append(", ");
        sbuf.append("priority = ");
        sbuf.append(this.getPriority()).append(", ");
        sbuf.append("alarmClass = ");
        sbuf.append(this.getAlarmClass());
        return sbuf.toString();
    }

    public String getAlarmClassDisplayName(Context cx) {
        if (Sys.getStation() == null) {
            return this.getAlarmClass();
        }
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        return alarmService.getAlarmClassDisplayName(BString.make((String)this.getAlarmClass()), cx).toString();
    }

    public BAlarmSchema getSchema() {
        BAlarmSchema schema = new BAlarmSchema();
        SlotCursor props = this.getProperties();
        while (props.next()) {
            Property prop = props.property();
            schema.addColumn(prop.getName(), prop.getType().getTypeSpec());
        }
        schema.getColumnCount();
        return schema;
    }

    public int getSerialVersionId() {
        return 0;
    }

    public void write(DataOutput out) throws IOException {
        this.write(out, null);
    }

    public void write(DataOutput out, Context context) throws IOException {
        this.encodeAbsTime(out, context, this.getTimestamp());
        this.getUuid().encode(out);
        this.getSourceState().encode(out);
        this.getAckState().encode(out);
        out.writeBoolean(this.getAckRequired());
        this.getSource().encode(out);
        out.writeUTF(this.getAlarmClass());
        out.writeInt(this.getPriority());
        this.encodeAbsTime(out, context, this.getNormalTime());
        this.encodeAbsTime(out, context, this.getAckTime());
        out.writeUTF(this.getUser());
        this.getAlarmData().encode(out);
        this.getAlarmTransition().encode(out);
        this.encodeAbsTime(out, context, this.getLastUpdate());
    }

    public void read(DataInput in) throws IOException {
        this.read(in, null);
    }

    public void read(DataInput in, Context context) throws IOException {
        this.setTimestamp(this.decodeAbsTime(in, context));
        this.setUuid((BUuid)BUuid.DEFAULT.decode(in));
        this.setSourceState((BSourceState)BSourceState.normal.decode(in));
        this.setAckState((BAckState)BAckState.acked.decode(in));
        this.setAckRequired(in.readBoolean());
        this.setSource((BOrdList)BOrdList.DEFAULT.decode(in));
        this.setAlarmClass(in.readUTF());
        this.setPriority(in.readInt());
        this.setNormalTime(this.decodeAbsTime(in, context));
        this.setAckTime(this.decodeAbsTime(in, context));
        this.setUser(in.readUTF());
        this.setAlarmData((BFacets)BFacets.DEFAULT.decode(in));
        this.setAlarmTransition((BSourceState)BSourceState.normal.decode(in));
        this.setLastUpdate(this.decodeAbsTime(in, context));
    }

    private void encodeAbsTime(DataOutput out, Context context, BAbsTime absTime) throws IOException {
        if (context == DATA_RECOVERY_CX) {
            absTime.encode48(out);
        } else {
            absTime.encode(out);
        }
    }

    private BAbsTime decodeAbsTime(DataInput in, Context context) throws IOException {
        BAbsTime absTime = null;
        absTime = context == DATA_RECOVERY_CX ? (BAbsTime)BAbsTime.DEFAULT.decode48(in) : (BAbsTime)BAbsTime.DEFAULT.decode64(in);
        return absTime;
    }

    public String toSummaryString() {
        StringBuffer s = new StringBuffer(128);
        s.append(this.getTimestamp().toString((Context)TIMESTAMP_FACETS));
        s.append(": ");
        s.append('(').append((Object)this.getAckState()).append(':').append((Object)this.getSourceState()).append(") ");
        s.append(this.getUuid());
        return s.toString();
    }

    public static String[] getAlarmDataFields() {
        return new String[]{ALARM_VALUE, CONTROLLED_VALUE, COUNT, DEADBAND, ERROR_LIMIT, FAULT_VALUE, FEEDBACK_NUMERIC, FEEDBACK_VALUE, FROM_STATE, HIGH_LIMIT, HYPERLINK_ORD, ICON, INSTRUCTIONS, LOW_LIMIT, MSG_TEXT, NEW_VALUE, NOTES, NOTIFY_TYPE, NUMERIC_VALUE, OFFNORMAL_VALUE, PRESENT_VALUE, SETPT_VALUE, SOUND_FILE, SOURCE_NAME, STATUS, TIME_ZONE, TO_STATE, SETPT_NUMERIC, HIGH_DIFF_LIMIT, LOW_DIFF_LIMIT};
    }

    public final boolean isAlarmDataFieldFormat(String field) {
        return MSG_TEXT.equals(field) || INSTRUCTIONS.equals(field);
    }

    public final String getFormattedAlarmDataValue(String field, Context cx) {
        String value = Objects.toString(this.getAlarmData().getFacet(field), "");
        if (value.isEmpty()) {
            return value;
        }
        return this.isAlarmDataFieldFormat(field) ? BFormat.make((String)value).format((Object)this, cx) : value;
    }
}

