/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.IOException;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSource;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BUuid;

public interface AlarmSpaceConnection
extends AutoCloseable {
    public void flush();

    @Override
    public void close();

    public void append(BAlarmRecord var1) throws IOException, AlarmException;

    public void update(BAlarmRecord var1) throws IOException, AlarmException;

    public int getRecordCount();

    public BAlarmRecord getRecord(BUuid var1) throws IOException;

    public Cursor<BAlarmSource> getOpenAlarmSources() throws IOException;

    public Cursor<BAlarmRecord> getOpenAlarms() throws IOException;

    public Cursor<BAlarmRecord> getAckPendingAlarms() throws IOException;

    public Cursor<BAlarmRecord> getAlarmsForSource(BOrdList var1) throws IOException;

    default public Cursor<BAlarmRecord> getOpenAlarmsForSource(BOrdList alarmSource) throws IOException {
        final Cursor<BAlarmRecord> c = this.getAlarmsForSource(alarmSource);
        return new Cursor<BAlarmRecord>(){

            public Context getContext() {
                return c.getContext();
            }

            public boolean next() {
                while (c.next()) {
                    if (!((BAlarmRecord)((Object)c.get())).isOpen()) continue;
                    return true;
                }
                return false;
            }

            public BAlarmRecord get() {
                return (BAlarmRecord)((Object)c.get());
            }

            public void close() {
                c.close();
            }
        };
    }

    public Cursor<BAlarmRecord> scan() throws IOException, AlarmException;

    public Cursor<BAlarmRecord> timeQuery(BAbsTime var1, BAbsTime var2) throws IOException, AlarmException;
}

