/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import java.io.PrintStream;
import java.util.Objects;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.sys.BAbsTime;

public class IndexEntry {
    public static final int FLAG_OPEN = 1;
    public static final int FLAG_ACKED = 2;
    public static final int FLAG_NORMAL = 4;
    public static final int FLAG_ACK_PENDING = 8;
    public final BAbsTime timestamp;
    public final int pageIndex;
    public IndexEntry[] nextTimestamp;
    public IndexEntry prevTimestamp;
    public IndexEntry[] nextSource;
    public IndexEntry prevSource;
    public byte flags = 0;
    public IndexEntry prevOpen;
    public IndexEntry nextOpen;
    public IndexEntry prevAckPending;
    public IndexEntry nextAckPending;

    public IndexEntry() {
        this.timestamp = null;
        this.pageIndex = -1;
    }

    public IndexEntry(BAlarmRecord rec, int pageIndex) {
        this.timestamp = rec.getTimestamp();
        this.pageIndex = pageIndex;
    }

    public IndexEntry(BAbsTime timestamp, int pageIndex) {
        this.timestamp = timestamp;
        this.pageIndex = pageIndex;
    }

    public boolean equals(Object o) {
        IndexEntry entry = (IndexEntry)o;
        if (this.timestamp == null && entry.timestamp == null) {
            return true;
        }
        if (this.timestamp == null || entry.timestamp == null) {
            return false;
        }
        return this.timestamp.equals((Object)entry.timestamp) && this.pageIndex == entry.pageIndex;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, new Integer(this.pageIndex));
    }

    public final boolean isOpen() {
        return (this.flags & 1) != 0;
    }

    public final void setOpen(boolean o) {
        this.flags = o ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public final boolean isAcked() {
        return (this.flags & 2) != 0;
    }

    public final void setAcked(boolean a) {
        this.flags = a ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public final boolean isNormal() {
        return (this.flags & 4) != 0;
    }

    public final void setNormal(boolean a) {
        this.flags = a ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public final boolean isAckPending() {
        return (this.flags & 8) != 0;
    }

    public final void setAckPending(boolean a) {
        this.flags = a ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    public void dump(PrintStream out) {
        out.println("IndexEntry: " + this.timestamp + " Page: " + this.pageIndex + " Flags: " + this.flags);
        out.println("  Previous Timestamp: " + this.prevTimestamp.timestamp);
        out.println("  Next Timestamps: ");
        for (int i = 0; i < this.nextTimestamp.length; ++i) {
            out.println("      " + this.nextTimestamp[i].timestamp);
        }
    }
}

