/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import java.io.PrintStream;

public class FreePageMap {
    private static final int[] BIT_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private int pageCount = 0;
    private byte[] pageMask = null;

    public int getPageCount() {
        return this.pageCount;
    }

    public int getFreeCount() {
        int mask;
        byte b;
        if (this.pageCount == 0) {
            return 0;
        }
        int freeCount = 0;
        for (int i = 0; i < this.pageMask.length - 1; ++i) {
            b = this.pageMask[i];
            mask = 1;
            for (int j = 0; j < 8; ++j) {
                if ((b & mask) == 0) {
                    ++freeCount;
                }
                mask <<= 1;
            }
        }
        int lastBits = this.pageCount - (this.pageMask.length - 1) * 8;
        b = this.pageMask[this.pageMask.length - 1];
        mask = 1;
        for (int i = 0; i < lastBits; ++i) {
            if ((b & mask) == 0) {
                ++freeCount;
            }
            mask <<= 1;
        }
        return freeCount;
    }

    public int getFreePage() {
        if (this.pageCount != 0) {
            int len = this.pageMask.length;
            for (int i = 0; i < len; ++i) {
                if ((this.pageMask[i] & 0xFF ^ 0xFF) == 0) continue;
                int checkMask = 1;
                for (int j = 0; j < 8; ++j) {
                    if ((this.pageMask[i] & 0xFF & checkMask) == 0) {
                        return i * 8 + j;
                    }
                    checkMask <<= 1;
                }
            }
        }
        return -1;
    }

    public boolean isFree(int pageIndex) {
        int byteIndex = pageIndex / 8;
        if (byteIndex >= this.pageCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (this.pageMask[byteIndex] & BIT_MASKS[pageIndex - byteIndex * 8]) == 0;
    }

    public void setFree(int pageIndex, boolean free) {
        if (pageIndex >= this.pageCount) {
            this.addFreePages(pageIndex - this.pageCount + 1);
        }
        int byteIndex = pageIndex / 8;
        int mask = BIT_MASKS[pageIndex - byteIndex * 8];
        this.pageMask[byteIndex] = free ? (byte)(this.pageMask[byteIndex] & ~mask) : (byte)(this.pageMask[byteIndex] | mask);
    }

    public void addFreePages(int addCount) {
        if (addCount < 0) {
            throw new IllegalArgumentException("Invalid add count: " + addCount);
        }
        if (this.pageMask == null) {
            int newBytes = addCount / 8;
            if (addCount % 8 != 0) {
                ++newBytes;
            }
            this.pageMask = new byte[newBytes];
            this.pageCount = addCount;
            return;
        }
        int capacity = this.pageMask.length * 8;
        int spareBits = capacity - this.pageCount;
        if (spareBits != 0) {
            int fromSpare = spareBits > addCount ? addCount : spareBits;
            this.pageCount += fromSpare;
            addCount -= fromSpare;
        }
        if (addCount == 0) {
            return;
        }
        int newBytes = addCount / 8;
        if (addCount % 8 != 0) {
            ++newBytes;
        }
        int origLen = this.pageMask.length;
        byte[] temp = new byte[origLen + newBytes];
        System.arraycopy(this.pageMask, 0, temp, 0, origLen);
        this.pageMask = temp;
        this.pageCount += addCount;
    }

    public int getSizeInBytes() {
        return this.pageMask.length;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        int mask;
        byte b;
        if (this.pageCount == 0) {
            return;
        }
        int p = 0;
        for (int i = 0; i < this.pageMask.length - 1; ++i) {
            b = this.pageMask[i];
            mask = 1;
            for (int j = 0; j < 8; ++j) {
                if ((b & mask) == 0) {
                    out.println(p++ + ") free");
                } else {
                    out.println(p++ + ") in use");
                }
                mask <<= 1;
            }
        }
        int lastBits = this.pageCount - (this.pageMask.length - 1) * 8;
        b = this.pageMask[this.pageMask.length - 1];
        mask = 1;
        for (int i = 0; i < lastBits; ++i) {
            if ((b & mask) == 0) {
                out.println(p++ + ") free");
            } else {
                out.println(p++ + ") in use");
            }
            mask <<= 1;
        }
    }
}

