/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.BFileAlarmDbConfig;
import com.tridium.alarm.db.file.DataRecoveryAlarmEvent;
import com.tridium.alarm.db.file.FileAlarmDbConnection;
import com.tridium.dataRecovery.BDataRecoveryEmptyKey;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.npsdk.BSystemPlatformServiceNpsdk;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.sys.Nre;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.alarm.BAlarmService;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrd;
import javax.baja.security.BIProtected;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFileAlarmDatabase
extends BAlarmDatabase
implements BIDataRecoverySource {
    private final ServiceListener serviceListener = new ServiceListener(){

        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().is(BIDataRecoveryService.TYPE)) {
                if (event.getId() == 0) {
                    BFileAlarmDatabase.this.dataRecoveryService = (BIDataRecoveryService)event.getService();
                    if (!BFileAlarmDatabase.this.dataRecoveryService.isEnabled()) {
                        BFileAlarmDatabase.this.dataRecoveryService = null;
                    }
                } else if (event.getId() == 1) {
                    BFileAlarmDatabase.this.dataRecoveryService = null;
                }
            }
        }

        public String toString() {
            return "ServiceListener for AlarmService";
        }
    };
    public static final Type TYPE = Sys.loadType(BFileAlarmDatabase.class);
    private static final BOrd ordInSession = BOrd.make((String)"alarm:");
    private static final String CAPACITY = "capacity";
    private static final String ARCHIVE_ID = "alarm";
    private int capacity = 10000;
    private File dbDir = null;
    private File alarmFile = null;
    private AlarmStore alarmStore = null;
    private BOrd alarmServiceOrd = null;
    private static final BIEncodable EMPTY_KEY = BDataRecoveryEmptyKey.INSTANCE;
    private BIDataRecoveryService dataRecoveryService = null;
    private static final Logger dataRecoveryLog = Logger.getLogger("alarm.dataRecovery");

    @Override
    protected synchronized void assertOpen() {
        super.assertOpen();
    }

    @Override
    public AlarmDbConnection getDbConnection(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasOperatorRead()) {
            throw new AlarmException("user needs alarm space permissions");
        }
        if (log.isLoggable(Level.FINE) && Thread.currentThread().getName().equals("Nre:Engine")) {
            try {
                throw new AlarmException("BFileAlarmDatabase.getDbConnection called from Nre:Engine Thread");
            }
            catch (AlarmException ae) {
                log.log(Level.FINE, "Potential Performance Degradation", (Throwable)((Object)ae));
            }
        }
        return new FileAlarmDbConnection(this, cx);
    }

    @Override
    public void doOpen() throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                if (this.dbDir == null) {
                    try {
                        FilePath dbPath;
                        BSystemPlatformService plat = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                        if (plat.archiveEnabled(ARCHIVE_ID)) {
                            plat.extractArchive(ARCHIVE_ID);
                        }
                        String platPath = plat.getRuntimeDirectory(ARCHIVE_ID);
                        BFileSpace fs = (BFileSpace)BOrd.make((String)"file:").get();
                        BIFile checkDir = fs.findFile(dbPath = new FilePath(platPath));
                        if (checkDir == null) {
                            BDirectory dir = fs.makeDir(dbPath);
                            this.dbDir = ((BLocalFileStore)dir.getStore()).getLocalFile();
                        } else {
                            this.dbDir = ((BLocalFileStore)checkDir.getStore()).getLocalFile();
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        if (Sys.getStation() != null) {
                            log.warning("No system platform service available, using station home directory for alarm database root.");
                            this.dbDir = new File(Sys.getNiagaraUserHome().getAbsolutePath() + File.separatorChar + "stations" + File.separatorChar + Sys.getStation().getStationName() + File.separatorChar + ARCHIVE_ID);
                        }
                        log.warning("No system platform service available, using Niagara home directory for alarm database root.");
                        this.dbDir = new File(Sys.getNiagaraHome().getAbsolutePath() + File.separatorChar + ARCHIVE_ID);
                    }
                }
                if (!this.dbDir.exists()) {
                    this.dbDir.mkdirs();
                }
                this.alarmFile = new File(this.dbDir, "alarm.adb");
                if (!this.alarmFile.exists()) {
                    this.alarmFile.createNewFile();
                }
                int errorCount = 0;
                while (true) {
                    try {
                        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                        BAlarmDbConfig cfg = alarmService.getAlarmDbConfig();
                        if (cfg instanceof BFileAlarmDbConfig) {
                            this.capacity = ((BFileAlarmDbConfig)cfg).getCapacity();
                        }
                        this.alarmStore = new AlarmStore(this.alarmFile, this.capacity);
                        this.alarmStore.open();
                    }
                    catch (Exception e) {
                        BAlarmDatabase.log.log(Level.SEVERE, "Cannot open alarm database.", e);
                        if (!this.alarmFile.exists() || ++errorCount == 2) break;
                        boolean deleteAlarmDB = false;
                        try {
                            BSystemPlatformService plat = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                            if (plat instanceof BSystemPlatformServiceNpsdk || plat instanceof BSystemPlatformServiceQnx) {
                                deleteAlarmDB = true;
                            }
                        }
                        catch (ServiceNotFoundException ignore) {
                            deleteAlarmDB = true;
                        }
                        if (deleteAlarmDB) {
                            if (this.alarmFile.delete()) {
                                BAlarmDatabase.log.severe("Old alarm database deleted.");
                                continue;
                            }
                            throw new IOException("Unable to delete old alarm database.");
                        }
                        File recoveryFile = this.saveErrorDb();
                        if (recoveryFile == null) continue;
                        BAlarmDatabase.log.log(Level.SEVERE, "Old alarm database saved as " + recoveryFile.getAbsolutePath() + ".");
                        continue;
                    }
                    break;
                }
                this.alarmServiceOrd = Sys.getService((Type)BAlarmService.TYPE).getOrdInSession();
                try {
                    this.dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
                    if (!this.dataRecoveryService.isEnabled()) {
                        this.dataRecoveryService = null;
                    }
                }
                catch (ServiceNotFoundException serviceNotFoundException) {
                    // empty catch block
                }
                AccessController.doPrivileged(() -> Nre.getServiceManager()).addServiceListener(this.serviceListener);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private File saveErrorDb() throws IOException {
        String[] dbFiles = this.dbDir.list();
        int count = 0;
        for (int i = 0; i < dbFiles.length; ++i) {
            if (dbFiles[i].indexOf("error") != -1) {
                ++count;
            }
            if (count != 3) continue;
            throw new IOException("Cannot create recovery file.  " + count + " recovery files already exist.");
        }
        File renameFile = new File(this.dbDir, "alarm_error.adb");
        if (renameFile.exists()) {
            int index = 2;
            while (renameFile.exists()) {
                renameFile = new File(this.dbDir, "alarm_error" + index + ".adb");
                ++index;
            }
        }
        if (!this.alarmFile.renameTo(renameFile)) {
            throw new IOException("Unable to create recovery file.");
        }
        return renameFile;
    }

    @Override
    public void doSave() throws IOException {
        block4: {
            try {
                BSystemPlatformService plat = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                if (!plat.archiveEnabled(ARCHIVE_ID)) break block4;
                try {
                    AccessController.doPrivileged(() -> {
                        FileArchive archive = plat.createFileArchive(ARCHIVE_ID);
                        String dbDirPath = this.dbDir.getAbsolutePath();
                        String relPath = this.alarmFile.getAbsolutePath().substring(dbDirPath.length() + 1);
                        archive.writeFile(this.alarmFile, relPath);
                        archive.close();
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
            }
            catch (ServiceNotFoundException ex) {
                log.severe("No system platform service available, cannot create alarm archive file.");
                throw new IOException("Could not create alarm archive file.");
            }
        }
    }

    @Override
    public void doFlush() throws IOException {
        this.alarmStore.flush();
    }

    @Override
    public void doClose() {
        this.alarmStore.close();
        this.alarmStore = null;
    }

    @Override
    public void updateConfig(BAlarmDbConfig config, Property p) throws AlarmException {
        if (config instanceof BFileAlarmDbConfig && p.equals(BFileAlarmDbConfig.capacity)) {
            try {
                this.setCapacity(((BFileAlarmDbConfig)config).getCapacity());
            }
            catch (IOException ioe) {
                throw new AlarmException("Cannot update alarm database capacity.", ioe);
            }
        }
    }

    public void setCapacity(int newCapacity) throws IOException {
        if (this.capacity == newCapacity) {
            return;
        }
        DataRecoveryAlarmEvent.CapacityChange event = null;
        try {
            if (this.dataRecoveryService != null) {
                event = new DataRecoveryAlarmEvent.CapacityChange(newCapacity);
                if (dataRecoveryLog.isLoggable(Level.FINE)) {
                    dataRecoveryLog.fine("Recording alarm event '" + event + "'");
                }
                this.dataRecoveryService.append((BIDataRecoverySource)this, EMPTY_KEY, ((DataRecoveryAlarmEvent)event).encode());
            }
        }
        catch (DataRecoveryServiceInFaultException drsife) {
            this.dataRecoveryService = null;
            dataRecoveryLog.log(Level.WARNING, "DataRecoveryService in fault, could not append alarm event '" + event + "'. Stopped data recovery alarm recording.", drsife);
        }
        catch (Throwable e) {
            dataRecoveryLog.log(Level.SEVERE, "DataRecoveryService could not record alarm event '" + event + "'", e);
        }
        this.capacity = newCapacity;
        if (!this.isOpen()) {
            return;
        }
        this.alarmStore.setCapacity(this.capacity);
        this.alarmStore.trimToCapacity();
    }

    public void dataRecoveryRestoreComplete() {
    }

    public boolean dataRecoveryRestore(IDataRecoveryRecord dataRecoveryRecord) throws Exception {
        DataRecoveryAlarmEvent privilegedEvent = DataRecoveryAlarmEvent.make(dataRecoveryRecord.getData());
        boolean restored = false;
        try {
            restored = AccessController.doPrivileged(() -> {
                try {
                    if (dataRecoveryLog.isLoggable(Level.FINE)) {
                        dataRecoveryLog.fine("Restoring alarm event " + privilegedEvent);
                    }
                    privilegedEvent.execute(this);
                    return true;
                }
                catch (Exception ex) {
                    if (privilegedEvent != null) {
                        dataRecoveryLog.log(Level.SEVERE, "DataRecoveryService could not restore alarm event " + privilegedEvent, ex);
                    } else {
                        dataRecoveryLog.log(Level.SEVERE, "DataRecoveryService could not restore null alarm event", ex);
                    }
                    throw ex;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return restored;
    }

    public void dataRecoverySpy(SpyWriter out, Iterator<IDataRecoveryRecord> iterator) throws Exception {
        int totalEvents = 0;
        byte[] recordData = null;
        HashMap<Integer, DataRecoveryAlarmSizeSpyData> map = new HashMap<Integer, DataRecoveryAlarmSizeSpyData>();
        ArrayList<DataRecoveryAlarmEventSpyData> list = new ArrayList<DataRecoveryAlarmEventSpyData>();
        while (iterator.hasNext()) {
            ++totalEvents;
            IDataRecoveryRecord record = iterator.next();
            recordData = record.getData();
            DataRecoveryAlarmEvent event = DataRecoveryAlarmEvent.make(recordData);
            Integer eventCode = event.getEventCode();
            DataRecoveryAlarmSizeSpyData data = (DataRecoveryAlarmSizeSpyData)map.get(eventCode);
            if (data == null) {
                map.put(eventCode, new DataRecoveryAlarmSizeSpyData(recordData.length));
            } else {
                map.put(eventCode, data.addEvent(recordData.length));
            }
            list.add(new DataRecoveryAlarmEventSpyData(event, recordData.length));
        }
        Iterator keys = map.keySet().iterator();
        String title = totalEvents + " Alarm Events Recently Recorded in Data Recovery";
        out.startTable(true);
        out.trTitle((Object)title, 4);
        out.w((Object)"<tr><th>Event</th><th>Occurrences</th><th>Total Bytes</th><th>Avg Bytes</th></tr>\n");
        while (keys.hasNext()) {
            String eventType;
            Integer eventCode = (Integer)keys.next();
            DataRecoveryAlarmSizeSpyData data = (DataRecoveryAlarmSizeSpyData)map.get(eventCode);
            switch (eventCode) {
                case 0: {
                    eventType = "Append";
                    break;
                }
                case 1: {
                    eventType = "Update";
                    break;
                }
                case 2: {
                    eventType = "ClearAll";
                    break;
                }
                case 3: {
                    eventType = "ClearOld";
                    break;
                }
                case 4: {
                    eventType = "ClearRecord";
                    break;
                }
                case 5: {
                    eventType = "CapacityChange";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown alarm event code: '" + eventCode + "'");
                }
            }
            out.tr((Object)eventType, (Object)("" + data.occurrences), (Object)("" + data.totalBytes), (Object)("" + (double)data.totalBytes / (double)data.occurrences));
        }
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"Events Encountered", 2);
        out.w((Object)"<tr><th>Event Size</th><th>Event</th></tr>\n");
        for (DataRecoveryAlarmEventSpyData encounteredEvent : list) {
            out.tr((Object)encounteredEvent.size, (Object)encounteredEvent.event.toString());
        }
        out.endTable();
    }

    private BIDataRecoveryService getDataRecoveryService() {
        if (this.dataRecoveryService == null) {
            try {
                this.dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
                if (!this.dataRecoveryService.isEnabled()) {
                    this.dataRecoveryService = null;
                }
            }
            catch (ServiceNotFoundException se) {
                this.dataRecoveryService = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.dataRecoveryService;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 21: {
                ((ResourceReport)a).add(ARCHIVE_ID, this.countResourceUnits());
                break;
            }
            case 602: {
                return this.alarmStore;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private int countResourceUnits() {
        return this.capacity;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private static class DataRecoveryAlarmEventSpyData {
        DataRecoveryAlarmEvent event = null;
        int size = -1;

        public DataRecoveryAlarmEventSpyData(DataRecoveryAlarmEvent event, int size) {
            this.event = event;
            this.size = size;
        }
    }

    private static class DataRecoveryAlarmSizeSpyData {
        int occurrences = 1;
        int totalBytes = -1;

        public DataRecoveryAlarmSizeSpyData(int bytes) {
            this.totalBytes = bytes;
        }

        public DataRecoveryAlarmSizeSpyData addEvent(int bytes) {
            ++this.occurrences;
            this.totalBytes += bytes;
            return this;
        }
    }
}

