/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import com.tridium.alarm.db.file.SkipList;
import java.util.HashMap;
import java.util.Map;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class AlarmSourceIndex {
    private static final BFacets showSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    private HashMap<BOrdList, SourceList> table = new HashMap(1001);
    private double probability;
    private int maxSizePerSource;

    public AlarmSourceIndex(double probability, int maxSizePerSource) {
        this.probability = probability;
        this.maxSizePerSource = maxSizePerSource;
    }

    public synchronized IndexEntry getListForSource(BOrdList source) {
        SourceList list = this.table.get(source);
        if (list == null) {
            return null;
        }
        return list.getFirstEntry();
    }

    public synchronized IndexEntry getLastForSource(BOrdList source) {
        SourceList list = this.table.get(source);
        if (list == null) {
            return null;
        }
        return list.getLastEntry();
    }

    public synchronized void add(BOrdList source, IndexEntry entry) {
        SourceList list = this.table.get(source);
        if (list == null) {
            list = new SourceList(this.probability, this.maxSizePerSource);
            this.table.put(source, list);
            list.add(entry);
        } else {
            list.add(entry);
        }
    }

    public synchronized void remove(BOrdList source, IndexEntry entry) {
        SourceList list = this.table.get(source);
        if (list == null) {
            return;
        }
        list.remove(entry);
    }

    public int getSize() {
        return this.table.size();
    }

    public IndexEntry getNext(IndexEntry entry) {
        return entry.nextSource[0];
    }

    public Map<BOrdList, SkipList> getTable() {
        HashMap<BOrdList, SkipList> copy = new HashMap<BOrdList, SkipList>();
        copy.putAll(this.table);
        return copy;
    }

    private class SourceList
    extends SkipList {
        public SourceList(double probability, int maxSize) {
            super(probability, maxSize);
        }

        @Override
        public int compare(IndexEntry entry1, IndexEntry entry2) {
            int tscomp = entry1.timestamp.compareTo((Object)entry2.timestamp);
            if (tscomp == 0) {
                return entry1.pageIndex - entry2.pageIndex;
            }
            return tscomp;
        }

        @Override
        public int compareToKey(IndexEntry entry1, Object key) {
            return entry1.timestamp.compareTo(key);
        }

        @Override
        public int getLevel(IndexEntry entry) {
            return entry.nextSource.length;
        }

        @Override
        public void setLevel(IndexEntry entry, int level) {
            entry.nextSource = new IndexEntry[level];
        }

        @Override
        public IndexEntry getNext(IndexEntry entry, int level) {
            if (entry.nextSource == null || entry.nextSource.length <= level) {
                return null;
            }
            return entry.nextSource[level];
        }

        @Override
        public void setNext(IndexEntry entry, int level, IndexEntry nextEntry) {
            if (entry.nextSource == null) {
                this.setLevel(entry, level);
            }
            entry.nextSource[level] = nextEntry;
        }

        @Override
        public IndexEntry getPrev(IndexEntry entry) {
            return entry.prevSource;
        }

        @Override
        public void setPrev(IndexEntry entry, IndexEntry prevEntry) {
            entry.prevSource = prevEntry;
        }

        @Override
        public String entryToString(IndexEntry entry) {
            return entry.timestamp.toString((Context)BAlarmRecord.TIMESTAMP_FACETS) + " => " + entry.pageIndex;
        }
    }
}

