/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class AckPendingIndex {
    private static final BFacets showSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    private IndexEntry first = null;
    private IndexEntry last = null;
    private int size = 0;

    public int getSize() {
        return this.size;
    }

    public IndexEntry getFirstEntry() {
        return this.first;
    }

    public void add(IndexEntry entry) {
        if (entry.isAckPending()) {
            return;
        }
        entry.setAckPending(true);
        entry.nextAckPending = null;
        entry.prevAckPending = null;
        if (this.size == 0) {
            this.first = this.last = entry;
        } else {
            IndexEntry temp = entry.prevTimestamp;
            while (temp != null && !temp.isAckPending()) {
                temp = temp.prevTimestamp;
            }
            if (temp == null) {
                if (this.first == null) {
                    this.first = this.last = entry;
                } else {
                    entry.nextAckPending = this.first;
                    this.first.prevAckPending = entry;
                    this.first = entry;
                }
            } else {
                entry.nextAckPending = temp.nextAckPending;
                entry.prevAckPending = temp;
                if (temp.nextAckPending != null) {
                    temp.nextAckPending.prevAckPending = entry;
                }
                temp.nextAckPending = entry;
                if (entry.prevAckPending == this.last) {
                    this.last = entry;
                }
            }
        }
        ++this.size;
    }

    public void remove(IndexEntry entry) {
        if (this.size == 0 || entry == null) {
            return;
        }
        if (!entry.isAckPending()) {
            return;
        }
        entry.setAckPending(false);
        if (entry.prevAckPending != null) {
            entry.prevAckPending.nextAckPending = entry.nextAckPending;
        }
        if (entry.nextAckPending != null) {
            entry.nextAckPending.prevAckPending = entry.prevAckPending;
        }
        if (entry == this.first) {
            this.first = entry.nextAckPending;
        }
        if (entry == this.last) {
            this.last = entry.prevAckPending;
        }
        entry.nextAckPending = null;
        entry.prevAckPending = null;
        --this.size;
    }

    public void dump() {
        IndexEntry temp = this.first;
        int i = 0;
        while (temp != null) {
            System.out.println(i++ + ") " + temp.timestamp.toString((Context)showSecs) + " ackPending=" + temp.isAckPending());
            temp = temp.nextAckPending;
        }
    }

    public void verify() {
        IndexEntry prev = null;
        IndexEntry temp = this.first;
        int count = 0;
        while (temp != null) {
            ++count;
            if (prev != null && prev.timestamp.isAfter(temp.timestamp)) {
                throw new IllegalStateException("Invalid ascending order.  " + temp.timestamp.toString((Context)showSecs) + " is before " + prev.timestamp.toString((Context)showSecs));
            }
            if (!temp.isAckPending()) {
                throw new IllegalStateException("Cleared alarm in ackPending index, ascending. " + temp.timestamp.toString((Context)showSecs));
            }
            prev = temp;
            temp = temp.nextAckPending;
        }
        if (this.size != count) {
            throw new IllegalStateException("Invalid ascending count. size=" + this.size + ", count=" + count);
        }
        prev = null;
        temp = this.last;
        count = 0;
        while (temp != null) {
            ++count;
            if (prev != null && prev.timestamp.isBefore(temp.timestamp)) {
                throw new IllegalStateException("Invalid descending order.  " + temp.timestamp.toString((Context)showSecs) + " is after " + prev.timestamp.toString((Context)showSecs));
            }
            if (!temp.isAckPending()) {
                throw new IllegalStateException("Cleared alarm in ackPending index, descending. " + temp.timestamp.toString((Context)showSecs));
            }
            prev = temp;
            temp = temp.prevAckPending;
        }
        if (this.size != count) {
            throw new IllegalStateException("Invalid descending count. size=" + this.size + ", count=" + count);
        }
    }
}

