/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db;

import com.tridium.alarm.db.AlarmQuery;
import com.tridium.alarm.db.BIAlarmResolver;
import javax.baja.agent.BIAgent;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public final class BLocalAlarmResolver
extends BSingleton
implements BIAlarmResolver,
BIAgent {
    public static final BLocalAlarmResolver INSTANCE = new BLocalAlarmResolver();
    public static final Type TYPE = Sys.loadType(BLocalAlarmResolver.class);

    private BLocalAlarmResolver() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OrdTarget resolve(BISession session, OrdTarget base, AlarmQuery query) {
        BOrd serviceOrd = BOrd.make((String)"service:alarm:AlarmService");
        BAlarmService alarmService = (BAlarmService)serviceOrd.resolve(base.get()).get();
        try {
            if (query.isDbQuery()) {
                return new OrdTarget(base, (BObject)alarmService.getAlarmDb());
            }
            String uuid = query.getQueryParameter("uuid", null);
            if (uuid == null) throw new UnresolvedException("Invalid alarm query: " + query);
            try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
                BAlarmRecord rec = conn.getRecord(BUuid.make((String)uuid));
                if (rec == null) {
                    throw new UnresolvedException(uuid);
                }
                OrdTarget ordTarget = new OrdTarget(base, (BObject)rec);
                return ordTarget;
            }
        }
        catch (UnresolvedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnresolvedException("Cannot access alarm database.", (Throwable)e);
        }
    }

    public Type getType() {
        return TYPE;
    }
}

