/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.Index;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.nre.util.Array;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.rdb.ddl.BOnDelete;
import javax.baja.rdb.ddl.Column;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.rdb.ddl.CreateIndex;
import javax.baja.rdb.ddl.CreateSequence;
import javax.baja.rdb.ddl.CreateTable;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.rdb.ddl.DropSequence;
import javax.baja.rdb.ddl.DropTable;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class TableBuilder {
    private static final int FINDEXED = 2;
    private static final int FUNIQUE = 4;
    private static final int FCLOB = 8;
    private static final int FWIDTH = 16;
    private BOrionDatabase db;
    private OrionType type;
    private RdbmsDialect dialect;
    private BIOrionObject instance;
    private String tableName;
    private Property[] properties;
    private Property identity;

    public TableBuilder(BOrionDatabase db, OrionType type) {
        this.db = db;
        this.type = type;
        this.dialect = (RdbmsDialect)db.getRdbms().getRdbmsContext();
        this.instance = (BIOrionObject)type.getInstance();
        this.properties = type.getPersistentProperties();
        this.tableName = db.getTableName(type);
        this.identity = null;
        for (int i = 0; i < this.properties.length; ++i) {
            if (!BOrionObject.isIdentity(this.properties[i])) continue;
            if (this.identity == null) {
                this.identity = this.properties[i];
                continue;
            }
            throw new OrionException("Only one identity column per table is allowed: " + this.properties[i].getName());
        }
    }

    public DdlCommand[] createTable() {
        Array arr = new Array(DdlCommand.class);
        arr.add((Object)new CreateTable(this.getTableName(), this.makeColumns(), this.makeConstraints()));
        if (this.dialect.getInsertionMode() == 0 && this.identity != null) {
            arr.add((Object)new CreateSequence(this.dialect.getSequenceName(this.getTableName())));
        }
        arr.addAll((Object[])this.makeSingleColumnIndexes());
        arr.addAll((Object[])this.makeExtraIndexes());
        return (DdlCommand[])arr.trim();
    }

    public DdlCommand[] dropTable() {
        Array arr = new Array(DdlCommand.class);
        arr.add((Object)new DropTable(this.getTableName()));
        if (this.dialect.getInsertionMode() == 0 && this.identity != null) {
            arr.add((Object)new DropSequence(this.dialect.getSequenceName(this.getTableName())));
        }
        return (DdlCommand[])arr.trim();
    }

    private Column[] makeColumns() {
        Column[] cols = new Column[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            Property prop = this.properties[i];
            if (BOrionObject.isIdentity(prop)) {
                TableBuilder.checkFacets("IDENTITY", prop, 30);
                if (!prop.getType().is(BInteger.TYPE)) {
                    throw new OrionException("IDENTITY property must be of type BInteger: " + prop);
                }
                cols[i] = Column.makeIdentity((String)prop.getName(), (boolean)BOrionObject.isKey(prop));
                continue;
            }
            if (BOrionObject.isKey(prop)) {
                TableBuilder.checkFacets("KEY", prop, 14);
                cols[i] = Column.makeKey((String)prop.getName(), (Type)prop.getType(), (BValue)this.instance.get(prop), (int)BOrionObject.getWidth(prop));
                continue;
            }
            if (BOrionObject.isUnique(prop)) {
                TableBuilder.checkFacets("UNIQUE", prop, 10);
                cols[i] = Column.makeUnique((String)prop.getName(), (Type)prop.getType(), (BValue)this.instance.get(prop), (int)BOrionObject.getWidth(prop));
                continue;
            }
            if (BOrionObject.isClob(prop)) {
                TableBuilder.checkFacets("CLOB", prop, 18);
                if (!prop.getType().is(BString.TYPE)) {
                    throw new OrionException("CLOB property must be of type BString: " + prop);
                }
                cols[i] = Column.makeClob((String)prop.getName());
                continue;
            }
            cols[i] = Column.make((String)prop.getName(), (Type)prop.getType(), (BValue)this.instance.get(prop), (int)BOrionObject.getWidth(prop));
        }
        return cols;
    }

    private static void checkFacets(String name, Property prop, int flags) {
        if ((flags & 2) != 0) {
            if (BOrionObject.isIndexed(prop)) {
                throw new OrionException(name + " property should not specify INDEXED: " + prop);
            }
        } else if ((flags & 4) != 0) {
            if (BOrionObject.isUnique(prop)) {
                throw new OrionException(name + " property should not specify UNIQUE: " + prop);
            }
        } else if ((flags & 8) != 0) {
            if (BOrionObject.isClob(prop)) {
                throw new OrionException(name + " property should not specify CLOB: " + prop);
            }
        } else if ((flags & 0x10) != 0 && BOrionObject.getWidth(prop) != -1) {
            throw new OrionException(name + " property should not specify WIDTH: " + prop);
        }
    }

    public Constraint[] makeConstraints() {
        int i;
        Array cons = new Array(Constraint.class);
        Property[] ids = this.type.getKey();
        String[] idNames = new String[ids.length];
        for (int i2 = 0; i2 < ids.length; ++i2) {
            idNames[i2] = ids[i2].getName();
        }
        BClustered clustered = BClustered.unspecified;
        for (i = 0; i < ids.length; ++i) {
            if (!BOrionObject.isClustered(ids[i]).equals((Object)BClustered.nonClustered)) continue;
            clustered = BClustered.nonClustered;
            break;
        }
        cons.add((Object)Constraint.makePrimaryKey((String)this.db.getConstraintName(this.type, null, "PK", true), (String[])idNames, (BClustered)clustered));
        for (i = 0; i < this.properties.length; ++i) {
            Property prop = this.properties[i];
            if (prop.getType() == BRef.TYPE) {
                cons.add((Object)this.makeForeignKeyConstraint(prop));
                continue;
            }
            if (!BOrionObject.isUnique(prop)) continue;
            cons.add((Object)Constraint.makeUnique((String)this.db.getConstraintName(this.type, prop, "UQ", false), (String[])new String[]{prop.getName()}, (BClustered)BOrionObject.isClustered(prop)));
        }
        return (Constraint[])cons.trim();
    }

    private Constraint makeForeignKeyConstraint(Property property) {
        BRef ref = (BRef)property.getDefaultValue();
        BTypeSpec targetSpec = ref.getTargetTypeSpec();
        OrionType targetType = (OrionType)targetSpec.getResolvedType();
        Property[] targetKey = targetType.getKey();
        if (targetKey.length != 1) {
            throw new OrionException("Ref targets must have exactly one key column");
        }
        return Constraint.makeForeignKey((String)this.db.getConstraintName(this.type, property, "FK", false), (String)property.getName(), (String)this.db.getTableName(targetType), (String)targetKey[0].getName(), (BOnDelete)BOrionObject.getOnDelete(property));
    }

    public CreateIndex[] makeSingleColumnIndexes() {
        Array arr = new Array(CreateIndex.class);
        for (int i = 0; i < this.properties.length; ++i) {
            Property prop = this.properties[i];
            if (!BOrionObject.isIndexed(prop)) continue;
            arr.add((Object)new CreateIndex(this.db.getIndexName(this.type, prop), this.getTableName(), BOrionObject.isUnique(prop), BOrionObject.isClustered(prop), new CreateIndex.Column[]{new CreateIndex.Column(prop.getName(), BOrionObject.isDescending(prop))}));
        }
        return (CreateIndex[])arr.trim();
    }

    public CreateIndex[] makeExtraIndexes() {
        Array arr = new Array(CreateIndex.class);
        Index[] indexes = this.instance.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i].getName().length() > this.dialect.getMaxIndexName()) {
                throw new OrionException("Index name '" + indexes[i].getName() + "' is too long.");
            }
            arr.add((Object)TableBuilder.makeIndex(indexes[i], this.getTableName()));
        }
        return (CreateIndex[])arr.trim();
    }

    private static CreateIndex makeIndex(Index index, String tableName) {
        return new CreateIndex(index.getName(), tableName, index.isUnique(), TableBuilder.makeColumns(index));
    }

    private static CreateIndex.Column[] makeColumns(Index index) {
        Property[] props = index.getProperties();
        CreateIndex.Column[] columns = new CreateIndex.Column[props.length];
        for (int i = 0; i < props.length; ++i) {
            columns[i] = new CreateIndex.Column(props[i].getName(), BOrionObject.isDescending(props[i]));
        }
        return columns;
    }

    public String getTableName() {
        return this.tableName;
    }
}

