/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.logging.LogSettings;
import com.tridium.orion.OrionCursor;
import com.tridium.sys.Nre;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;

public class OrionCursorManager {
    private static final Logger logger = Logger.getLogger("orion.cursorManager");
    private static long count = 0L;
    private static long totalCount = 0L;
    private static long peakActiveCount = 0L;
    private static final int CLOSED_MAX_ENTRIES = 10;
    private static final int OPEN_STACK_DEFAULT_CAPACITY = 1024;
    private static final int OPEN_STACK_MAX_CAPACITY = 131072;
    private static BAbsTime peakActiveTime = BAbsTime.DEFAULT;
    private static final Map<String, TimedStackTrace> openStacks = Collections.synchronizedMap(new StackMap(OrionCursorManager.getOpenStackCapacity()));
    private static final Map<String, TimedStackTrace> peakStacks = Collections.synchronizedMap(new HashMap());
    private static final Map<String, TimedStackTrace> closedStacks = Collections.synchronizedMap(new StackMap(10));
    private static final List<TimedStackTrace> longestStacks = Collections.synchronizedList(new ArrayList());

    public OrionCursorManager() {
        SummaryPage summary = new SummaryPage();
        Nre.spySysManagers.add("orionCursorManager", (Spy)summary);
    }

    public static String getCursorId(OrionCursor cursor) {
        return String.valueOf(System.identityHashCode(cursor));
    }

    public void openSpy(OrionCursor cursor) {
        if (!OrionCursorManager.isLogLevelFineOrFinest()) {
            return;
        }
        totalCount = Long.MAX_VALUE > totalCount ? ++totalCount : ++count;
        try {
            throw new Exception("OpenStackTrace");
        }
        catch (Exception e) {
            openStacks.put(OrionCursorManager.getCursorId(cursor), new TimedStackTrace(e));
            if (count > peakActiveCount) {
                peakActiveTime = BAbsTime.now();
                peakActiveCount = count;
                peakStacks.clear();
                peakStacks.putAll(openStacks);
            }
            return;
        }
    }

    public void closeSpy(OrionCursor cursor) {
        if (!OrionCursorManager.isLogLevelFineOrFinest()) {
            return;
        }
        String cursorId = OrionCursorManager.getCursorId(cursor);
        TimedStackTrace timedTrace = openStacks.remove(cursorId);
        if (timedTrace != null) {
            --count;
        } else {
            timedTrace = new TimedStackTrace(null);
        }
        try {
            throw new Exception("ClosedStackTrace");
        }
        catch (Exception e) {
            BRelTime relTime;
            timedTrace.setClose(e);
            closedStacks.put(cursorId, timedTrace);
            if (peakStacks.get(cursorId) != null) {
                peakStacks.put(cursorId, timedTrace);
            }
            if ((relTime = timedTrace.delta()).getMillis() > 0L) {
                longestStacks.add(timedTrace);
                Collections.sort(longestStacks);
                if (longestStacks.size() >= 10) {
                    longestStacks.remove(9);
                }
            }
            return;
        }
    }

    static boolean isLogLevelFineOrFinest() {
        return logger.isLoggable(Level.FINE) || logger.isLoggable(Level.FINEST);
    }

    public static long getPeakActiveCount() {
        return peakActiveCount;
    }

    private static int getOpenStackCapacity() {
        if (logger.isLoggable(Level.FINEST)) {
            return 131072;
        }
        if (logger.isLoggable(Level.FINE)) {
            try {
                return Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("orion.OrionCursorManager.openStackCapacity", String.valueOf(1024))));
            }
            catch (NumberFormatException e) {
                return 1024;
            }
        }
        return 0;
    }

    private static class StackMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;
        private static final long serialVersionUID = -4124160500880735821L;

        public StackMap(int initialCapacity) {
            super(initialCapacity, 1.0f);
            this.maxSize = initialCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }

    static class TimedStackTrace
    implements Comparable<TimedStackTrace> {
        BAbsTime openTime = BAbsTime.now();
        BAbsTime closeTime;
        Exception openTrace;
        Exception closeTrace;

        TimedStackTrace(Exception openTrace) {
            this.openTrace = openTrace;
        }

        void setClose(Exception trace) {
            this.closeTime = BAbsTime.now();
            this.closeTrace = trace;
        }

        @Override
        public int compareTo(TimedStackTrace o) {
            return o.delta().compareTo((Object)this.delta());
        }

        BRelTime delta() {
            if (this.closeTime != null) {
                return this.openTime.delta(this.closeTime);
            }
            return this.openTime.delta(BAbsTime.now());
        }
    }

    private static final class MessageSpy
    extends SpyDir {
        String message;

        private MessageSpy(String message) {
            this.message = message;
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps();
            out.propValueLink((Object)this.message, (Object)"..", (Object)"Return to Orion Cursor Manager");
            out.endProps();
        }
    }

    public static class SummaryPage
    extends SpyDir {
        public SummaryPage() {
            this.add("closed", (Spy)new ClosedSpy());
            this.add("peakStacks", (Spy)new PeakStacksSpy());
            this.add("longestClosed", (Spy)new LongestClosedSpy());
        }

        public Spy find(String name) {
            if ("closed".equals(name) || "peakStacks".equals(name) || "longestClosed".equals(name)) {
                return super.find(name);
            }
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"finest")) {
                if (!logger.isLoggable(Level.FINEST)) {
                    try {
                        LogSettings logSettings = new LogSettings();
                        logSettings.setLogLevel("orion.cursorManager", Level.FINEST);
                        LogSettings.reload((Properties)logSettings.getRawProperties());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new MessageSpy("Cannot set the log level:" + e.toString());
                    }
                }
                return new MessageSpy("Orion Cursor Manager is now active");
            }
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"fine")) {
                if (!logger.isLoggable(Level.FINE)) {
                    try {
                        LogSettings logSettings = new LogSettings();
                        logSettings.setLogLevel("orion.cursorManager", Level.FINE);
                        LogSettings.reload((Properties)logSettings.getRawProperties());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new MessageSpy("Cannot set the log level:" + e.toString());
                    }
                }
                return new MessageSpy("Orion Cursor Manager is now active");
            }
            String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)namePart)) {
                return super.find(namePart);
            }
            return super.find(name);
        }

        public void write(SpyWriter out) throws Exception {
            if (OrionCursorManager.isLogLevelFineOrFinest() && OrionCursorManager.getOpenStackCapacity() - openStacks.size() < 10) {
                out.startProps("Cursor Manager size limit is reached. The stack might have stale data. Restart station to track current cursors.");
                out.endProps();
            }
            out.startProps("Closed Stats");
            if (!OrionCursorManager.isLogLevelFineOrFinest()) {
                out.propValueLink((Object)"Orion Cursor Manager Not Active", (Object)("spy:/sysManagers/orionCursorManager/" + SpyWriter.addCsrfToken((String)"fine")), (Object)"Click here to save the orion.cursorManager Log Level as 'fine'.When set as 'fine', the open stack size limit is the value set for the system property orion.OrionCursorManager.openStackCapacity, by default it is set to 1024.");
                out.propValueLink((Object)"", (Object)("spy:/sysManagers/orionCursorManager/" + SpyWriter.addCsrfToken((String)"finest")), (Object)"Click here to save the orion.cursorManager Log Level as 'finest'When set as 'Finest', the open stack size limit is 131,072.");
                out.endProps();
                return;
            }
            out.prop((Object)"Closed Count", (Object)String.valueOf(totalCount - count));
            out.propValueLink((Object)"Recently Closed Stack Traces", (Object)"closed", (Object)"View");
            out.propValueLink((Object)"Longest Closed Stack Traces", (Object)"longestClosed", (Object)"View");
            out.endProps();
            out.startProps("Peak Open Stats");
            out.prop((Object)"Peak Open Count", (Object)String.valueOf(peakActiveCount));
            out.prop((Object)"Peak Open Time", (Object)String.valueOf(peakActiveTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true))));
            out.propValueLink((Object)"Peak Open Stack Traces", (Object)"peakStacks", (Object)"View");
            out.endProps();
            out.startProps("Currently Open Stats");
            Collection collection = openStacks.values();
            Set keySet = openStacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            out.prop((Object)"Open Stack Capacity", OrionCursorManager.getOpenStackCapacity());
            out.prop((Object)"Current Open Stack Size", (Object)String.valueOf(keys.length));
            out.prop((Object)"Open Count", (Object)String.valueOf(count));
            if (count != (long)keys.length) {
                out.prop((Object)"Acknowledged Open Count", (Object)String.valueOf(count - (long)keys.length));
            }
            for (int j = array.length - 1; j >= 0; --j) {
                String[] lines;
                RemoveSpy removeSpy = new RemoveSpy(keys[j], String.valueOf(j), openStacks);
                this.add(String.valueOf(j), (Spy)removeSpy);
                out.propValueLink((Object)("Open Cursor " + keys[j]), (Object)SpyWriter.addCsrfToken((String)String.valueOf(j)), (Object)"Acknowledge");
                TimedStackTrace timedTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Open Time ", (Object)timedTrace.delta());
                Exception lastStack = timedTrace.openTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                for (String line : lines = TextUtil.split((String)((Object)result).toString(), (char)'\n')) {
                    out.prop((Object)"", (Object)line);
                }
            }
            out.endProps();
        }
    }

    public static class PeakStacksSpy
    extends SpyDir {
        public PeakStacksSpy() {
            this.add("resetStats", (Spy)new RemoveAllSpy("resetStats", "Peak Stats Reset", "Return to Peak Stats", peakStacks));
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"resetStats")) {
                return super.find("resetStats");
            }
            return super.find(name);
        }

        public void write(SpyWriter out) {
            out.startProps();
            Collection collection = peakStacks.values();
            Set keySet = peakStacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            out.prop((Object)"Peak Open Time", (Object)peakActiveTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
            out.prop((Object)"Peak Open Stacks Count", (Object)String.valueOf(keys.length));
            if (peakActiveCount != (long)keys.length) {
                peakActiveCount = keys.length;
            }
            if (array.length > 1) {
                out.propValueLink((Object)"", (Object)SpyWriter.addCsrfToken((String)"resetStats"), (Object)"Reset Stats");
            }
            for (int j = array.length - 1; j >= 0; --j) {
                String[] lines;
                TimedStackTrace timeTrace = (TimedStackTrace)array[j];
                if (timeTrace.closeTrace == null) {
                    out.prop((Object)("Open Cursor " + keys[j]), (Object)"");
                } else {
                    out.prop((Object)("Closed Cursor " + keys[j]), (Object)"");
                }
                if (timeTrace.closeTrace == null) {
                    out.prop((Object)"Time Cursor has been Open ", (Object)timeTrace.delta());
                } else {
                    out.prop((Object)"Time Cursor was Open ", (Object)timeTrace.delta());
                }
                Exception lastStack = timeTrace.openTrace;
                if (lastStack == null) continue;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                for (String line : lines = TextUtil.split((String)((Object)result).toString(), (char)'\n')) {
                    out.prop((Object)"", (Object)line);
                }
            }
            out.endProps();
        }

        public String getTitle() {
            return "peakStacks";
        }
    }

    public static class LongestClosedSpy
    extends SpyDir {
        public LongestClosedSpy() {
            this.add("removeAllLongest", (Spy)new RemoveAllLongSpy("removeAllLongest", "Longest Stack Traces Reset", "Return"));
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"removeAllLongest")) {
                return super.find("removeAllLongest");
            }
            return super.find(name);
        }

        public void write(SpyWriter out) {
            out.startProps();
            out.propValueLink((Object)"", (Object)SpyWriter.addCsrfToken((String)"removeAllLongest"), (Object)"Reset Longest");
            Object[] array = longestStacks.toArray();
            for (int j = 0; j < array.length; ++j) {
                String[] lines;
                out.prop((Object)("Closed Cursor " + j), (Object)"");
                TimedStackTrace timeTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Time Cursor was Open ", (Object)timeTrace.delta());
                out.prop((Object)"Close Time", (Object)timeTrace.closeTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
                Exception lastStack = timeTrace.closeTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                for (String line : lines = TextUtil.split((String)((Object)result).toString(), (char)'\n')) {
                    out.prop((Object)"", (Object)line);
                }
            }
            out.endProps();
        }

        public String getTitle() {
            return "longestClosed";
        }
    }

    public static class ClosedSpy
    extends SpyDir {
        public ClosedSpy() {
            this.add("removeAll", (Spy)new RemoveAllSpy("removeAll", "All Closed Stack Traces Acknowledged", "Return to Closed Traces Summary", closedStacks));
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"removeAll")) {
                return super.find("removeAll");
            }
            String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)namePart)) {
                return super.find(namePart);
            }
            return super.find(name);
        }

        public void write(SpyWriter out) {
            out.startProps();
            Collection collection = closedStacks.values();
            Set keySet = closedStacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            out.prop((Object)"Recently Closed Stack Traces Count", (Object)String.valueOf(keys.length));
            if (array.length > 1) {
                out.propValueLink((Object)"", (Object)SpyWriter.addCsrfToken((String)"removeAll"), (Object)"Acknowledge All");
            }
            for (int j = array.length - 1; j >= 0; --j) {
                String[] lines;
                RemoveSpy removeSpy = new RemoveSpy(keys[j], String.valueOf(j), closedStacks);
                this.add(String.valueOf(j), (Spy)removeSpy);
                out.propValueLink((Object)("Closed Cursor " + keys[j]), (Object)SpyWriter.addCsrfToken((String)String.valueOf(j)), (Object)"Acknowledge");
                TimedStackTrace timeTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Time Cursor was Open ", (Object)timeTrace.delta());
                out.prop((Object)"Close Time", (Object)timeTrace.closeTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
                Exception lastStack = timeTrace.closeTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                for (String line : lines = TextUtil.split((String)((Object)result).toString(), (char)'\n')) {
                    out.prop((Object)"", (Object)line);
                }
            }
            out.endProps();
        }

        public String getTitle() {
            return "closed";
        }
    }

    public static class RemoveAllSpy
    extends SpyDir {
        private final String title;
        private final Map<String, TimedStackTrace> hashMap;
        private final String ackMsg;
        private final String navMsg;

        public RemoveAllSpy(String title, String ackMsg, String navMsg, Map<String, TimedStackTrace> hashMap) {
            this.title = title;
            this.hashMap = hashMap;
            this.ackMsg = ackMsg;
            this.navMsg = navMsg;
        }

        public void write(SpyWriter out) {
            this.hashMap.clear();
            if (peakStacks == this.hashMap) {
                peakActiveCount = 0L;
            }
            out.startProps();
            out.propValueLink((Object)this.ackMsg, (Object)"..", (Object)this.navMsg);
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class RemoveAllLongSpy
    extends SpyDir {
        private final String title;
        private final String ackMsg;
        private final String navMsg;

        public RemoveAllLongSpy(String title, String ackMsg, String navMsg) {
            this.title = title;
            this.ackMsg = ackMsg;
            this.navMsg = navMsg;
        }

        public void write(SpyWriter out) {
            longestStacks.clear();
            out.startProps();
            out.propValueLink((Object)this.ackMsg, (Object)"..", (Object)this.navMsg);
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class RemoveSpy
    extends SpyDir {
        private final Object key;
        private final String title;
        private final Map<String, TimedStackTrace> hashMap;

        public RemoveSpy(Object key, String title, Map<String, TimedStackTrace> hashMap) {
            this.key = key;
            this.title = title;
            this.hashMap = hashMap;
        }

        public void write(SpyWriter out) {
            this.hashMap.remove(this.key);
            out.startProps();
            if (this.hashMap instanceof LinkedHashMap) {
                out.propValueLink((Object)"Stack Trace Acknowledged", (Object)"..", (Object)"Return to Closed Traces Summary");
            } else {
                out.propValueLink((Object)"Stack Trace Acknowledged", (Object)"..", (Object)"Return to Orion Cursor Manager");
            }
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }
}

