/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class MapHelper {
    private static final AgentFilter filter = AgentFilter.is((Type)BIMappable.TYPE);

    public BIOrionObject mapForRead(BObject object) {
        return this.map(object, true);
    }

    public BIOrionObject mapForUpdate(BObject object) {
        return this.map(object, false);
    }

    public BIOrionObject mapForInsert(BObject object) {
        return this.map(object, false);
    }

    public BIOrionObject mapForDelete(BObject object) {
        return this.map(object, false);
    }

    public static BIOrionObject getOrionObjectInstance(BObject object) throws NoSuchAgentException, OrionException {
        AgentList agentList = object.getAgents().filter(filter);
        if (agentList.size() != 1) {
            if (agentList.size() == 0) {
                throw new NoSuchAgentException("There is no BIMappable orion object registered as an agent for objects of type: " + object.getType());
            }
            throw new OrionException("There can only be one BIMappable orion object registered on a BObject. Type " + object.getType() + " has " + agentList.size() + " agents registered.");
        }
        return (BIOrionObject)agentList.get(0).getInstance();
    }

    private BIOrionObject map(BObject source, boolean keysOnly) {
        BIOrionObject orionObject = MapHelper.getOrionObjectInstance(source);
        OrionType orionType = (OrionType)orionObject.getType();
        ((BIMappable)((Object)orionObject)).mapFrom(source);
        Property[] persistentProperties = orionType.getPersistentProperties();
        for (int p = 0; p < persistentProperties.length; ++p) {
            orionObject.setModified(persistentProperties[p], !keysOnly && !BOrionObject.isKey(persistentProperties[p]) && !BOrionObject.isDbSourced(persistentProperties[p]));
        }
        return orionObject;
    }
}

