/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.sys;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionSession;
import java.util.HashMap;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;

public class OrionSyncBuffer
extends SyncBuffer {
    private HashMap<String, OrionSession> sessionMap = new HashMap();
    private HashMap<Object, BComponent> objMap = new HashMap();
    private OrionSession orionSession;
    private BIOrionObject last;
    private boolean needUpdate = false;

    public OrionSyncBuffer(BOrionSpace orionSpace, boolean coalesce) {
        super((BComponentSpace)orionSpace, coalesce);
    }

    public static SyncBuffer getCategoryOps(SyncBuffer sync) {
        SyncBuffer catSync = new SyncBuffer(sync.getSpace(), sync.isCoalesced());
        SyncOp[] ops = sync.list();
        for (int i = 0; i < ops.length; ++i) {
            if (!(ops[i] instanceof SetCategoryMaskOp)) continue;
            catSync.add((SyncOp)new SetCategoryMaskOp(ops[i].getComponent(), ((SetCategoryMaskOp)ops[i]).getMask()));
        }
        return catSync;
    }

    public SyncOp[] startCommit(SyncOp[] ops, Context cx) {
        this.needUpdate = false;
        return ops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OrionSession getSession(BIOrionObject obj, Context cx) {
        BOrionDatabase db = obj.getOrionDatabase();
        OrionSession session = null;
        HashMap<String, OrionSession> hashMap = this.sessionMap;
        synchronized (hashMap) {
            session = this.sessionMap.get(db.getId());
            if (session == null) {
                session = db.createSession(cx);
                session.setAutoCommit(false);
                this.sessionMap.put(db.getId(), session);
            }
        }
        return session;
    }

    protected void doUpdate(BIOrionObject obj, Context cx) {
        OrionSession session = this.getSession(obj, cx);
        if (obj.isModified()) {
            this.orionSession.update(obj);
        }
        this.needUpdate = false;
    }

    public void commitOp(SyncOp op, Context cx) throws Exception {
        if (this.needUpdate) {
            if (this.last != op.getComponent()) {
                this.doUpdate(this.last, cx);
                this.last = null;
            } else if (op.getId() != 115) {
                this.doUpdate(this.last, cx);
                this.last = null;
            }
        } else if (op.getId() == 115) {
            this.last = (BIOrionObject)op.getComponent();
            this.needUpdate = true;
        }
        super.commitOp(op, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCommit() throws Exception {
        if (this.last != null && this.last.isModified()) {
            this.getSession(this.last, null).update(this.last);
        }
        HashMap<String, OrionSession> hashMap = this.sessionMap;
        synchronized (hashMap) {
            for (OrionSession session : this.sessionMap.values()) {
                try {
                    session.commit();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    session.rollback();
                }
                finally {
                    session.close();
                }
            }
            this.sessionMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortCommit(Exception ex) {
        HashMap<String, OrionSession> hashMap = this.sessionMap;
        synchronized (hashMap) {
            for (OrionSession session : this.sessionMap.values()) {
                try {
                    session.rollback();
                }
                catch (Exception exx) {
                    exx.printStackTrace();
                }
                try {
                    session.close();
                }
                catch (Exception exx) {
                    exx.printStackTrace();
                }
            }
            this.sessionMap.clear();
        }
    }

    public BComponent findByHandle(Object handle, boolean autoLoad) {
        BComponent c = this.objMap.get(handle);
        if (c == null && (c = this.getSpace().findByHandle(handle, autoLoad)) != null) {
            this.objMap.put(handle, c);
        }
        return c;
    }
}

