/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.query;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.query.QueryTableModel;
import com.tridium.query.BICompiledQuery;
import com.tridium.query.BQueryEngine;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.naming.BOrd;
import javax.baja.query.BQuery;
import javax.baja.query.QueryRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSqlEngine
extends BQueryEngine
implements BICompiledQuery {
    public static final Type TYPE = Sys.loadType(BSqlEngine.class);
    protected static final Logger log = Logger.getLogger("orion.sqlEngine");
    private QueryTableModel executionModel;

    public Type getType() {
        return TYPE;
    }

    public BSqlEngine() {
        this((QueryTableModel)null);
    }

    public BSqlEngine(BOrd baseOrd) {
        super(baseOrd);
        this.executionModel = null;
    }

    protected BSqlEngine(QueryTableModel executionModel) {
        this.executionModel = executionModel;
    }

    public BICompiledQuery doCompile(BQuery query) throws QueryRuntimeException {
        if (query.getExtent().list().length > 1) {
            throw new QueryRuntimeException("SQL Engine cannot compile queries with multiple base extents.");
        }
        try (OrionSession session = null;){
            session = ((BOrionDatabase)this.baseOrd.get()).createSession(null);
            BSqlEngine bSqlEngine = new BSqlEngine(new QueryTableModel(session, query));
            return bSqlEngine;
        }
    }

    public BITable<?> execute() {
        return this.execute(null);
    }

    public BITable<?> execute(Context cx) {
        return this.executionModel.export();
    }
}

