/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.model;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionModel;
import com.tridium.orion.OrionType;
import com.tridium.orion.Relationship;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class DynamicOrionType
implements OrionType {
    public static final int FLAG_ABSTRACT = 1;
    public static final int FLAG_FINAL = 2;
    public static final int FLAG_ASSOCIATION = 4;
    private BOrionSpace space;
    private BOrionTypeId typeId;
    private BOrionTypeId superTypeId;
    private OrionType superType;
    private BModule module;
    private int flags;
    private Property[] properties;
    private Array<Relationship> relationships = new Array(Relationship.class);
    private Property[] key;
    private Lexicon lexicon;
    private String friendlyTypeName;

    public DynamicOrionType(BOrionTypeId typeId, BOrionTypeId superTypeId, int flags, Property[] properties) {
        this.typeId = typeId;
        this.superTypeId = superTypeId;
        this.flags = flags;
        this.properties = properties;
        for (int i = 0; i < properties.length; ++i) {
            ((DynamicOrionProperty)properties[i]).setDeclaringType(this);
        }
    }

    public static DynamicOrionType makeTemporary(Property[] properties) {
        Property[] newProps = new DynamicOrionProperty[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            newProps[i] = new DynamicOrionProperty(properties[i]);
        }
        return new DynamicOrionType(BOrionTypeId.TEMPORARY, null, 2, newProps);
    }

    public BObject getInstance() {
        return new BDynamicOrionObject(this);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public BOrionSpace getSpace() {
        return this.space;
    }

    public void setSpace(BOrionSpace space) {
        this.space = space;
    }

    public void resolve(OrionModel model) {
        if (this.superTypeId != null && this.superType == null) {
            this.superType = model.getType(this.superTypeId);
            if (this.superType == null) {
                throw new OrionException("Cannot resolve super type (" + (Object)((Object)this.superTypeId) + ") for " + (Object)((Object)this.typeId));
            }
        }
        Property[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            BRef ref;
            BOrionTypeId targetId;
            OrionType targetType;
            if (props[i].getType() != BRef.TYPE || (targetType = model.getType(targetId = (ref = (BRef)props[i].getDefaultValue()).getTargetOrionTypeId())) != null) continue;
            throw new OrionException("Cannot resolve target type for ref. (" + (Object)((Object)ref) + ")");
        }
    }

    public int getId() {
        return -1;
    }

    @Override
    public BOrionTypeId getOrionTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeId.getTypeName();
    }

    public Class<?> getTypeClass() {
        return BDynamicOrionObject.class;
    }

    public String getModuleName() {
        return this.typeId.getModuleName();
    }

    public BModule getModule() {
        if (this.module == null) {
            this.module = Sys.loadModule((String)this.typeId.getModuleName());
        }
        return this.module;
    }

    public RuntimeProfile getRuntimeProfile() {
        return RuntimeProfile.rt;
    }

    public BTypeSpec getTypeSpec() {
        return BDynamicOrionObject.TYPE.getTypeSpec();
    }

    public TypeInfo getTypeInfo() {
        return this.getTypeSpec().getTypeInfo();
    }

    @Override
    public BOrionTypeId getSuperTypeId() {
        return this.superTypeId;
    }

    public Type getSuperType() {
        OrionType orionSuper = this.getOrionSuperType();
        if (orionSuper != null) {
            return orionSuper;
        }
        return BDynamicOrionObject.TYPE.getSuperType();
    }

    @Override
    public OrionType getOrionSuperType() {
        return this.superType;
    }

    public boolean is(Type type) {
        for (DynamicOrionType check = this; check != null; check = check.getSuperType()) {
            if (!((Object)check).equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean is(TypeInfo typeInfo) {
        for (TypeInfo check = this.getTypeInfo(); check != null; check = check.getSuperType()) {
            if (!check.equals(typeInfo)) continue;
            return true;
        }
        return false;
    }

    public Type[] getInterfaces() {
        return new Type[]{BIOrionObject.TYPE};
    }

    public char getDataTypeSymbol() {
        return '\u0000';
    }

    public boolean isDataType() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 2) != 0;
    }

    public boolean isAbstract() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isAssociation() {
        return (this.flags & 4) != 0;
    }

    @Override
    public Property[] getKey() {
        if (this.key == null) {
            Array temp = new Array(Property.class);
            for (int i = 0; i < this.properties.length; ++i) {
                if (!BOrionObject.isKey(this.properties[i])) continue;
                temp.add((Object)this.properties[i]);
            }
            this.key = (Property[])temp.trim();
        }
        return this.key;
    }

    @Override
    public Property getProperty(String name) {
        Property[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(name)) continue;
            return props[i];
        }
        return null;
    }

    @Override
    public Property[] getProperties() {
        return this.properties;
    }

    @Override
    public Property[] getPersistentProperties() {
        Array temp = new Array(Property.class);
        for (int i = 0; i < this.properties.length; ++i) {
            if ((this.properties[i].getDefaultFlags() & 2) != 0) continue;
            temp.add((Object)this.properties[i]);
        }
        return (Property[])temp.trim();
    }

    public void addInverseRef(Property inverse) {
        Property[] temp = new Property[this.properties.length + 1];
        System.arraycopy(this.properties, 0, temp, 0, this.properties.length);
        temp[this.properties.length] = inverse;
        this.properties = temp;
    }

    @Override
    public void addRelationship(Relationship rel) {
        this.relationships.add((Object)rel);
    }

    public Relationship[] getRelationships() {
        return (Relationship[])this.relationships.trim();
    }

    public Lexicon getLexicon(Context cx) {
        if (cx == null) {
            if (this.lexicon == null || !this.lexicon.language.equals(Sys.getLanguage())) {
                this.lexicon = Lexicon.make((String)this.getModuleName());
            }
            return this.lexicon;
        }
        return Lexicon.make((String)this.getModuleName(), (Context)cx);
    }

    public String getDisplayName(Context cx) {
        String n = this.getLexicon(cx).get(this.getTypeName() + ".displayName");
        if (n != null) {
            return n;
        }
        if (this.friendlyTypeName == null) {
            this.friendlyTypeName = TextUtil.toFriendly((String)this.getTypeName());
        }
        return this.friendlyTypeName;
    }

    public String toString() {
        return this.typeId.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DynamicOrionType)) {
            return false;
        }
        DynamicOrionType dt = (DynamicOrionType)o;
        if (dt.space != this.space) {
            return false;
        }
        return dt.typeId.equals((Object)this.typeId);
    }

    public int hashCode() {
        return this.typeId.hashCode();
    }
}

