/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxBatchDelete;
import com.tridium.orion.priv.fox.FoxBatchInsert;
import com.tridium.orion.priv.fox.FoxBatchPersist;
import com.tridium.orion.priv.fox.FoxBatchUpdate;
import com.tridium.orion.priv.util.MapHelper;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;

public class FoxOrionSession
implements OrionSession {
    private static final int SESSION_INIT = -1;
    private static final int SESSION_CLOSED = -2;
    private Context context;
    private BFoxOrionDatabase db;
    private RdbmsContext rdbmsContext;
    private boolean autoCommit = true;
    private int sessionId = -1;
    private MapHelper mapHelper;

    public FoxOrionSession(BFoxOrionDatabase db, Context context) {
        this.db = db;
        this.context = context;
        this.mapHelper = new MapHelper();
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        return this.db;
    }

    @Override
    public RdbmsContext getRdbmsContext() {
        this.checkClosed();
        if (this.rdbmsContext == null) {
            try {
                BTypeSpec spec = this.db.getChannel().requestHandler.getRdbmsTypeSpec(this);
                this.rdbmsContext = ((BRdbms)spec.getInstance()).getRdbmsContext();
            }
            catch (OrionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new OrionException("Operation failed.", ex);
            }
        }
        return this.rdbmsContext;
    }

    void open(int sessionId) {
        this.checkClosed();
        this.sessionId = sessionId;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setAutoCommit(boolean auto) {
        this.checkClosed();
        this.autoCommit = auto;
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void commit() {
        if (!this.isOpen()) {
            return;
        }
        try {
            BOrionChannel channel = this.db.getChannel();
            channel.requestHandler.commit(this);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public void rollback() {
        if (!this.isOpen()) {
            return;
        }
        try {
            BOrionChannel channel = this.db.getChannel();
            channel.requestHandler.rollback(this);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public boolean isOpen() {
        return this.sessionId != -2;
    }

    private void checkClosed() {
        if (this.sessionId == -2) {
            throw new OrionException("Session has been closed.");
        }
    }

    @Override
    public void close() {
        if (this.sessionId == -1) {
            this.sessionId = -2;
        }
        if (!this.isOpen()) {
            return;
        }
        try {
            BOrionChannel channel = this.db.getChannel();
            channel.requestHandler.closeSession(this);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    public void closed() {
        this.sessionId = -2;
    }

    @Override
    public void invokeDdl(DdlCommand ddl) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            channel.requestHandler.invokeDdl(this, ddl.getDdl(this.getRdbmsContext()));
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public void insert(BIOrionObject obj) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            channel.circuitHandler.insert(this, obj);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public int insert(String sql) {
        return this.insert(sql, null);
    }

    @Override
    public int insert(String sql, BSimple[] paramValues) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.insertRaw(this, sql, paramValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public void mappedInsert(BObject object) {
        this.insert(this.mapHelper.mapForInsert(object));
    }

    @Override
    public boolean exists(BIOrionObject obj) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.requestHandler.exists(this, obj.getOrionType(), PropertyValue.makeKeys(obj));
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public boolean exists(OrionType type, PropertyValue[] propValues) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.requestHandler.exists(this, type, propValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public BIOrionObject mappedRead(BObject object) {
        this.checkClosed();
        BIOrionObject orionObject = this.mapHelper.mapForRead(object);
        if (this.read(orionObject) == null) {
            return null;
        }
        return orionObject;
    }

    @Override
    public BIOrionObject read(BQuery query) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            BIOrionObject[] res = channel.circuitHandler.qselect(this, query).toArray();
            switch (res.length) {
                case 0: {
                    return null;
                }
                case 1: {
                    return res[0];
                }
            }
            throw new OrionException("More than one object found");
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public BIOrionObject read(BIOrionObject obj) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            BIOrionObject result = channel.circuitHandler.read(this, obj);
            if (result == null) {
                return null;
            }
            this.copyAfterRead(obj, result);
            return obj;
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    private void copyAfterRead(BIOrionObject obj, BIOrionObject readResult) {
        OrionType type2;
        OrionType type1 = obj.getOrionType();
        if (type1 != (type2 = readResult.getOrionType())) {
            throw new OrionException("Type mismatch: " + type1 + " != " + type2);
        }
        obj.copyFrom(readResult);
        obj.setOrionDatabase(this.getOrionDatabase());
    }

    @Override
    public BIOrionObject read(OrionType type, BSimple key) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.read(this, type, key);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public BIOrionObject read(OrionType type, PropertyValue propValue) {
        return this.read(type, new PropertyValue[]{propValue});
    }

    @Override
    public BIOrionObject read(OrionType type, PropertyValue[] propValues) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.read(this, type, propValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public BIOrionObject read(OrionType type, String sql) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.readRaw(this, type, sql);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public BIOrionObject read(OrionType type, String sql, BSimple[] paramValues) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.preadRaw(this, type, sql, paramValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public int update(BSqlUpdate update) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.qupdate(this, update);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public int update(String sql) {
        return this.update(sql, null);
    }

    @Override
    public int update(String sql, BSimple[] paramValues) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.updateRaw(this, sql, paramValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public void update(BIOrionObject obj) {
        this.update(obj, false);
    }

    @Override
    public void update(BIOrionObject obj, boolean forceUpdate) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            channel.circuitHandler.update(this, obj, forceUpdate);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public void mappedUpdate(BObject object) {
        this.update(this.mapHelper.mapForUpdate(object));
    }

    @Override
    public void persist(BIOrionObject obj) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            channel.circuitHandler.persist(this, obj);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public int delete(OrionType type, BExpression condition) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.qdelete(this, type, condition);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public int delete(String sql) {
        return this.delete(sql, null);
    }

    @Override
    public int delete(String sql, BSimple[] paramValues) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.deleteRaw(this, sql, paramValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public boolean mappedDelete(BObject object) {
        return this.delete(this.mapHelper.mapForDelete(object));
    }

    @Override
    public boolean delete(BIOrionObject obj) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.delete(this, obj);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public OrionCursor select(BQuery query) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.qselect(this, query);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public OrionCursor select(OrionType type, String sql) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.select(this, type, sql);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public OrionCursor select(OrionType type, String sql, BSimple[] paramValues) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.pselect(this, type, sql, paramValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public OrionCursor select(OrionType type, PropertyValue propValue) {
        return this.select(type, new PropertyValue[]{propValue});
    }

    @Override
    public OrionCursor select(OrionType type, PropertyValue[] propValues) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.select(this, type, propValues);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public OrionCursor scan(OrionType type) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.scan(this, type);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public OrionCursor linkedScan(BIOrionObject object, OrionType linkType, OrionType scanType) {
        this.checkClosed();
        try {
            BOrionChannel channel = this.db.getChannel();
            return channel.circuitHandler.linkedScan(this, object, linkType, scanType);
        }
        catch (OrionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Operation failed.", ex);
        }
    }

    @Override
    public BatchStatement batchInsert(OrionType type) {
        return new FoxBatchInsert(this, this.db.getChannel(), type);
    }

    @Override
    public BatchStatement batchUpdate(OrionType type) {
        return new FoxBatchUpdate(this, this.db.getChannel(), type);
    }

    @Override
    public BatchStatement batchPersist(OrionType type) {
        return new FoxBatchPersist(this, this.db.getChannel(), type);
    }

    @Override
    public BatchStatement batchDelete(OrionType type) {
        return new FoxBatchDelete(this, this.db.getChannel(), type);
    }

    public Context getBase() {
        return this.context;
    }

    public String getLanguage() {
        if (this.context != null) {
            return this.context.getLanguage();
        }
        return Sys.getLanguage();
    }

    public BFacets getFacets() {
        if (this.context != null) {
            return this.context.getFacets();
        }
        return BFacets.DEFAULT;
    }

    public BObject getFacet(String key) {
        if (this.context != null) {
            return this.context.getFacet(key);
        }
        return null;
    }

    public BUser getUser() {
        if (this.context != null) {
            return this.context.getUser();
        }
        return null;
    }
}

