/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BOrionDeviceExt;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.priv.fox.BOrionChannel;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNiagaraOrionDeviceExt
extends BOrionDeviceExt
implements BINiagaraDeviceExt,
BFoxClientConnection.Interest,
BIMixIn {
    public static final Property enabled = BNiagaraOrionDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BNiagaraOrionDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNiagaraOrionDeviceExt.newProperty((int)3, (String)"", null);
    public static final Action ping = BNiagaraOrionDeviceExt.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BNiagaraOrionDeviceExt.class);
    private static final BIcon icon = BIcon.make((String)"module://orion/rc/orion.png");
    private BFoxOrionSpace orionSpace;
    private static final Logger log = Logger.getLogger("orion.nd");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void updateStatus() {
        BDevice device = this.getDevice();
        if (device == null) {
            return;
        }
        int bits = 0;
        BStatus deviceStatus = device.getStatus();
        if (deviceStatus.isDisabled() || !this.getEnabled()) {
            bits |= 1;
        }
        if (this.getFaultCause().length() != 0) {
            bits |= 2;
        }
        this.setStatus(BStatus.make((int)bits));
    }

    public void setFault(String cause) {
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public void clearFault() {
        this.setFaultCause("");
        this.updateStatus();
    }

    public String getDisplayNameInParent(Context cx) {
        return "Orion";
    }

    public void started() {
        this.updateStatus();
    }

    public void stopped() {
    }

    public void changed(Property prop, Context cx) {
        if (prop.equals(enabled)) {
            this.updateStatus();
        }
    }

    public final BFoxClientConnection getClientConnection() {
        return ((BNiagaraStation)this.getParent()).getClientConnection();
    }

    public synchronized BOrionChannel getChannel() {
        BOrionChannel channel = (BOrionChannel)this.getClientConnection().getChannels().get("orion");
        if (channel == null) {
            channel = new BOrionChannel();
            this.getClientConnection().getChannels().add("orion", (BValue)channel);
        }
        return channel;
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public void clientOpened() {
        this.orionSpace = new BFoxOrionSpace();
    }

    public void clientClosed() {
        this.orionSpace = null;
    }

    public void doPing() {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            BOrionChannel channel = this.getChannel();
            channel.requestHandler.ping();
            this.clearFault();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setFault("Orion ping failed.");
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

