/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.orion.BNameFactory;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxDbSpec;
import com.tridium.orion.priv.fox.FoxOrionSession;
import java.util.HashMap;
import javax.baja.driver.BDriverContainer;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.security.BPermissions;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;

public class BFoxOrionDatabase
extends BOrionDatabase {
    public static final Type TYPE = Sys.loadType(BFoxOrionDatabase.class);
    private static final Version VERSION_37 = new Version(new int[]{3, 7});
    private BFoxOrionSpace space;
    private FoxDbSpec dbId;
    private HashMap<BOrionTypeId, OrionType> typeCache = new HashMap();
    private HashMap<OrionType, BNameFactory> factoryCache = new HashMap();

    public BFoxOrionDatabase() {
        throw new UnsupportedOperationException();
    }

    public BFoxOrionDatabase(BFoxOrionSpace space, FoxDbSpec dbId) {
        this.space = space;
        this.dbId = dbId;
        this.setCategoryMask(dbId.getCategoryMask(), null);
    }

    @Override
    public BOrionSpace getOrionSpace() {
        return this.space;
    }

    public BOrionChannel getChannel() {
        return this.space.getChannel();
    }

    public String getDatabaseName() {
        return this.dbId.getName();
    }

    @Override
    public String getId() {
        return this.dbId.getId();
    }

    @Override
    public BOrionType[] getTypes() {
        Array temp = new Array(BOrionType.class, 64);
        this.loadSlots();
        SlotCursor modules = this.getProperties();
        while (modules.next(BOrionModule.class)) {
            BOrionModule module = (BOrionModule)modules.get();
            module.loadSlots();
            SlotCursor types = module.getProperties();
            while (types.next(BOrionType.class)) {
                temp.add((Object)((BOrionType)types.get()));
            }
        }
        return (BOrionType[])temp.trim();
    }

    @Override
    public BOrionType getType(BTypeSpec typeSpec) {
        this.loadSlots();
        String moduleName = typeSpec.getModuleName();
        String typeName = typeSpec.getTypeName();
        BOrionModule module = this.getModule(moduleName);
        if (module == null) {
            return null;
        }
        module.loadSlots();
        return module.getType(typeName);
    }

    @Override
    public BOrionType getType(OrionType type) {
        this.loadSlots();
        BOrionModule module = this.getModule(type.getModule().getModuleName());
        if (module == null) {
            return null;
        }
        module.loadSlots();
        return module.getType(type.getTypeName());
    }

    @Override
    public OrionType getType(BOrionTypeId id) {
        OrionType type = this.typeCache.get((Object)id);
        if (type == null) {
            try {
                type = this.getChannel().circuitHandler.getType(this, id);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new OrionException("Cannot load type: " + (Object)((Object)id), ex);
            }
            if (type != null) {
                this.typeCache.put(id, type);
            }
        }
        return type;
    }

    @Override
    public BTypeDependency[] getDependentTypes(OrionType toType) {
        try {
            return this.getChannel().circuitHandler.getDependentTypes(this, toType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrionException("Cannot get dependent types for: " + toType, ex);
        }
    }

    @Override
    public OrionSession createSession(Context cx) {
        return new FoxOrionSession(this, cx);
    }

    public BPermissions getPermissions(Context cx) {
        return this.dbId.getPermissions();
    }

    @Override
    public BRdbms getRdbms() {
        BDriverContainer container = (BDriverContainer)this.space.getFoxSession().getService(BDriverContainer.TYPE);
        container.lease();
        BRdbmsNetwork network = ((BRdbmsNetwork[])container.getChildren(BRdbmsNetwork.class))[0];
        network.lease();
        BRdbms rdbms = (BRdbms)network.get(this.getId());
        rdbms.lease();
        return rdbms;
    }

    @Override
    public BNameFactory getNameFactory(OrionType type) {
        BNameFactory f = this.factoryCache.get(type);
        if (f == null) {
            Version version = (Version)((BFoxSession)this.space.getSession()).fw(404, (Object)"orion", (Object)BNameFactory.TYPE.getRuntimeProfile().name(), null, null);
            if (version == null || version.compareTo(VERSION_37) < 0) {
                f = BNameFactory.INSTANCE;
                this.factoryCache.put(type, f);
            } else {
                try {
                    f = this.getChannel().circuitHandler.getNameFactory(this, type);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new OrionException("Cannot find name factory for : " + type, ex);
                }
                if (f != null) {
                    this.factoryCache.put(type, f);
                }
            }
        }
        return f;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

