/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.trans;

import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.trans.TranslatorFactory;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BRefTranslator
extends BColumnTranslator {
    public static final Type TYPE = Sys.loadType(BRefTranslator.class);
    private BTypeSpec refTypeSpec;
    private BColumnTranslator refTrans;

    public BRefTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
        BRef ref = (BRef)defaultValue;
        this.refTypeSpec = ref.getTargetTypeSpec();
        OrionType refType = (OrionType)this.refTypeSpec.getResolvedType();
        Property[] props = refType.getKey();
        if (props == null || props.length != 1) {
            throw new OrionException("Ref types can have only one key.");
        }
        BComplex cmp = (BComplex)this.refTypeSpec.getInstance();
        BValue val = cmp.get(props[0]);
        this.refTrans = TranslatorFactory.make(dialect, val);
    }

    public BSqlType getSqlType() {
        return this.refTrans.getSqlType();
    }

    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue value, Context context) {
        BRef ref = (BRef)value;
        if (ref.isBound()) {
            this.refTrans.setPreparedStatementValue(prep, index, (BValue)ref.getId(), context);
        } else {
            prep.setNull(index, BRefTranslator.lookupJdbcType(this.getDialect(), this.refTrans.getSqlType(), context));
        }
    }

    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        if (rs.isNull(index)) {
            return BRef.make(this.refTypeSpec);
        }
        return BRef.make(this.refTypeSpec, (BSimple)this.refTrans.getResultSetValue(rs, index, context));
    }

    private static int lookupJdbcType(RdbmsDialect dialect, BSqlType sqlType, Context context) {
        switch (sqlType.getOrdinal()) {
            case 0: {
                return dialect.getJdbcTypeInt();
            }
            case 1: {
                return dialect.getJdbcTypeLong();
            }
            case 2: {
                return dialect.getJdbcTypeFloat();
            }
            case 3: {
                return dialect.getJdbcTypeDouble();
            }
            case 4: {
                return dialect.getJdbcTypeBoolean();
            }
            case 5: {
                return dialect.getJdbcTypeTimestamp();
            }
            case 6: {
                return dialect.getJdbcTypeChar();
            }
            case 9: {
                return dialect.getJdbcTypeUuid();
            }
            case 11: {
                return dialect.getJdbcTypeDate();
            }
            case 7: {
                return context.getFacets().getb("clob", false) ? dialect.getJdbcTypeClob() : dialect.getJdbcTypeVarchar();
            }
            case 10: {
                return dialect.getJdbcTypeBlob();
            }
        }
        throw new IllegalStateException();
    }

    public Type getType() {
        return TYPE;
    }
}

