/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import java.util.HashMap;
import javax.baja.query.BExtent;
import javax.baja.query.BQuery;
import javax.baja.query.BTypedExtent;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class SqlHelper {
    BOrionDatabase db;
    BQuery query;
    HashMap<BFieldExpression, Property> nodeToProp = null;
    HashMap<BFieldExpression, String> nodeToAlias = null;

    public SqlHelper(BOrionDatabase db, BQuery query) {
        this.db = db;
        this.query = query;
        this.nodeToProp = new HashMap(4);
        this.nodeToAlias = new HashMap(4);
    }

    public Property getFieldProperty(BFieldExpression node) {
        return this.nodeToProp.get(node);
    }

    public String resolveField(BFieldExpression node) {
        String field = this.resolveFieldName(node);
        if (field.equals("*")) {
            return field;
        }
        String solution = this.toQualifiedString(node);
        return solution;
    }

    private String toQualifiedString(BFieldExpression node) {
        OrionType targetTable = null;
        Property prop = null;
        String extentAlias = null;
        BSqlField sf = node instanceof BSqlField ? (BSqlField)node : this.toSqlField(this.resolveFieldName(node));
        extentAlias = sf.getExtentAlias();
        if (extentAlias.equals("") && sf.getExtentType().equals(((BTypedExtent)this.query.getExtent()).listTypes()[0])) {
            extentAlias = this.getExtentAlias();
        }
        if ((prop = (targetTable = sf.getExtentType()).getProperty(sf.getPropertyName())) == null) {
            throw new OrionException("Cannot resolve field [" + this.resolveFieldName(node) + "].");
        }
        String qualified = extentAlias.equals("") ? this.db.getTableName(targetTable) + "." + prop.getName() : extentAlias + "." + prop.getName();
        this.nodeToProp.put(node, prop);
        this.nodeToAlias.put(node, extentAlias);
        return qualified;
    }

    private String resolveFieldName(BFieldExpression expr) {
        return expr instanceof BSqlField ? ((BSqlField)expr).getAliasedField(this.db) : expr.getField();
    }

    private BSqlField toSqlField(String fieldName) {
        Property solutionProp = null;
        String solutionAlias = "";
        OrionType solutionExtent = null;
        BTypedExtent extent = null;
        extent = this.query.getExtent().asTypedExtent();
        solutionExtent = (OrionType)extent.listTypes()[0];
        solutionAlias = this.getTableAlias((BExtent)extent);
        solutionProp = ((OrionType)extent.listTypes()[0]).getProperty(fieldName);
        if (this.query instanceof BSqlQuery) {
            BSqlJoin[] joins = ((BSqlQuery)this.query).getJoins();
            for (int i = 0; i < joins.length; ++i) {
                extent = joins[i].getJoinTable().asTypedExtent();
                Type joinTable = extent.listTypes()[0];
                Property find = ((OrionType)joinTable).getProperty(fieldName);
                if (find == null) continue;
                if (solutionProp != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Cannot resolve column '").append(fieldName).append("' for this BQuery:\n");
                    if (joinTable.equals(solutionExtent)) {
                        sb.append("There are two or more FROM or ON tables referenced ").append("with table type: ").append(joinTable.toString()).append(" which is causing an ambiguous reference to the column.\n");
                    } else {
                        sb.append("There are multiple tables referenced in the query ").append("with that same column name: ").append("Table: ").append(solutionExtent.toString()).append(" and table: ").append(joinTable.toString()).append(".\n");
                    }
                    sb.append("Use a BSqlField expression to scope the column, or make ").append("sure that your BSqlJoin expresions have the correct ").append("FROM and TO tables (the TO table is used as the join extent table.\n");
                    throw new OrionException(sb.toString());
                }
                solutionProp = find;
                solutionAlias = this.getTableAlias((BExtent)extent);
                solutionExtent = (OrionType)extent.listTypes()[0];
            }
        }
        if (solutionProp == null) {
            throw new OrionException("Could not resolve column '" + fieldName + "'");
        }
        return new BSqlField(solutionExtent, solutionProp).alias(solutionAlias);
    }

    protected String getExtentAlias() {
        return this.getTableAlias(this.query.getExtent());
    }

    protected String getTableAlias(BExtent extent) {
        if (extent instanceof BSqlExtent) {
            return ((BSqlExtent)extent).getExtentAlias();
        }
        return "";
    }
}

