/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionType;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.priv.db.trans.TranslatorFactory;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.query.BExtent;
import javax.baja.query.BQuery;
import javax.baja.query.BTypedExtent;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class SessionHelper {
    protected Logger log = Logger.getLogger("orion.jdbc");
    protected Logger queryLog = Logger.getLogger("orion.queryToSql");
    protected final DbOrionSession session;
    protected final BLocalOrionDatabase db;
    protected final RdbmsDialect dialect;
    protected final Connection conn;

    public SessionHelper(DbOrionSession session) {
        this.session = session;
        this.db = (BLocalOrionDatabase)session.getOrionDatabase();
        this.dialect = (RdbmsDialect)this.db.getRdbms().getRdbmsContext();
        this.conn = session.getConnection();
    }

    static String firstWord(String str) {
        int n = str.indexOf(32);
        return n == -1 ? str : str.substring(0, n);
    }

    public BPermissions getPermissionsFor(BIOrionObject o) {
        return this.getPermissionsFor((BObject)o);
    }

    public BPermissions getPermissionsFor(BObject o) {
        if (o instanceof BIProtected) {
            return ((BIProtected)o).getPermissions((Context)this.session);
        }
        return BPermissions.all;
    }

    public boolean canRead(BIOrionObject o) {
        return this.canRead((BObject)o);
    }

    public boolean canRead(BObject o) {
        return this.getPermissionsFor(o).hasOperatorRead();
    }

    public boolean canWrite(BIOrionObject o) {
        return this.canWrite((BObject)o);
    }

    public boolean canWrite(BObject o) {
        return this.getPermissionsFor(o).hasOperatorWrite();
    }

    public BPermissions getPermissionsForQuery(BQuery query) {
        BSqlQuery sql;
        BSqlJoin[] joins;
        int i;
        if (this.session.getUser() == null) {
            return BPermissions.all;
        }
        int pmask = BPermissions.all.getMask();
        if (query.hasExtent()) {
            BExtent extent = query.getExtent();
            if (!extent.isTypedExtent()) {
                return this.getPermissionsFor((BObject)this.db);
            }
            Type[] extentTypes = ((BTypedExtent)extent).listTypes();
            for (i = 0; i < extentTypes.length; ++i) {
                if (extentTypes[i] instanceof OrionType) {
                    BOrionType orionType = this.db.getType((OrionType)extentTypes[i]);
                    if (orionType == null) {
                        return this.getPermissionsFor((BObject)this.db);
                    }
                    pmask &= this.getPermissionsFor((BObject)orionType).getMask();
                    continue;
                }
                return this.getPermissionsFor((BObject)this.db);
            }
        }
        if (query instanceof BSqlQuery && (joins = (sql = (BSqlQuery)query).getJoins()) != null) {
            for (i = 0; i < joins.length; ++i) {
                Type[] joinTypes = joins[i].getJoinTable().listTypes();
                for (int j = 0; j < joinTypes.length; ++j) {
                    if (joinTypes[j] instanceof OrionType) {
                        BOrionType orionType = this.db.getType((OrionType)joinTypes[j]);
                        if (orionType == null) {
                            return this.getPermissionsFor((BObject)this.db);
                        }
                        pmask &= this.getPermissionsFor((BObject)orionType).getMask();
                        continue;
                    }
                    return this.getPermissionsFor((BObject)this.db);
                }
            }
        }
        return BPermissions.make((int)pmask);
    }

    public int updateOrDelete(String firstWord, String sql) {
        if (!this.getPermissionsFor((BObject)this.db).hasAdminWrite()) {
            return 0;
        }
        String word = SessionHelper.firstWord(sql.trim()).toUpperCase();
        if (!word.equals(firstWord)) {
            throw new OrionException("Invalid '" + firstWord + "' statement: " + sql);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, sql);
        }
        try {
            return this.conn.createStatement().executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    public int updateOrDelete(String firstWord, String sql, BSimple[] paramValues) {
        if (!this.getPermissionsFor((BObject)this.db).hasAdminWrite()) {
            return 0;
        }
        String word = SessionHelper.firstWord(sql.trim()).toUpperCase();
        if (!word.equals(firstWord)) {
            throw new OrionException("Invalid '" + firstWord + "' statement: " + sql);
        }
        try {
            RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.conn, sql);
            for (int i = 0; i < paramValues.length; ++i) {
                BColumnTranslator trans = TranslatorFactory.make(this.dialect, (BValue)paramValues[i]);
                trans.setPreparedStatementValue(prep, i + 1, (BValue)paramValues[i], null);
            }
            return prep.executeUpdate();
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    protected void logBQuery(SqlVisitor sql) {
        if (this.queryLog.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer().append(sql.getQueryString()).append(" : [");
            BSimple[] params = sql.getParameters();
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                try {
                    sb.append(params[i].encodeToString());
                    continue;
                }
                catch (Exception x) {
                    sb.append(params[i].toString());
                }
            }
            sb.append("]\n");
            if (this.queryLog.isLoggable(Level.FINE)) {
                this.queryLog.log(Level.FINE, sb.toString());
            }
        }
    }
}

