/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.audit;

import com.tridium.orion.BAuditMode;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.audit.BOrionAudit;
import com.tridium.orion.priv.audit.BOrionAuditType;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public class BOrionAuditWorker
extends BThreadPoolWorker {
    public static final Property maxThreads = BOrionAuditWorker.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property maxQueueSize = BOrionAuditWorker.newProperty((int)0, (int)50000, (BFacets)BFacets.makeInt(null, (int)5000, (int)Integer.MAX_VALUE));
    public static final Type TYPE = Sys.loadType(BOrionAuditWorker.class);
    HashMap<BOrionDatabase, OrionSession> sessions = new HashMap();
    Queue queue;
    ThreadPoolWorker worker;

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOrionAuditWorker() {
    }

    public BOrionAuditWorker(int maxThreads) {
        super(maxThreads);
    }

    public static void auditCreated(BIOrionObject obj, OrionSession session) {
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BAuditMode mode = service.getAuditMode();
        if (!mode.equals((Object)BAuditMode.none)) {
            service.getAuditWorker().postAsync(obj, BOrionAuditType.created, session.getUser().getUsername(), session.getOrionDatabase());
        }
    }

    public static void auditDeleted(BIOrionObject obj, OrionSession session) {
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BAuditMode mode = service.getAuditMode();
        if (!mode.equals((Object)BAuditMode.none)) {
            service.getAuditWorker().postAsync(obj, BOrionAuditType.deleted, session.getUser().getUsername(), session.getOrionDatabase());
        }
    }

    public static void auditModified(BIOrionObject obj, Property p, OrionSession session) {
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BAuditMode mode = service.getAuditMode();
        if (!mode.equals((Object)BAuditMode.none)) {
            service.getAuditWorker().postAsync(obj, p, BOrionAuditType.modified, session.getUser().getUsername(), session.getOrionDatabase());
        }
    }

    public IFuture postAsync(BIOrionObject obj, BOrionAuditType auditType, String username, BOrionDatabase db) {
        return this.postAsync(obj, null, auditType, username, db);
    }

    public IFuture postAsync(BIOrionObject obj, Property p, BOrionAuditType auditType, String username, BOrionDatabase db) {
        OrionAuditEvent event = new OrionAuditEvent(obj, p, auditType, username, db);
        if (!this.isRunning() || this.queue == null) {
            throw new NotRunningException();
        }
        while (true) {
            try {
                this.queue.enqueue((Object)event);
                return null;
            }
            catch (QueueFullException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ee) {
                    throw new QueueFullException("Unable to Sleep");
                }
            }
        }
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new Queue(this.getMaxQueueSize());
            this.worker = new AuditThreadPoolWorker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    protected String getWorkerThreadName() {
        return "BOrionAuditWorker:" + this.getParent().getName();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals(maxQueueSize) && this.queue != null) {
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
        }
    }

    public OrionSession getAuditSession(BOrionDatabase db) {
        OrionSession session = this.sessions.get(db);
        if (session == null) {
            session = db.createSession(null);
            this.sessions.put(db, session);
        }
        return session;
    }

    public void cleanupSessions() {
        Object[] values = this.sessions.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            OrionSession session = (OrionSession)values[i];
            session.close();
            Object var3_3 = null;
        }
        this.sessions.clear();
    }

    public class AuditThreadPoolWorker
    extends ThreadPoolWorker {
        public AuditThreadPoolWorker(Worker.ITodo todo) {
            super(todo);
        }

        protected void threadStarted() {
            Thread.currentThread().setPriority(1);
        }

        protected void threadStopped() {
            BOrionAuditWorker.this.cleanupSessions();
        }
    }

    public class OrionAuditEvent
    implements Runnable {
        BIOrionObject obj;
        BOrionDatabase db;
        BOrionAuditType auditType;
        String username;
        Property property;

        public OrionAuditEvent(BIOrionObject obj, Property property, BOrionAuditType auditType, String username, BOrionDatabase db) {
            this.obj = obj;
            this.auditType = auditType;
            this.username = username;
            this.property = property;
            this.db = db;
        }

        @Override
        public void run() {
            OrionSession session = BOrionAuditWorker.this.getAuditSession(this.db);
            BOrionService service = (BOrionService)BOrionAuditWorker.this.getParent();
            if (this.auditType.equals((Object)BOrionAuditType.created)) {
                BOrionAudit.auditCreated(this.obj, this.username, service.getAuditMode(), session);
            } else if (this.auditType.equals((Object)BOrionAuditType.deleted)) {
                BOrionAudit.auditDeleted(this.obj, this.username, service.getAuditMode(), session);
            } else if (this.auditType.equals((Object)BOrionAuditType.modified)) {
                BOrionAudit.auditModified(this.obj, this.property, this.username, service.getAuditMode(), session);
            }
        }
    }
}

