/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.audit;

import com.tridium.orion.BAuditMode;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAuditType;
import com.tridium.sys.Nre;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BOrionAudit
extends BOrionObject {
    public static final Property id = BOrionAudit.newProperty((int)0, (int)0, (BFacets)ID_KEY);
    public static final Property timestamp = BOrionAudit.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property userName = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"width", (int)64)));
    public static final Property objectTypeSpec = BOrionAudit.newProperty((int)0, (BValue)BTypeSpec.DEFAULT, (BFacets)BFacets.make((String)"width", (int)64));
    public static final Property objectDisplay = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)512));
    public static final Property auditType = BOrionAudit.newProperty((int)0, (BValue)BOrionAuditType.unspecified, null);
    public static final Property slotName = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)64));
    public static final Property oldValue = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)128));
    public static final Property newValue = BOrionAudit.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)128));
    public static final Type TYPE = Sys.loadType(BOrionAudit.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final int ORION_INIT_ORIG = 702;
    public static final int ORION_GET_ORIG_VALUE = 703;

    public int getId() {
        return this.getInt(id);
    }

    public void setId(int v) {
        this.setInt(id, v, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    public BTypeSpec getObjectTypeSpec() {
        return (BTypeSpec)this.get(objectTypeSpec);
    }

    public void setObjectTypeSpec(BTypeSpec v) {
        this.set(objectTypeSpec, (BValue)v, null);
    }

    public String getObjectDisplay() {
        return this.getString(objectDisplay);
    }

    public void setObjectDisplay(String v) {
        this.setString(objectDisplay, v, null);
    }

    public BOrionAuditType getAuditType() {
        return (BOrionAuditType)this.get(auditType);
    }

    public void setAuditType(BOrionAuditType v) {
        this.set(auditType, (BValue)v, null);
    }

    public String getSlotName() {
        return this.getString(slotName);
    }

    public void setSlotName(String v) {
        this.setString(slotName, v, null);
    }

    public String getOldValue() {
        return this.getString(oldValue);
    }

    public void setOldValue(String v) {
        this.setString(oldValue, v, null);
    }

    public String getNewValue() {
        return this.getString(newValue);
    }

    public void setNewValue(String v) {
        this.setString(newValue, v, null);
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public static void auditCreated(BIOrionObject obj, String username, BAuditMode mode, OrionSession session) {
        Auditor auditor;
        if (mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.databaseRecord)) {
            BOrionAudit audit = BOrionAudit.makeAuditRecord(obj, username, session);
            audit.setAuditType(BOrionAuditType.created);
            session.insert(audit);
        }
        if ((mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.auditEvent)) && (auditor = Nre.auditor) != null) {
            auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Added", "", "", "", username));
        }
    }

    public static void auditDeleted(BIOrionObject obj, String username, BAuditMode mode, OrionSession session) {
        Auditor auditor;
        if (mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.databaseRecord)) {
            BOrionAudit rec = BOrionAudit.makeAuditRecord(obj, username, session);
            rec.setAuditType(BOrionAuditType.deleted);
            session.insert(rec);
        }
        if ((mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.auditEvent)) && (auditor = Nre.auditor) != null) {
            auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Removed", "", "", "", username));
        }
    }

    public static void auditModified(BIOrionObject obj, Property property, String username, BAuditMode mode, OrionSession session) {
        Auditor auditor;
        BValue newValue;
        BValue oldValue;
        if (mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.databaseRecord)) {
            BOrionAudit rec = BOrionAudit.makeAuditRecord(obj, username, session);
            rec.setAuditType(BOrionAuditType.modified);
            rec.setSlotName(property.getName());
            oldValue = (BValue)((BObject)obj).fw(703, (Object)property, null, null, null);
            newValue = obj.get(property);
            if (property.getType().equals(BRef.TYPE)) {
                rec.setOldValue(BOrionAudit.makeRefString((BRef)oldValue, session));
                rec.setNewValue(BOrionAudit.makeRefString((BRef)newValue, session));
            } else {
                rec.setOldValue(oldValue.toString((Context)session));
                rec.setNewValue(newValue.toString((Context)session));
            }
            session.insert(rec);
        }
        if ((mode.equals((Object)BAuditMode.both) || mode.equals((Object)BAuditMode.auditEvent)) && (auditor = Nre.auditor) != null) {
            oldValue = (BValue)((BObject)obj).fw(703, (Object)property, null, null, null);
            newValue = obj.get(property);
            if (property.getType().equals(BRef.TYPE)) {
                auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Changed", property.getName(), BOrionAudit.makeRefString((BRef)oldValue, session), BOrionAudit.makeRefString((BRef)newValue, session), username));
            } else {
                auditor.audit(BOrionAudit.makeAuditEvent(obj, session, "Changed", property.getName(), oldValue.toString((Context)session), newValue.toString((Context)session), username));
            }
        }
    }

    private static String makeRefString(BRef ref, OrionSession session) {
        BIOrionObject target = ref.getTarget(session);
        return target == null ? "null" : target.toDisplayString(session);
    }

    private static BOrionAudit makeAuditRecord(BIOrionObject obj, String username, OrionSession session) {
        BOrionAudit rec = new BOrionAudit();
        rec.setTimestamp(BAbsTime.now());
        rec.setUserName(username);
        rec.setObjectTypeSpec(obj.getOrionType().getTypeSpec());
        rec.setObjectDisplay(obj.toDisplayString(session));
        return rec;
    }

    private static AuditEvent makeAuditEvent(BIOrionObject obj, OrionSession session, String operation, String slotName, String oldValue, String value, String username) {
        String userName = username;
        String target = "Orion " + obj.getOrionType().getDisplayName(null) + ", " + obj.toDisplayString(session);
        AuditEvent event = new AuditEvent(operation, target, slotName, oldValue, value, userName);
        return event;
    }

    @Override
    public final boolean isAuditable() {
        return false;
    }
}

