/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class BRef
extends BSimple {
    public static final BRef NULL;
    public static final BRef DEFAULT;
    private BOrionTypeId typeId;
    private BSimple id;
    private BIOrionObject target;
    public static final Type TYPE;

    public static BRef make(String typeSpec) {
        return BRef.make(BOrionTypeId.make(typeSpec));
    }

    public static BRef make(BTypeSpec typeSpec) {
        if (typeSpec.isNull()) {
            return NULL;
        }
        return new BRef(BOrionTypeId.make(typeSpec));
    }

    public static BRef make(BTypeSpec typeSpec, BSimple id) {
        return new BRef(BOrionTypeId.make(typeSpec), id);
    }

    public static BRef make(BOrionTypeId typeId) {
        return new BRef(typeId);
    }

    public static BRef make(BOrionTypeId typeId, BSimple id) {
        return new BRef(typeId, id);
    }

    public static BRef make(BIOrionObject obj) {
        OrionType otype = obj.getOrionType();
        Property[] props = otype.getKey();
        if (props == null || props.length != 1) {
            throw new OrionException(otype + " does not have exactly one identity property");
        }
        return new BRef(BOrionTypeId.make(otype.getTypeSpec()), (BSimple)obj.get(props[0]), obj);
    }

    private BRef() {
    }

    private BRef(BOrionTypeId typeId) {
        this(typeId, null);
    }

    private BRef(BOrionTypeId typeId, BSimple id) {
        this.typeId = typeId;
        this.id = id;
    }

    private BRef(BOrionTypeId typeId, BSimple id, BIOrionObject target) {
        this.typeId = typeId;
        this.id = id;
        this.target = target;
    }

    public OrionType getTargetOrionType(OrionSession session) {
        return (OrionType)this.getTargetTypeSpec().getResolvedType();
    }

    public BTypeSpec getTargetTypeSpec() {
        if (this.typeId == null) {
            return null;
        }
        return this.typeId.getTypeSpec();
    }

    public BOrionTypeId getTargetOrionTypeId() {
        return this.typeId;
    }

    public BSimple getId() {
        return this.id;
    }

    public boolean isBound() {
        return this.id != null;
    }

    public boolean isNull() {
        if (this == NULL) {
            return true;
        }
        return this.typeId == null && this.id == null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BRef)) {
            return false;
        }
        BRef other = (BRef)((Object)o);
        if (other.typeId == null && this.typeId != null) {
            return false;
        }
        if (other.typeId != null && this.typeId == null) {
            return false;
        }
        if (other.typeId != null && this.typeId != null && !other.typeId.equals((Object)this.typeId)) {
            return false;
        }
        if (other.id == null && this.id != null) {
            return false;
        }
        if (other.id != null && this.id == null) {
            return false;
        }
        if (other.id == null && this.id == null) {
            return true;
        }
        return other.id.equals((Object)this.id);
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        if (!this.isBound()) {
            return this.typeId.encodeToString();
        }
        return this.typeId.encodeToString() + ";" + this.id.getType().getTypeSpec().encodeToString() + ";" + this.id.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("null")) {
            return NULL;
        }
        int semi = s.indexOf(59);
        if (semi == -1) {
            return BRef.make(BOrionTypeId.decode(s));
        }
        StringTokenizer t = new StringTokenizer(s, ";");
        BOrionTypeId targetType = BOrionTypeId.decode(t.nextToken());
        BTypeSpec idType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(t.nextToken());
        BSimple proto = (BSimple)idType.getResolvedType().getInstance();
        if (t.hasMoreTokens()) {
            return BRef.make(targetType, (BSimple)proto.decodeFromString(t.nextToken()));
        }
        return BRef.make(targetType, (BSimple)proto.decodeFromString(""));
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String toDisplayString(OrionSession session) {
        if (this.id != null) {
            BIOrionObject target = this.getTarget(session);
            if (target != null) {
                return target.toDisplayString(session) + " (" + target.getType().getDisplayName(null) + ")";
            }
            return this.id + " (" + (Object)((Object)this.typeId) + ")";
        }
        return "ref->" + (Object)((Object)this.typeId);
    }

    public String toString(Context cx) {
        if (this.id != null) {
            return this.id + " (" + (Object)((Object)this.typeId) + ")";
        }
        return "ref->" + (Object)((Object)this.typeId);
    }

    public BIOrionObject getTarget() {
        if (!this.isBound()) {
            return null;
        }
        if (!this.isResolved()) {
            throw new OrionException("The target is not resolved.");
        }
        return this.target;
    }

    public BIOrionObject getTarget(OrionSession session) {
        if (!this.isBound()) {
            return null;
        }
        if (!this.isResolved()) {
            this.target = session.read(this.getTargetOrionType(session), this.getId());
        }
        return this.target;
    }

    public void resolve(BIOrionObject target) {
        if (!this.isBound()) {
            throw new OrionException("Cannot set auto-resolve target on unbound Ref.");
        }
        this.target = target;
    }

    public boolean isResolved() {
        return this.target != null;
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BRef();
        TYPE = Sys.loadType(BRef.class);
    }
}

