/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.OrionException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class BOrionTypeId
extends BSimple {
    public static final BOrionTypeId NULL;
    public static final BOrionTypeId DEFAULT;
    public static final BOrionTypeId TEMPORARY;
    public static final Type TYPE;
    private BOrd ordInSpace;
    private int hashCode;
    private String moduleName;
    private String typeName;
    private boolean dynamic = false;
    private BTypeSpec typeSpec;

    public static BOrionTypeId make(String id) {
        return BOrionTypeId.parse(id);
    }

    public static BOrionTypeId make(String moduleName, String typeName, boolean dynamic) {
        if (moduleName.length() == 0 && typeName.length() == 0 && dynamic) {
            return TEMPORARY;
        }
        return new BOrionTypeId(moduleName, typeName, dynamic);
    }

    public static BOrionTypeId make(Type type) {
        return BOrionTypeId.make(type.getTypeSpec());
    }

    public static BOrionTypeId make(BTypeSpec typeSpec) {
        if (typeSpec.isNull()) {
            return NULL;
        }
        BOrionTypeId newId = new BOrionTypeId(typeSpec.getModuleName(), typeSpec.getTypeName(), false);
        newId.typeSpec = typeSpec;
        return newId;
    }

    protected BOrionTypeId() {
        this("", "", false);
    }

    private BOrionTypeId(String moduleName, String typeName, boolean dynamic) {
        this.moduleName = moduleName;
        this.typeName = typeName;
        this.dynamic = dynamic;
        this.hashCode = this.encodeToString().hashCode();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public BTypeSpec getTypeSpec() {
        if (this.typeSpec == null) {
            if (this.dynamic) {
                return null;
            }
            return BTypeSpec.make((String)this.moduleName, (String)this.typeName);
        }
        return this.typeSpec;
    }

    public boolean isNull() {
        return this.equals((Object)NULL);
    }

    public boolean isTemporary() {
        return this == TEMPORARY;
    }

    public BOrd getTypeOrd(BOrionDatabase db) {
        return BOrionScheme.getOrdInSpace(db, this);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return BOrionTypeId.decode(in.readUTF());
    }

    public String encodeToString() {
        if (this.dynamic) {
            return this.moduleName + "::" + this.typeName;
        }
        return this.moduleName + ":" + this.typeName;
    }

    public static BOrionTypeId decode(String s) {
        return BOrionTypeId.make(s);
    }

    public BObject decodeFromString(String s) {
        return BOrionTypeId.make(s);
    }

    public String toString(Context cx) {
        return this.encodeToString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BOrionTypeId)) {
            return false;
        }
        BOrionTypeId other = (BOrionTypeId)((Object)o);
        return this.moduleName.equals(other.moduleName) && this.typeName.equals(other.typeName) && this.dynamic == other.dynamic;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static BOrionTypeId parse(String id) {
        if (id.equals(":")) {
            return NULL;
        }
        String moduleName = null;
        String typeName = null;
        boolean dynamic = false;
        int colon = id.indexOf(58);
        if (colon == -1) {
            moduleName = "orion";
            typeName = id;
            return BOrionTypeId.make(moduleName, typeName, true);
        }
        if (colon == id.length() - 1) {
            throw new OrionException("Invalid type id: " + id);
        }
        if (id.charAt(colon + 1) == ':') {
            moduleName = id.substring(0, colon);
            typeName = id.substring(colon + 2);
            return BOrionTypeId.make(moduleName, typeName, true);
        }
        BTypeSpec typeSpec = BTypeSpec.make((String)id);
        moduleName = typeSpec.getModuleName();
        typeName = typeSpec.getTypeName();
        BOrionTypeId newId = BOrionTypeId.make(moduleName, typeName, false);
        newId.typeSpec = typeSpec;
        return newId;
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BOrionTypeId();
        TEMPORARY = new BOrionTypeId("", "", true);
        TYPE = Sys.loadType(BOrionTypeId.class);
    }
}

