/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.orion.BAuditMode;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionRoot;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionException;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.sys.station.Station;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

public class BOrionService
extends BAbstractService
implements BIRestrictedComponent {
    public static final Property status = BOrionService.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOrionService.newProperty((int)3, (String)"", null);
    public static final Property ordMap = BOrionService.newProperty((int)5, (BValue)BOrdToCategoryMap.DEFAULT, null);
    public static final Property auditMode = BOrionService.newProperty((int)0, (BValue)BAuditMode.none, null);
    public static final Property auditWorker = BOrionService.newProperty((int)4, (BValue)new BOrionAuditWorker(), null);
    public static final Type TYPE = Sys.loadType(BOrionService.class);
    private static final BIcon icon = BIcon.make((String)"module://orion/rc/orion.png");
    public static final Logger log = Logger.getLogger("orion");
    private BOrionSpace space;
    private HashMap<String, BLocalOrionDatabase> dbs = new HashMap();
    private boolean ready = false;
    private Station.SaveListener saveListener = new Station.SaveListener(){

        public void stationSave() {
            BOrionService.this.checkpoint();
        }

        public void stationSaveOk() {
        }

        public void stationSaveFail(String cause) {
        }

        public String toString() {
            return "OrionService " + BOrionService.this.getNavOrd();
        }
    };

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrdToCategoryMap getOrdMap() {
        return (BOrdToCategoryMap)this.get(ordMap);
    }

    public void setOrdMap(BOrdToCategoryMap v) {
        this.set(ordMap, (BValue)v, null);
    }

    public BAuditMode getAuditMode() {
        return (BAuditMode)this.get(auditMode);
    }

    public void setAuditMode(BAuditMode v) {
        this.set(auditMode, (BValue)v, null);
    }

    public BOrionAuditWorker getAuditWorker() {
        return (BOrionAuditWorker)this.get(auditWorker);
    }

    public void setAuditWorker(BOrionAuditWorker v) {
        this.set(auditWorker, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BOrionService getService() {
        return (BOrionService)Sys.getService((Type)TYPE);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() {
        Station.addSaveListener((Station.SaveListener)this.saveListener);
    }

    public void started() {
        if (this.getStatus().isValid()) {
            this.boot();
        }
    }

    public void stopped() {
        this.shutdown();
    }

    public void serviceStopped() {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
    }

    public void boot() {
        for (BLocalOrionDatabase db : this.dbs.values()) {
            db.boot();
        }
        BValue channel = BFoxChannelRegistry.getPrototype().get("orion");
        if (channel == null) {
            BFoxChannelRegistry.getPrototype().add("orion", (BValue)new BOrionChannel());
        } else if (!channel.getType().is(BOrionChannel.TYPE)) {
            throw new OrionException("Orion channel already registered as " + channel.getType());
        }
        this.ready = true;
        for (BLocalOrionDatabase db : this.dbs.values()) {
            db.orionReady();
        }
    }

    public void shutdown() {
        this.ready = false;
        try {
            BFoxChannelRegistry.getPrototype().remove("orion");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.space != null) {
            try {
                BLocalHost.INSTANCE.removeNavChild((BINavNode)this.space);
                this.space.getRootComponent().removeAll();
                this.space.setRootComponent(null);
                this.space = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (BLocalOrionDatabase db : this.dbs.values()) {
            try {
                db.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.dbs.clear();
    }

    public boolean isOrionReady() {
        return this.ready;
    }

    public BOrionSpace getOrionSpace() {
        if (this.space == null) {
            this.space = new BOrionSpace();
            BOrionRoot root = new BOrionRoot();
            BCategoryMask catMask = this.getCategoryMask(root.getOrdInSession());
            if (catMask == null) {
                root.setCategoryMask(BCategoryMask.make((String)"1"), Context.decoding);
            } else {
                root.setCategoryMask(catMask, Context.decoding);
            }
            this.space.setRootComponent(root);
            BLocalHost.INSTANCE.addNavChild((BINavNode)this.space);
        }
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionDatabase getOrionDatabase(BRdbms rdbms) {
        String rdbmsName = rdbms.getName();
        HashMap<String, BLocalOrionDatabase> hashMap = this.dbs;
        synchronized (hashMap) {
            BLocalOrionDatabase db = this.dbs.get(rdbmsName);
            if (db == null) {
                db = this.initDatabase(rdbms);
                this.getOrionSpace().getRootComponent().add(db.getId(), (BValue)db);
                BCategoryMask cats = this.getOrdMap().getCategoryMask(db.getOrdInSession());
                if (cats != null) {
                    db.setCategoryMask(cats, Context.decoding);
                }
                this.dbs.put(db.getId(), db);
            }
            return db;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionDatabase getOrionDatabase(String dbId) {
        HashMap<String, BLocalOrionDatabase> hashMap = this.dbs;
        synchronized (hashMap) {
            return this.dbs.get(dbId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionDatabase[] getOrionDatabases() {
        HashMap<String, BLocalOrionDatabase> hashMap = this.dbs;
        synchronized (hashMap) {
            BOrionDatabase[] result = new BOrionDatabase[this.dbs.size()];
            int count = 0;
            Iterator<BLocalOrionDatabase> i = this.dbs.values().iterator();
            while (i.hasNext()) {
                result[count] = i.next();
            }
            return result;
        }
    }

    private BLocalOrionDatabase initDatabase(BRdbms rdbms) {
        BLocalOrionDatabase db = new BLocalOrionDatabase();
        db.init(this, rdbms);
        return db;
    }

    public void setCategoryMask(BOrd ord, BCategoryMask mask) {
        this.setOrdMap(this.getOrdMap().setCategoryMask(ord, mask));
    }

    public BCategoryMask getCategoryMask(BOrd ord) {
        return this.getOrdMap().getCategoryMask(ord);
    }

    public BCategoryMask getAppliedCategoryMask(BOrd ord) {
        return this.getOrdMap().getAppliedCategoryMask(ord);
    }

    private void checkpoint() {
        for (BLocalOrionDatabase db : this.dbs.values()) {
            BRdbms rdb = db.getRdbms();
            RdbmsDialect dialect = (RdbmsDialect)rdb.getRdbmsContext();
            try {
                log.log(Level.INFO, "begin checkpoint on " + rdb.getName() + " (" + rdb.getType() + ")");
                DbOrionSession session = (DbOrionSession)db.createSession(null);
                Connection conn = session.getUnderylingConnection();
                dialect.issueCheckpoint(conn);
                session.close();
                log.log(Level.INFO, "end checkpoint on " + rdb.getName() + " (" + rdb.getType() + ")");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.log(Level.SEVERE, "Cannot issue checkpoint on " + rdb.getName() + " (" + rdb.getType() + ")");
            }
        }
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BIcon getIcon() {
        return icon;
    }
}

