/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BRef;
import com.tridium.orion.Index;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.OrionIntrospector;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.rdb.ddl.BOnDelete;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BOrionObject
extends BComponent
implements BIOrionObject {
    private static final Class<?> INTROSPECTOR = OrionIntrospector.class;
    public static final Type TYPE = Sys.loadType(BOrionObject.class);
    private static final Index[] NO_INDEXES = new Index[0];
    public static final int MODIFIED = 0x10000000;
    public static final int NULL = 0x20000000;
    public static final Context INIT_CONTEXT = new BasicContext();
    public static final String IDENTITY = "identity";
    public static final String KEY = "key";
    public static final String UNIQUE = "unique";
    public static final String INDEXED = "indexed";
    public static final String CLOB = "clob";
    public static final String WIDTH = "width";
    public static final String DESCENDING = "descending";
    public static final String CLUSTERED = "clustered";
    public static final String ON_DELETE = "onDelete";
    public static final String INVERSE = "inverse";
    public static final String DISPLAY_ID = "displayId";
    public static final String AUTO_RESOLVE = "autoResolve";
    public static final String DB_SOURCED = "dbSourced";
    public static BFacets ID_KEY = BFacets.make((String)"key", (BIDataValue)BBoolean.TRUE, (String)"identity", (BIDataValue)BBoolean.TRUE);
    private BOrionDatabase db;
    private boolean modified = false;
    private BOrionObject orig;

    public String getNavDisplayName(Context cx) {
        return this.toDisplayString(cx);
    }

    @Override
    public BOrd getNavOrd() {
        BSpace space = this.getSpace();
        if (space == null) {
            return null;
        }
        return BOrd.make((BOrd)space.getNavOrd(), (BOrd)this.getOrdInSpace()).normalize();
    }

    @Override
    public void init(Property p, BValue value) {
        this.set(p, value, INIT_CONTEXT);
    }

    @Override
    public void copyFrom(BIOrionObject obj) {
        if (!this.getOrionType().toString().equals(obj.getOrionType().toString())) {
            throw new OrionException("Type mismatch: " + obj.getOrionType() + " != " + this.getOrionType());
        }
        if (obj instanceof BOrionObject) {
            this.copyFrom((BComplex)obj);
        } else {
            Property[] props = this.getOrionType().getProperties();
            for (int i = 0; i < props.length; ++i) {
                this.set(props[i], obj.get(props[i]));
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public boolean isModified(Property p) {
        return (this.getFlags((Slot)p) & 0x10000000) != 0;
    }

    @Override
    public void setModified(Property p, boolean mod) {
        if (mod) {
            this.modified = true;
            this.setFlags((Slot)p, this.getFlags((Slot)p) | 0x10000000);
        } else {
            this.setFlags((Slot)p, this.getFlags((Slot)p) & 0xEFFFFFFF);
            this.modified = this.anyModified();
        }
    }

    private boolean anyModified() {
        Property[] props = ((OrionType)this.getType()).getProperties();
        for (int i = 0; i < props.length; ++i) {
            Property p = props[i];
            if (!p.isFrozen() || !this.isModified(p)) continue;
            return true;
        }
        return false;
    }

    public void setAllModified() {
        Property[] props = this.getOrionType().getProperties();
        for (int i = 0; i < props.length; ++i) {
            Property p = props[i];
            if (!p.isFrozen() || BOrionObject.isKey(p)) continue;
            this.setFlags((Slot)p, this.getFlags((Slot)p) | 0x10000000);
        }
    }

    @Override
    public void clearAllModified() {
        Property[] props = ((OrionType)this.getType()).getProperties();
        for (int i = 0; i < props.length; ++i) {
            Property p = props[i];
            if (!p.isFrozen()) continue;
            this.setFlags((Slot)p, this.getFlags((Slot)p) & 0xEFFFFFFF);
        }
    }

    @Override
    public String toDisplayString(Context cx) {
        int i;
        OrionType type = this.getOrionType();
        Property[] dps = type.getProperties();
        int displayCount = 0;
        StringBuffer s = new StringBuffer(64);
        for (i = 0; i < dps.length; ++i) {
            if (!BOrionObject.isDisplayId(dps[i])) continue;
            if (displayCount != 0) {
                s.append(", ");
            }
            if (cx instanceof OrionSession && dps[i].getType() == BRef.TYPE) {
                s.append(((BRef)this.get(dps[i])).toDisplayString((OrionSession)cx));
            } else {
                s.append(this.get(dps[i]).toString(cx));
            }
            ++displayCount;
        }
        if (displayCount == 0) {
            dps = type.getKey();
            for (i = 0; i < dps.length; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                if (cx instanceof OrionSession && dps[i].getType() == BRef.TYPE) {
                    s.append(((BRef)this.get(dps[i])).toDisplayString((OrionSession)cx));
                    continue;
                }
                s.append(this.get(dps[i]).toString(cx));
            }
        }
        return s.toString();
    }

    @Override
    public boolean equivalent(Object o) {
        return BOrionObject.equivalent(this, (BIOrionObject)o);
    }

    public static boolean equivalent(BIOrionObject o1, BIOrionObject o2) {
        OrionType t1 = o1.getOrionType();
        OrionType t2 = o2.getOrionType();
        if (!t1.getOrionTypeId().equals((Object)t2.getOrionTypeId())) {
            return false;
        }
        Property[] keys = t1.getKey();
        for (int i = 0; i < keys.length; ++i) {
            if (o1.get(keys[i]).equals((Object)o2.get(keys[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(BIOrionObject o1, BIOrionObject o2) {
        OrionType t1 = o1.getOrionType();
        OrionType t2 = o2.getOrionType();
        if (!t1.getOrionTypeId().equals((Object)t2.getOrionTypeId())) {
            return false;
        }
        Property[] props = t1.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (o1.get(props[i]).equals((Object)o2.get(props[i]))) continue;
            return false;
        }
        return true;
    }

    public void changed(Property p, Context cx) {
        if (cx == INIT_CONTEXT) {
            return;
        }
        if (cx == Context.decoding) {
            return;
        }
        if (cx == Context.copying) {
            return;
        }
        this.setFlags((Slot)p, this.getFlags((Slot)p) | 0x10000000);
        this.modified = true;
    }

    @Override
    public BOrionSpace getOrionSpace() {
        BSpace space = this.getSpace();
        if (space instanceof BOrionSpace) {
            return (BOrionSpace)space;
        }
        return null;
    }

    private void setOrionSpace(BOrionSpace space) {
        BSpace currentSpace = this.getSpace();
        if (currentSpace != null) {
            if (currentSpace != space) {
                throw new OrionException("Already mounted.");
            }
            return;
        }
        ComponentSlotMap slotMap = (ComponentSlotMap)this.fw(1);
        slotMap.mount((BComponentSpace)space, null, null);
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        return this.db;
    }

    @Override
    public void setOrionDatabase(BOrionDatabase db) {
        this.db = db;
        if (db != null) {
            this.setOrionSpace(db.getOrionSpace());
        }
    }

    @Override
    public Object getHandle() {
        return this.getOrdInSpace();
    }

    @Override
    public BOrd getOrdInSpace() {
        return BOrionScheme.getOrdInSpace(this);
    }

    @Override
    public Index[] getIndexes() {
        return NO_INDEXES;
    }

    @Override
    public boolean isAuditable() {
        return false;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 702: {
                this.orig = (BOrionObject)this.getOrionType().getInstance();
                this.orig.copyFrom(this);
                return null;
            }
            case 703: {
                if (this.orig == null) {
                    this.orig = (BOrionObject)this.getOrionType().getInstance();
                    this.orig.copyFrom(this);
                }
                return this.orig.get((Property)a);
            }
            case 704: {
                Property p = (Property)a;
                boolean isNull = (Boolean)b;
                this.setNull(p, isNull);
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public static boolean isKey(Property property) {
        return property.getFacets().getb(KEY, false);
    }

    public static boolean isDbSourced(Property property) {
        return property.getFacets().getb(DB_SOURCED, false);
    }

    public static boolean isAutoResolve(Property property) {
        return property.getType().is(BRef.TYPE) ? property.getFacets().getb(AUTO_RESOLVE, false) : false;
    }

    public static boolean isIdentity(Property property) {
        return property.getFacets().getb(IDENTITY, false);
    }

    public static boolean isUnique(Property property) {
        return property.getFacets().getb(UNIQUE, false);
    }

    public static boolean isIndexed(Property property) {
        return property.getFacets().getb(INDEXED, false);
    }

    public static boolean isDescending(Property property) {
        return property.getFacets().getb(DESCENDING, false);
    }

    public static BClustered isClustered(Property property) {
        if (property.getFacets().get(CLUSTERED) == null) {
            return BClustered.unspecified;
        }
        return property.getFacets().getb(CLUSTERED, false) ? BClustered.clustered : BClustered.nonClustered;
    }

    public static int getWidth(Property property) {
        return property.getFacets().geti(WIDTH, -1);
    }

    public static boolean isClob(Property property) {
        return property.getFacets().getb(CLOB, false);
    }

    public static BOnDelete getOnDelete(Property property) {
        return BOnDelete.make((int)property.getFacets().geti(ON_DELETE, 0));
    }

    public static boolean isDisplayId(Property property) {
        return property.getFacets().getb(DISPLAY_ID, false);
    }

    @Override
    public boolean beforeInsert(OrionSession session) {
        return true;
    }

    @Override
    public void afterInsert(OrionSession session) {
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        return true;
    }

    @Override
    public void afterUpdate(OrionSession session) {
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        return true;
    }

    @Override
    public void afterDelete(OrionSession session) {
    }

    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    public final OrionType getOrionType() {
        return (OrionType)this.getType();
    }

    public final Type getTypeFromSpace(Type type) {
        return type;
    }

    public BPermissions getPermissions(Context cx) {
        if (cx == null) {
            return BPermissions.all;
        }
        if (cx.getUser() == null) {
            return BPermissions.all;
        }
        BOrionDatabase db = this.getOrionDatabase();
        if (db == null) {
            return BPermissions.all;
        }
        BOrionType type = db.getType(this.getOrionType());
        if (type == null) {
            return BPermissions.all;
        }
        return type.getPermissions(cx);
    }

    public BCategoryMask getAppliedCategoryMask() {
        BOrionDatabase db = this.getOrionDatabase();
        if (db == null) {
            return BCategoryMask.WILDCARD;
        }
        return db.getType(this.getOrionType()).getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        BOrionDatabase db = this.getOrionDatabase();
        if (db == null) {
            return BCategoryMask.WILDCARD;
        }
        return db.getType(this.getOrionType()).getCategoryMask();
    }

    @Override
    public boolean isNull(Property p) {
        return (this.getFlags((Slot)p) & 0x20000000) != 0;
    }

    private void setNull(Property p, boolean isNull) {
        if (isNull) {
            this.setFlags((Slot)p, this.getFlags((Slot)p) | 0x20000000);
        } else {
            this.setFlags((Slot)p, this.getFlags((Slot)p) & 0xDFFFFFFF);
        }
    }
}

