/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionType;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BOrionModule
extends BComponent
implements BIOrionDatabaseObject {
    private static final BIcon icon = BIcon.std((String)"module.png");
    public static final Type TYPE = Sys.loadType(BOrionModule.class);
    private String moduleName;
    private BPermissions permissions;

    public BOrionModule() {
    }

    public BOrionModule(String moduleName) {
        this(moduleName, null);
    }

    public BOrionModule(String moduleName, BPermissions permissions) {
        this.moduleName = moduleName;
        this.permissions = permissions;
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        return (BOrionDatabase)this.getParent();
    }

    public String getModuleName() {
        if (!this.isMounted()) {
            return this.moduleName;
        }
        return this.getName();
    }

    public BOrionType getType(String typeName) {
        return (BOrionType)this.get(typeName);
    }

    public BOrionType[] getTypes() {
        Array temp = new Array(BOrionType.class);
        SlotCursor c = this.getProperties();
        while (c.next(BOrionType.class)) {
            temp.add((Object)((BOrionType)c.get()));
        }
        return (BOrionType[])temp.trim();
    }

    public BOrd getNavOrd() {
        BSpace space = this.getSpace();
        if (space == null) {
            return null;
        }
        return BOrd.make((BOrd)space.getNavOrd(), (BOrd)this.getOrdInSpace()).normalize();
    }

    public Object getHandle() {
        return this.getHandleOrd();
    }

    public BOrd getHandleOrd() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSession() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSpace() {
        return BOrionScheme.getOrdInSpace(this);
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents = agents.filter((AgentFilter)new OrionAgentFilter());
        return agents;
    }

    public BPermissions getPermissions(Context cx) {
        if (this.permissions != null) {
            return this.permissions;
        }
        return super.getPermissions(cx);
    }

    public void setCategoryMask(BCategoryMask catMask, Context cx) {
        if (cx != Context.decoding) {
            try {
                BOrionService.getService().setCategoryMask(this.getOrdInSession(), catMask);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setCategoryMask(catMask, cx);
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type getType() {
        return TYPE;
    }

    private static class OrionAgentFilter
    extends AgentFilter {
        private OrionAgentFilter() {
        }

        public boolean include(AgentInfo info) {
            TypeInfo agentType = info.getAgentType();
            return agentType.getModuleName().equals("orion");
        }
    }
}

