/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionType;
import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNameFactory
extends BComponent {
    public static final Type TYPE = Sys.loadType(BNameFactory.class);
    public static BNameFactory INSTANCE = new BNameFactory();

    public String getTableName(BOrionDatabase db, OrionType type) {
        return type.getModule().getModuleName() + "_" + type.getTypeName();
    }

    public String getColumnName(BOrionDatabase db, OrionType type, Property property) {
        return property.getName();
    }

    public String getConstraintName(BOrionDatabase db, OrionType type, Property property, String suffix, boolean isPrimaryKey) {
        int clen;
        String tableName = this.getTableName(db, type);
        String columnName = isPrimaryKey ? "" : this.getColumnName(db, type, property);
        RdbmsDialect dialect = (RdbmsDialect)db.getRdbms().getRdbmsContext();
        int len = dialect.getMaxConstraintName() - suffix.length();
        int tlen = tableName.length();
        if (tlen + (clen = columnName.length()) <= len) {
            return tableName + columnName + suffix;
        }
        int half = len / 2;
        if (tlen > half) {
            tableName = tableName.substring(0, half);
        }
        if (clen > half) {
            columnName = columnName.substring(0, half);
        }
        return tableName + columnName + suffix;
    }

    public String getIndexName(BOrionDatabase db, OrionType type, Property property) {
        int clen;
        String tableName = this.getTableName(db, type);
        String columnName = this.getColumnName(db, type, property);
        RdbmsDialect dialect = (RdbmsDialect)db.getRdbms().getRdbmsContext();
        int len = dialect.getMaxIndexName();
        int tlen = tableName.length();
        if (tlen + (clen = columnName.length()) <= len) {
            return tableName + columnName;
        }
        int half = len / 2;
        if (tlen > half) {
            tableName = tableName.substring(0, half);
        }
        if (clen > half) {
            columnName = columnName.substring(0, half);
        }
        return tableName + columnName;
    }

    public Type getType() {
        return TYPE;
    }
}

