/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BNameFactory;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAudit;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.model.SortingUtil;
import com.tridium.orion.priv.util.BOrionAppVersion;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.TableBuilder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BLocalOrionDatabase
extends BOrionDatabase {
    public static final Type TYPE = Sys.loadType(BLocalOrionDatabase.class);
    public static Logger log = Logger.getLogger("orion");
    private BOrionService service;
    private Array<BIOrionApp> appList = new Array(BIOrionApp.class);
    private HashSet<BIOrionApp> appSet = new HashSet();
    private Array<OrionType> typeList = new Array(OrionType.class);
    private HashMap<BOrionTypeId, OrionType> idMap = new HashMap();
    private boolean committed = false;
    private HashMap<OrionType, BNameFactory> typeToFactory = new HashMap();
    private BRdbms rdb;
    private TableDefinition[] tableDefs;
    private Map<BOrionTypeId, TableDefinition> tablesByType = new HashMap<BOrionTypeId, TableDefinition>();

    public void init(BOrionService service, BRdbms rdb) {
        this.service = service;
        this.rdb = rdb;
    }

    @Override
    public String getId() {
        return this.rdb.getName();
    }

    @Override
    public BOrionSpace getOrionSpace() {
        return this.service.getOrionSpace();
    }

    public void boot() {
        BIOrionApp[] apps = this.getApps();
        for (int i = 0; i < apps.length; ++i) {
            OrionType[] types = apps[i].getOrionTypes();
            if (types == null) continue;
            for (int j = 0; j < types.length; ++j) {
                this.registerType(types[j], apps[i]);
            }
        }
        this.registerType(BOrionAppVersion.ORION_TYPE, null);
        this.registerType(BOrionAudit.ORION_TYPE, null);
        if (!this.getRdbms().isRunning()) {
            this.getRdbms().start();
        }
        this.open();
    }

    private void open() {
        this.commitTypes();
        this.createTableMap();
        try (OrionSession session = null;){
            BBoolean testMode = (BBoolean)this.service.get("testMode");
            if (testMode != null && testMode.getBoolean()) {
                this.dropAllTables();
            }
            session = this.createSession(null);
            this.ensureTableExists(session, BOrionAppVersion.ORION_TYPE);
            this.ensureTableExists(session, BOrionAudit.ORION_TYPE);
            BIOrionApp[] apps = SortingUtil.sortApps(this, this.getApps());
            for (int i = 0; i < apps.length; ++i) {
                this.createOrUpgradeApp(session, apps[i]);
            }
        }
    }

    void orionReady() {
        BIOrionApp[] apps = this.getApps();
        for (int i = 0; i < apps.length; ++i) {
            try {
                apps[i].orionReady(this);
                continue;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "App notification failed for " + apps[i], ex);
            }
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerApp(BIOrionApp app) {
        Array<BIOrionApp> array = this.appList;
        synchronized (array) {
            if (!this.appList.contains((Object)app)) {
                this.appList.add((Object)app);
                this.appSet.add(app);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegistered(BIOrionApp app) {
        Array<BIOrionApp> array = this.appList;
        synchronized (array) {
            return this.appSet.contains(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterApp(BIOrionApp app) {
        Array<BIOrionApp> array = this.appList;
        synchronized (array) {
            this.appList.remove((Object)app);
            this.appSet.remove(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionApp[] getApps() {
        Array<BIOrionApp> array = this.appList;
        synchronized (array) {
            return (BIOrionApp[])this.appList.trim();
        }
    }

    @Override
    public BNameFactory getNameFactory(OrionType type) {
        BNameFactory f = this.typeToFactory.get(type);
        if (f == null) {
            if (type.isDynamic()) {
                return BNameFactory.INSTANCE;
            }
            throw new IllegalStateException("Cannot find NameFactory for type " + type);
        }
        return f;
    }

    private BNameFactory makeNameFactory(OrionType type, BIOrionApp app) {
        AgentList agents;
        if (app != null && (agents = BLocalOrionDatabase.findNameFactoryAgents((BObject)app)).size() == 1) {
            return (BNameFactory)agents.getDefault().getInstance();
        }
        agents = BLocalOrionDatabase.findNameFactoryAgents((BObject)this);
        if (agents.size() == 1) {
            return (BNameFactory)agents.getDefault().getInstance();
        }
        return BNameFactory.INSTANCE;
    }

    private static AgentList findNameFactoryAgents(BObject obj) {
        AgentList agents = obj.getAgents().filter(AgentFilter.is((Type)BNameFactory.TYPE));
        if (agents.size() > 1) {
            throw new IllegalStateException("More than one NameFactory found: " + agents);
        }
        return agents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerType(OrionType newType, BIOrionApp owner) {
        if (this.committed) {
            throw new OrionException("Cannot add " + (Object)((Object)newType.getOrionTypeId()) + " to the database model.  The database model has already been committed.");
        }
        String moduleName = newType.getModule().getModuleName();
        BOrionModule module = (BOrionModule)this.get(moduleName);
        if (module == null) {
            module = new BOrionModule(moduleName);
            this.add(moduleName, (BValue)module);
            BCategoryMask cats = this.service.getOrdMap().getCategoryMask(module.getOrdInSession());
            if (cats != null) {
                module.setCategoryMask(cats, Context.decoding);
            }
        }
        BOrionType dbType = new BOrionType(newType);
        module.add(dbType.getOrionType().getTypeName(), (BValue)dbType);
        BCategoryMask cats = this.service.getOrdMap().getCategoryMask(dbType.getOrdInSession());
        if (cats != null) {
            dbType.setCategoryMask(cats, Context.decoding);
        }
        OrionType mtype = newType;
        Object object = this.typeList;
        synchronized (object) {
            this.typeList.add((Object)mtype);
        }
        object = this.idMap;
        synchronized (object) {
            this.idMap.put(mtype.getOrionTypeId(), mtype);
        }
        this.typeToFactory.put(newType, this.makeNameFactory(newType, owner));
    }

    @Override
    public BOrionType[] getTypes() {
        Array temp = new Array(BOrionType.class, 64);
        SlotCursor modules = this.getProperties();
        while (modules.next(BOrionModule.class)) {
            BOrionModule module = (BOrionModule)modules.get();
            SlotCursor types = module.getProperties();
            while (types.next(BOrionType.class)) {
                temp.add((Object)((BOrionType)types.get()));
            }
        }
        return (BOrionType[])temp.trim();
    }

    @Override
    public BOrionType getType(BTypeSpec typeSpec) {
        String moduleName = typeSpec.getModuleName();
        String typeName = typeSpec.getTypeName();
        BOrionModule module = this.getModule(moduleName);
        if (module == null) {
            return null;
        }
        return module.getType(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrionType getType(BOrionTypeId id) {
        HashMap<BOrionTypeId, OrionType> hashMap = this.idMap;
        synchronized (hashMap) {
            return this.idMap.get((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BTypeDependency[] getDependentTypes(OrionType baseType) {
        BOrionTypeId baseTypeId = baseType.getOrionTypeId();
        Array temp = new Array(BTypeDependency.class);
        Array<OrionType> array = this.typeList;
        synchronized (array) {
            for (OrionType type : this.typeList) {
                Property[] props = type.getProperties();
                for (int j = 0; j < props.length; ++j) {
                    BRef def;
                    Property p = props[j];
                    if (p.getType() != BRef.TYPE || !(def = (BRef)p.getDefaultValue()).getTargetOrionTypeId().equals((Object)baseTypeId)) continue;
                    temp.add((Object)BTypeDependency.make(type.getOrionTypeId(), p.getName(), baseType.getOrionTypeId(), baseType.getKey()[0].getName()));
                }
            }
        }
        return (BTypeDependency[])temp.trim();
    }

    private void createTableMap() {
        BOrionType[] ot = this.getTypes();
        this.tableDefs = new TableDefinition[ot.length];
        for (int i = 0; i < ot.length; ++i) {
            this.tableDefs[i] = new TableDefinition(this, ot[i].getOrionType());
            this.tablesByType.put(ot[i].getOrionTypeId(), this.tableDefs[i]);
        }
    }

    private void commitTypes() {
        OrionType t;
        int i;
        for (i = 0; i < this.typeList.size(); ++i) {
            t = (OrionType)this.typeList.get(i);
            this.resolve(t);
        }
        for (i = 0; i < this.typeList.size(); ++i) {
            t = (OrionType)this.typeList.get(i);
            this.validateTypeHierarchy(t);
        }
        this.typeList = new Array((Object[])SortingUtil.sortTypes(this, (OrionType[])this.typeList.trim()));
        this.committed = true;
    }

    private void resolve(OrionType type) {
        boolean hasKey = false;
        Property[] properties = type.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            this.resolve(type, properties[i]);
            if (hasKey) continue;
            hasKey = BOrionObject.isKey(properties[i]);
        }
        if (!type.isAssociation() && !hasKey) {
            throw new OrionException("Non-association types must have at least one identity property. (" + (Object)((Object)type.getOrionTypeId()) + ")");
        }
    }

    private void resolve(OrionType type, Property p) {
        BRef ref;
        BOrionTypeId targetTypeId;
        OrionType targetType;
        if (p.getType() == BRef.TYPE && (targetType = this.getType(targetTypeId = (ref = (BRef)p.getDefaultValue()).getTargetOrionTypeId())) == null) {
            throw new OrionException("Cannot resolve target type for ref " + type.getTypeName() + "." + p.getName() + "->" + (Object)((Object)targetTypeId));
        }
    }

    private void validateTypeHierarchy(OrionType type) {
        HashMap<BOrionTypeId, OrionType> hierarchy = new HashMap<BOrionTypeId, OrionType>();
        for (OrionType t = type; t != null; t = t.getOrionSuperType()) {
            if (hierarchy.get((Object)t.getOrionTypeId()) != null) {
                throw new OrionException("Cycle detected in type hierarchy for " + this);
            }
            hierarchy.put(t.getOrionTypeId(), t);
        }
    }

    public DdlCommand[] createTables() {
        Array arr = new Array(DdlCommand.class);
        for (int i = 0; i < this.tableDefs.length; ++i) {
            TableBuilder tb = new TableBuilder(this, this.tableDefs[i].getOrionType());
            arr.addAll((Object[])tb.createTable());
        }
        return (DdlCommand[])arr.trim();
    }

    public DdlCommand[] dropTables() {
        Array arr = new Array(DdlCommand.class);
        OrionType[] orionTypes = SortingUtil.sortTypes(this, (OrionType[])this.typeList.trim());
        for (int i = orionTypes.length - 1; i >= 0; --i) {
            TableBuilder tb = new TableBuilder(this, orionTypes[i]);
            DdlCommand[] ddl = tb.dropTable();
            for (int j = ddl.length - 1; j >= 0; --j) {
                arr.add((Object)ddl[j]);
            }
        }
        return (DdlCommand[])arr.trim();
    }

    public DdlCommand[] createTable(OrionType type) {
        TableDefinition tableDef = this.tablesByType.get((Object)type.getOrionTypeId());
        TableBuilder tb = new TableBuilder(this, tableDef.getOrionType());
        return tb.createTable();
    }

    public DdlCommand[] dropTable(OrionType type) {
        TableDefinition tableDef = this.tablesByType.get((Object)type.getOrionTypeId());
        TableBuilder tb = new TableBuilder(this, tableDef.getOrionType());
        return tb.dropTable();
    }

    private void dropAllTables() {
        RdbmsContext context = this.rdb.getRdbmsContext();
        OrionSession session = this.createSession(null);
        DdlCommand[] drop = this.dropTables();
        for (int d = 0; d < drop.length; ++d) {
            try {
                session.invokeDdl(drop[d]);
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "DROP FAILED: " + e.getMessage());
            }
        }
        session.close();
    }

    private void ensureTableExists(OrionSession session, OrionType type) {
        if (!this.doesTableExist(session, type)) {
            RdbmsContext context = this.rdb.getRdbmsContext();
            DdlCommand[] ddl = this.createTable(type);
            for (int i = 0; i < ddl.length; ++i) {
                session.invokeDdl(ddl[i]);
            }
        }
    }

    private boolean doesTableExist(OrionSession session, OrionType type) {
        TableDefinition def = this.tablesByType.get((Object)type.getOrionTypeId());
        String tableName = def.getTableName();
        String schemaName = null;
        String[] tableTypes = null;
        BTypeSpec spec = this.rdb.getType().getTypeSpec();
        if (spec.equals((Object)BTypeSpec.make((String)"rdbHsqlDb:HsqlDatabase")) || spec.equals((Object)BTypeSpec.make((String)"rdbOracle:OracleDatabase")) || spec.equals((Object)BTypeSpec.make((String)"rdbDb2:Db2Database"))) {
            tableName = tableName.toUpperCase();
        }
        if (spec.equals((Object)BTypeSpec.make((String)"rdbMySQL:MySQLDatabase"))) {
            BRdbms comp = this.rdb;
            schemaName = comp.get("databaseName").toString();
            tableTypes = new String[]{"TABLE"};
        }
        Connection conn = null;
        try {
            conn = this.rdb.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            ResultSet tables = md.getTables(schemaName, null, tableName, tableTypes);
            boolean exists = tables.next();
            tables.close();
            boolean bl = exists;
            return bl;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createOrUpgradeApp(OrionSession session, BIOrionApp app) throws Exception {
        BOrionAppVersion persisted = (BOrionAppVersion)session.read(BOrionAppVersion.ORION_TYPE, new PropertyValue(BOrionAppVersion.app, (BValue)app.getType().getTypeSpec()));
        if (persisted == null) {
            RdbmsContext context = this.rdb.getRdbmsContext();
            OrionType[] types = SortingUtil.sortTypes(session.getOrionDatabase(), app.getOrionTypes());
            for (int i = 0; i < types.length; ++i) {
                DdlCommand[] ddl = this.createTable(types[i]);
                for (int j = 0; j < ddl.length; ++j) {
                    session.invokeDdl(ddl[j]);
                }
            }
            persisted = new BOrionAppVersion();
            persisted.setApp(app.getType().getTypeSpec());
            persisted.setSchemaVersion(app.getSchemaVersion());
            session.insert(persisted);
        } else {
            int compareTo = app.getSchemaVersion().compareTo((Object)persisted.getSchemaVersion());
            if (compareTo > 0) {
                app.performSchemaUpgrade(this, persisted.getSchemaVersion());
                persisted.setSchemaVersion(app.getSchemaVersion());
                session.update(persisted);
            } else if (compareTo < 0) {
                throw new OrionException("Application version mismatch: " + app.getType().getTypeSpec() + " has version " + (Object)((Object)app.getSchemaVersion()) + "database  has version " + (Object)((Object)persisted.getSchemaVersion()));
            }
        }
    }

    @Override
    public OrionSession createSession(Context cx) {
        OrionSession s = this.makeSession(cx);
        this.sessionOpened(s);
        return s;
    }

    protected OrionSession makeSession(Context cx) {
        return new DbOrionSession(this, cx);
    }

    public void sessionOpened(OrionSession session) {
    }

    public void sessionClosed(OrionSession session) {
    }

    public BOrionService getOrionService() {
        return this.service;
    }

    @Override
    public BRdbms getRdbms() {
        return this.rdb;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 701: {
                return this.tablesByType.get((Object)((OrionType)a).getOrionTypeId());
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public void setCategoryMask(BCategoryMask catMask, Context cx) {
        BOrionService.getService().setCategoryMask(this.getOrdInSession(), catMask);
        super.setCategoryMask(catMask, cx);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

