/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.driver.ui;

import com.tridium.json.JSONObject;
import com.tridiumeurope.httpClient.datatypes.options.BMultiAddOptions;
import com.tridiumeurope.httpClient.util.MultiAddUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"httpClient:MultiAddOptions"})})
public class BMultiAddFieldEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BMultiAddFieldEditor.class);
    private BComplex instanceToDuplicate;
    private BMultiAddOptions state;
    private final Map<String, BGridPane> columns = new HashMap<String, BGridPane>(3);
    private final BGridPane formPane;
    private final BGridPane colNameGrid = new BGridPane(1);
    private final Command addCommand;
    private final BTextField total;
    private final BListDropDown slotsWithDifferences;
    private static final int MAX_COLS = 3;
    private static final String NAME_TEXTFIELD = "nameTextField";
    private static final String EDITOR = "editor";
    private static final Lexicon LEXICON = Lexicon.make(BMultiAddFieldEditor.class);
    public static final int MAX_PROPERTY_DEPTH = 4;

    public Type getType() {
        return TYPE;
    }

    public BMultiAddFieldEditor() {
        BScrollPane scrollPane = new BScrollPane();
        BFlowPane flowPane = new BFlowPane();
        BGridPane outerGrid = new BGridPane(1);
        BGridPane totalGrid = new BGridPane(2);
        BLabel totalLabel = new BLabel(LEXICON.getText("totalLabel"));
        totalGrid.add("totalLbl", (BValue)totalLabel);
        this.total = new BTextField("1", 3);
        totalGrid.add("total", (BValue)this.total);
        outerGrid.add("totalGrid", (BValue)totalGrid);
        BGridPane slotsPickerGrid = new BGridPane(3);
        BLabel slotsLabel = new BLabel(LEXICON.getText("slotsLabel"));
        slotsPickerGrid.add("slotsLbl", (BValue)slotsLabel);
        this.slotsWithDifferences = new BListDropDown();
        slotsPickerGrid.add("slots", (BValue)this.slotsWithDifferences);
        this.addCommand = new AddCommand();
        BButton addButton = new BButton(this.addCommand);
        addButton.setButtonStyle(BButtonStyle.toolBar);
        addButton.setPadding(BInsets.NULL);
        slotsPickerGrid.add("addButton", (BValue)addButton);
        outerGrid.add("slotsPickerGrid", (BValue)slotsPickerGrid);
        this.formPane = new BGridPane(4);
        this.formPane.add("colName", (BValue)this.colNameGrid);
        outerGrid.add("formPane", (BValue)this.formPane);
        flowPane.add("outerGrid", (BValue)outerGrid);
        scrollPane.setBounds(0.0, 0.0, 400.0, 300.0);
        scrollPane.setContent((BWidget)flowPane);
        this.setContent((BWidget)scrollPane);
    }

    private void buildEditablePropertiesList(BComplex complex, String parentName, int depth) {
        Arrays.stream(complex.getPropertiesArray()).filter(prop -> (prop.getDefaultFlags() & 0xFFFFFFFB) == 0 && (prop.getDefaultFlags() & 0xFFFFFFFE) == 0).forEach(prop -> {
            if (prop.getType().is(BSimple.TYPE)) {
                this.slotsWithDifferences.getList().addItem((Object)(parentName + prop.getName()));
            } else if (depth < 4) {
                BComplex childComplex = complex.get(prop).asComplex();
                this.buildEditablePropertiesList(childComplex, parentName.isEmpty() ? prop.getName() + '.' : parentName + prop.getName() + '.', depth + 1);
            }
        });
    }

    protected void doLoadValue(BObject value, Context context) {
        if (value instanceof BMultiAddOptions) {
            this.state = (BMultiAddOptions)value.as(BMultiAddOptions.class);
            this.state.validateInput();
            this.instanceToDuplicate = this.state.getInstanceToDuplicate();
            this.buildEditablePropertiesList(this.instanceToDuplicate, "", 1);
            this.addButtonEnabledState();
            this.state.setToCreate("{}");
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BWidget[] nameWidgets = this.colNameGrid.getChildWidgets();
        int totalToCreate = nameWidgets.length - 1;
        if (totalToCreate < 1 || totalToCreate > 100) {
            throw new CannotSaveException(LEXICON.get("createTotalError"));
        }
        JSONObject toCreateJson = new JSONObject();
        for (int i = 0; i < totalToCreate; ++i) {
            JSONObject newSlotValues;
            BTextField nameField = (BTextField)this.colNameGrid.get(NAME_TEXTFIELD + i).as(BTextField.class);
            if (!nameField.getText().isEmpty()) {
                newSlotValues = new JSONObject();
                for (Map.Entry<String, BGridPane> column : this.columns.entrySet()) {
                    BGridPane gridPane = column.getValue();
                    BWbFieldEditor editor = (BWbFieldEditor)gridPane.get(EDITOR + i).as(BWbFieldEditor.class);
                    BValue saveValue = editor.saveValue().asValue();
                    newSlotValues.put(column.getKey(), (Object)((BSimple)saveValue.as(BSimple.class)).encodeToString());
                }
            } else {
                throw new CannotSaveException("Missing name value");
            }
            toCreateJson.put(SlotPath.escape((String)nameField.getText()), (Object)newSlotValues);
        }
        this.state.setToCreate(toCreateJson.toString());
        return this.state;
    }

    private void addButtonEnabledState() {
        this.addCommand.setEnabled(this.slotsWithDifferences != null && this.slotsWithDifferences.getList().getItemCount() > 0 && this.columns.size() < 3);
    }

    private class AddCommand
    extends Command {
        AddCommand() {
            super((BWidget)BMultiAddFieldEditor.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            this.addSelectedSlot();
            return null;
        }

        private void buildNameColumn() {
            this.buildColumn("name", BMultiAddFieldEditor.this.colNameGrid, null, BMultiAddFieldEditor.NAME_TEXTFIELD);
        }

        private void buildEditorColumn(String propPath, BGridPane gridPane) {
            BSimple simple = MultiAddUtil.getSimpleAtDottedPath((BComplex)BMultiAddFieldEditor.this.instanceToDuplicate, (String)propPath);
            this.buildColumn(propPath, gridPane, simple, BMultiAddFieldEditor.EDITOR);
        }

        private void buildColumn(String columnName, BGridPane gridPane, BSimple editorValue, String editorPrefix) {
            if (gridPane.getChildComponents().length == 0) {
                BLabel nameLabel = new BLabel(columnName);
                gridPane.add("nameLbl", (BValue)nameLabel);
            }
            int existingEditors = gridPane.getChildComponents().length - 1;
            int totalRequested = this.getTotalToCreate();
            if (totalRequested > existingEditors) {
                for (int i = existingEditors; i < totalRequested; ++i) {
                    Object editor = editorValue == null ? new BTextField("", 14) : BWbFieldEditor.makeFor((BObject)editorValue, null, (BWbShell)BWbShell.getWbShell((BWidget)BMultiAddFieldEditor.this));
                    gridPane.add(editorPrefix + i, (BValue)editor);
                    if (!(editor instanceof BWbFieldEditor) || editorValue == null) continue;
                    ((BWbFieldEditor)editor.as(BWbFieldEditor.class)).loadValue((BObject)editorValue);
                }
            } else {
                for (int i = existingEditors; i > totalRequested; --i) {
                    gridPane.remove(editorPrefix + (i - 1));
                }
            }
        }

        private void buildForm() {
            this.buildNameColumn();
            BMultiAddFieldEditor.this.columns.forEach(this::buildEditorColumn);
            BMultiAddFieldEditor.this.getContent().relayout();
            BMultiAddFieldEditor.this.getContent().computePreferredSize();
        }

        private void addSelectedSlot() {
            if (BMultiAddFieldEditor.this.slotsWithDifferences != null && BMultiAddFieldEditor.this.slotsWithDifferences.getSelectedIndex() > -1) {
                String propPath = (String)BMultiAddFieldEditor.this.slotsWithDifferences.getSelectedItem();
                BMultiAddFieldEditor.this.slotsWithDifferences.getList().removeItem((Object)propPath);
                BMultiAddFieldEditor.this.slotsWithDifferences.setSelectedIndex(0);
                BGridPane newColumnGrid = new BGridPane(1);
                BMultiAddFieldEditor.this.columns.put(propPath, newColumnGrid);
                BMultiAddFieldEditor.this.formPane.add("colGrid?", (BValue)newColumnGrid);
                this.buildForm();
                BMultiAddFieldEditor.this.setModified();
            }
            BMultiAddFieldEditor.this.addButtonEnabledState();
        }

        private int getTotalToCreate() {
            String totalStr = BMultiAddFieldEditor.this.total.getText();
            try {
                return totalStr.isEmpty() ? 0 : Integer.parseInt(BMultiAddFieldEditor.this.total.getText());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

