/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.broker.BFoxVirtualSpace;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.sys.tag.BEntityObjectWrapper;
import com.tridium.systemDb.BSystemDbScheme;
import com.tridium.virtual.BUnresolvedVirtualHandler;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryScheme;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.util.BasicEntity;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

@NiagaraType(agent={@AgentOn(types={"niagaraVirtual:NiagaraVirtualGateway"}, requiredPermissions="r")})
@NiagaraSingleton
public final class BSystemDbUnresolvedVirtualHandler
extends BUnresolvedVirtualHandler {
    public static final BSystemDbUnresolvedVirtualHandler INSTANCE = new BSystemDbUnresolvedVirtualHandler();
    public static final Type TYPE = Sys.loadType(BSystemDbUnresolvedVirtualHandler.class);

    public Type getType() {
        return TYPE;
    }

    private BSystemDbUnresolvedVirtualHandler() {
    }

    public OrdTarget resolveFailedVirtualQuery(OrdTarget base, OrdQuery failedOrdQuery) {
        BVirtualGateway gateway;
        boolean canResolve = false;
        int size = base.depth();
        boolean foundFailedQuery = false;
        boolean foundSysQuery = false;
        String firstQuerySchemeAfterSys = null;
        for (int i = 0; i < size; ++i) {
            OrdQuery queryToInspect = base.queryAt(i);
            if (queryToInspect == failedOrdQuery) {
                foundFailedQuery = true;
                continue;
            }
            if (!foundFailedQuery) continue;
            if (!foundSysQuery) {
                if (queryToInspect instanceof BSystemDbScheme.SystemDbQuery) {
                    foundSysQuery = true;
                    int nextIdx = i + 1;
                    if (nextIdx < size) {
                        String nextScheme = base.queryAt(nextIdx).getScheme();
                        try {
                            if (!BOrdScheme.lookup((String)nextScheme).getType().is(BQueryScheme.TYPE)) break;
                            firstQuerySchemeAfterSys = nextScheme;
                            canResolve = true;
                            continue;
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    canResolve = true;
                    continue;
                }
                if (queryToInspect instanceof SlotPath) continue;
                break;
            }
            String scheme = queryToInspect.getScheme();
            boolean isQueryScheme = false;
            try {
                isQueryScheme = "bql".equals(scheme) || BOrdScheme.lookup((String)scheme).getType().is(BQueryScheme.TYPE);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isQueryScheme || scheme.equals(firstQuerySchemeAfterSys)) continue;
            canResolve = false;
            break;
        }
        if (!canResolve) {
            return null;
        }
        BObject obj = base.get();
        BNiagaraVirtualGateway nGateway = null;
        if (obj instanceof BNiagaraVirtualGateway) {
            nGateway = (BNiagaraVirtualGateway)obj;
        } else if (obj instanceof BVirtualComponentSpace) {
            BVirtualGateway gateway2 = ((BVirtualComponentSpace)obj).getVirtualGateway();
            if (gateway2 instanceof BNiagaraVirtualGateway) {
                nGateway = (BNiagaraVirtualGateway)gateway2;
            }
        } else if (obj instanceof BFoxVirtualSpace && (gateway = ((BFoxVirtualSpace)obj).getVirtualGateway()) instanceof BNiagaraVirtualGateway) {
            nGateway = (BNiagaraVirtualGateway)gateway;
        }
        if (nGateway == null) {
            return null;
        }
        String stationName = null;
        if (nGateway.getStationAdapter() != null) {
            stationName = nGateway.getStationAdapter().getStationName();
        } else {
            BComplex parentStation = DrUtil.getParent((BComplex)nGateway, (Type)BDevice.TYPE);
            if (parentStation != null) {
                stationName = parentStation.getName();
            }
        }
        if (stationName == null) {
            return null;
        }
        OrdQuery query = failedOrdQuery;
        if (query instanceof VirtualPath) {
            VirtualPath vPath = (VirtualPath)query;
            int len = vPath.depth();
            String[] slotNames = new String[len];
            for (int i = 0; i < len; ++i) {
                slotNames[i] = VirtualPath.toSlotPathName((String)vPath.nameAt(i));
            }
            query = new SlotPath("slot", slotNames);
        }
        BOrd ord = BOrd.make((BOrd)BOrd.make((String)("nspace:" + stationName)), (OrdQuery)query);
        BIEntity entity = BEntityObjectWrapper.makeEntityObject((Entity)new BasicEntity(ord));
        BFacets facets = BFacets.make((String)"alternateQueryScope", (BIDataValue)BString.make((String)ord.toString()), (String)"makeEntityForAlternateScope", (BIDataValue)BBoolean.TRUE, (String)"lightweightSystemDbQueryResults", (BIDataValue)BBoolean.TRUE);
        return OrdTarget.makeWithFacets((OrdTarget)base, (BObject)((BObject)entity), (BFacets)facets);
    }
}

