/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.ux;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONObject;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryIcon;
import com.tridium.ndriver.discover.BNDiscoveryLeaf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;

@NiagaraSingleton
@NiagaraType
public class BNDriverRpcUtil
extends BSingleton {
    public static final BNDriverRpcUtil INSTANCE = new BNDriverRpcUtil();
    public static final Type TYPE = Sys.loadType(BNDriverRpcUtil.class);
    private static final Logger LOG = Logger.getLogger(BNDriverRpcUtil.class.getName());
    private static final String KEY_DEVICE = "dv";
    private static final String KEY_DEVICE_FOLDER = "df";
    private static final String KEY_POINT_FOLDER = "pf";
    private static final String KEY_PROXY_EXT = "pe";
    private static final String KEY_DISCOVERY_LEAF = "dl";
    private static final String KEY_SUBSCRIPTION_DEPTH = "sd";

    public Type getType() {
        return TYPE;
    }

    private BNDriverRpcUtil() {
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static Map<String, Object> fetchPointManagerInfo(String pointDeviceExtTypeSpec, Context cx) {
        BObject nDeviceObj;
        BObject pointDeviceExtObj;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("fetchPointManagerInfo, for: " + pointDeviceExtTypeSpec);
        }
        try {
            Type pointDeviceExtType = Sys.getType((String)pointDeviceExtTypeSpec);
            pointDeviceExtObj = pointDeviceExtType.getInstance();
        }
        catch (ModuleException | TypeException ex) {
            throw new BajaRuntimeException(ex);
        }
        if (!(pointDeviceExtObj instanceof BPointDeviceExt)) {
            throw new BajaRuntimeException("Not a PointDeviceExt: " + pointDeviceExtObj.getType().getTypeSpec());
        }
        BPointDeviceExt pointDeviceExt = (BPointDeviceExt)pointDeviceExtObj;
        try {
            nDeviceObj = pointDeviceExt.getDeviceType().getInstance();
        }
        catch (ModuleException | TypeException ex) {
            throw new BajaRuntimeException(ex);
        }
        if (!(nDeviceObj instanceof BNDevice)) {
            throw new BajaRuntimeException("Not an NDevice: " + nDeviceObj.getType().getTypeSpec());
        }
        BNDevice nDevice = (BNDevice)nDeviceObj;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(KEY_DEVICE, pointDeviceExt.getDeviceType().getTypeSpec().toString());
        result.put(KEY_POINT_FOLDER, pointDeviceExt.getPointFolderType().getTypeSpec().toString());
        result.put(KEY_PROXY_EXT, pointDeviceExt.getProxyExtType().getTypeSpec().toString());
        result.put(KEY_SUBSCRIPTION_DEPTH, nDevice.getPointManagerSubscribeDepth());
        BNDriverRpcUtil.addDiscovery((BComponent)pointDeviceExt, result);
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static Map<String, Object> fetchDeviceManagerInfo(String networkTypeSpec, Context cx) {
        BComponent networkObj;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("fetchDeviceManagerInfo, for " + networkTypeSpec);
        }
        try {
            Type networkType = Sys.getType((String)networkTypeSpec);
            networkObj = Sys.getService((Type)networkType);
        }
        catch (ModuleException | ServiceNotFoundException | TypeException ex) {
            throw new BajaRuntimeException(ex);
        }
        if (!(networkObj instanceof BNNetwork)) {
            throw new BajaRuntimeException("Not an NNetwork: " + networkObj.getType().getTypeSpec());
        }
        BNNetwork network = (BNNetwork)networkObj;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(KEY_DEVICE, network.getDeviceType().getTypeSpec().toString());
        result.put(KEY_DEVICE_FOLDER, network.getDeviceFolderType().getTypeSpec().toString());
        result.put(KEY_SUBSCRIPTION_DEPTH, network.getDeviceManagerSubscribeDepth());
        BNDriverRpcUtil.addDiscovery((BComponent)network, result);
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> getValidDatabaseTypes(Map<String, Object> discoveryObjJson, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getValidDatabaseTypes, for " + discoveryObjJson);
        }
        ArrayList<String> validTypesList = new ArrayList<String>();
        try {
            TypeInfo[] types;
            BNDiscoveryLeaf discoveryObj = (BNDiscoveryLeaf)BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(discoveryObjJson));
            for (TypeInfo t : types = discoveryObj.getValidDatabaseTypes()) {
                validTypesList.add(t.getTypeSpec().toString());
            }
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        return validTypesList;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getDiscoveryName(Map<String, Object> discoveryObjJson, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getDiscoveryName, for " + discoveryObjJson);
        }
        try {
            BNDiscoveryLeaf discoveryObj = (BNDiscoveryLeaf)BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(discoveryObjJson));
            return discoveryObj.getDiscoveryName();
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getDefaultDiscoveryInstance(Map<String, Object> discoveryObjJson, String proxyExtTypeSpec, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getDefaultDiscoveryInstance, for " + discoveryObjJson + " / " + proxyExtTypeSpec);
        }
        try {
            BNDiscoveryLeaf discoveryObj = (BNDiscoveryLeaf)BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(discoveryObjJson));
            TypeInfo defaultTypeInfo = discoveryObj.getValidDatabaseTypes()[0];
            return BsonEncoderPlugin.marshal((BValue)BNDriverRpcUtil.makeDiscoveryComponent(defaultTypeInfo, discoveryObj, proxyExtTypeSpec));
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getDiscoveryInstance(Map<String, Object> discoveryObjJson, String typeSpec, String proxyExtTypeSpec, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getDiscoveryInstance, for " + typeSpec + " / " + discoveryObjJson + " / " + proxyExtTypeSpec);
        }
        try {
            BNDiscoveryLeaf discoveryObj = (BNDiscoveryLeaf)BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(discoveryObjJson));
            TypeInfo typeInfo = Sys.getType((String)typeSpec).getTypeInfo();
            return BsonEncoderPlugin.marshal((BValue)BNDriverRpcUtil.makeDiscoveryComponent(typeInfo, discoveryObj, proxyExtTypeSpec));
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean getExisting(Map<String, Object> discoveryObjJson, String managedComponentOrd, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getExisting, for " + managedComponentOrd + " / " + discoveryObjJson);
        }
        try {
            BValue discovery = BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(discoveryObjJson));
            if (!(discovery instanceof BNDiscoveryLeaf)) {
                return false;
            }
            BNDiscoveryLeaf discoveryObj = (BNDiscoveryLeaf)discovery;
            TypeInfo[] validDatabaseTypes = discoveryObj.getValidDatabaseTypes();
            BComponent managedComponent = (BComponent)BOrd.make((String)managedComponentOrd).get(null, cx);
            SlotCursor cur = managedComponent.getProperties();
            while (cur.nextComponent()) {
                BComponent possibleDbItem = (BComponent)cur.get();
                for (TypeInfo databaseType : validDatabaseTypes) {
                    if (!databaseType.is(possibleDbItem.getType()) || !discoveryObj.isExisting(possibleDbItem)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getDiscoveryIcon(Map<String, Object> discoveryObjJson, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getDiscoveryIcon, for " + discoveryObjJson);
        }
        try {
            BValue discovery = BsonDecoderPlugin.unmarshal((JSONObject)new JSONObject(discoveryObjJson));
            if (!(discovery instanceof BINDiscoveryIcon)) {
                return BsonEncoderPlugin.marshal((BValue)BIcon.DEFAULT);
            }
            BINDiscoveryIcon discoveryObj = (BINDiscoveryIcon)discovery;
            if (null == discoveryObj.getDiscoveryIcon()) {
                return BsonEncoderPlugin.marshal((BValue)BIcon.DEFAULT);
            }
            return BsonEncoderPlugin.marshal((BValue)discoveryObj.getDiscoveryIcon());
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    private static BComponent makeDiscoveryComponent(TypeInfo typeInfo, BNDiscoveryLeaf discoveryObj, String proxyExtTypeSpec) {
        BComponent targetComponent = (BComponent)typeInfo.getInstance();
        if (!proxyExtTypeSpec.isEmpty()) {
            BProxyExt pe = (BProxyExt)Sys.getType((String)proxyExtTypeSpec).getInstance();
            ((BControlPoint)targetComponent).setProxyExt((BAbstractProxyExt)pe);
        }
        discoveryObj.updateTarget(targetComponent);
        discoveryObj.defaultTargetUpdate(targetComponent);
        return targetComponent;
    }

    private static void addDiscovery(BComponent component, Map<String, Object> result) {
        if (component instanceof BINDiscoveryHost) {
            Type discoveryLeafType;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(component.getType().getTypeSpec() + " implements BINDiscoveryHost");
            }
            if (null != (discoveryLeafType = ((BINDiscoveryHost)component).getDiscoveryPreferences().getDiscoveryLeafType())) {
                result.put(KEY_DISCOVERY_LEAF, discoveryLeafType.getTypeSpec().toString());
            }
        }
    }
}

