/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.uxBuilder.servlet;

import com.tridium.agent.BILoadablePxView;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.ui.util.MediaUtil;
import com.tridium.uxBuilder.servlet.PxUxDecoder;
import com.tridium.uxBuilder.ui.UxMediaUtil;
import com.tridium.web.HttpHeaderUtil;
import com.tridium.web.RestUtil;
import com.tridium.web.WebUtil;
import com.tridium.web.session.WebSessionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.WebDev;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class UxBuilderServlet
extends HttpServlet {
    private static final Pattern XML_PATTERN = Pattern.compile("/xml/.+");
    private static final Pattern DATA_PATTERN = Pattern.compile("/data/.+");
    private static final Pattern MEDIA_PATTERN = Pattern.compile("/media/.+");
    private static final Logger LOGGER = Logger.getLogger("uxBuilder");
    private static final int LOADABLE_TIMEOUT = AccessController.doPrivileged(() -> Integer.getInteger("niagara.uxBuilder.servlet.timeout", 60000));
    private static final long serialVersionUID = -1105179831389083807L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block50: {
            resp.setHeader("transfer-encoding", "chunked");
            Context cx = (Context)req.getAttribute("niagara.context");
            try (Writer writer = null;){
                RestUtil util = new RestUtil(req, resp);
                RestUtil.Accept accept = util.getJsonAccept();
                String escapedOrd = util.get(1);
                BOrd ord = BOrd.make((String)SlotPath.unescape((String)escapedOrd));
                OrdTarget target = ord.resolve(null, cx);
                if (util.matches(MEDIA_PATTERN)) {
                    UxMediaUtil.getMediaInfo(target, req, resp, cx);
                    return;
                }
                String content = null;
                BIFile file = null;
                BObject object = target.get();
                BAbstractPxView pxView = null;
                if (object instanceof BPxFile) {
                    file = (BIFile)object;
                }
                if ((pxView = MediaUtil.getAbstractPxView((OrdTarget)target, (Context)cx)) instanceof BPxView) {
                    file = (BIFile)((BPxView)pxView).getPxFile().get();
                } else if (pxView instanceof BILoadablePxView) {
                    int waitTime;
                    BILoadablePxView loadablePx = (BILoadablePxView)pxView;
                    if (!loadablePx.isPxViewLoading() && loadablePx.isPxViewModified(BAbsTime.END_OF_TIME)) {
                        loadablePx.reloadPxView();
                    }
                    int waitInterval = 250;
                    for (waitTime = 0; loadablePx.isPxViewLoading() && waitTime < LOADABLE_TIMEOUT; waitTime += waitInterval) {
                        Thread.sleep(waitInterval);
                    }
                    if (waitTime >= LOADABLE_TIMEOUT) {
                        LOGGER.log(Level.SEVERE, "BILoadablePxView timeout for " + ord);
                        resp.sendError(404);
                        return;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "BILoadablePxView took " + BRelTime.make((long)waitTime) + " : " + ord);
                    }
                    if (!(pxView instanceof BDynamicPxView)) {
                        LOGGER.log(Level.INFO, "BILoadablePxView that is not also a BDnamicPxView is not support in UxMedia:" + ord);
                        resp.sendError(404);
                        return;
                    }
                    content = ((BDynamicPxView)pxView).generateXml((Object)object, cx);
                } else if (pxView instanceof BDynamicPxView) {
                    content = ((BDynamicPxView)pxView).generateXml((Object)object, cx);
                }
                if (!(file == null || file.getStore() instanceof BFoxFileStore || WebDev.isAnyWebDevEnabled() || BModuleScheme.isModuleDevEnabled())) {
                    boolean modified = HttpHeaderUtil.isModifiedSince((HttpServletRequest)req, (BIFile)file);
                    if (!modified) {
                        resp.setStatus(304);
                        return;
                    }
                    HttpHeaderUtil.setLastModified((HttpServletResponse)resp, (BIFile)file);
                    HttpHeaderUtil.cacheAndRevalidateAfter((HttpServletResponse)resp, (int)0);
                }
                if (util.matches(XML_PATTERN)) {
                    if (file != null) {
                        try (InputStream in = file.getInputStream();){
                            FileUtil.pipe((InputStream)in, (OutputStream)resp.getOutputStream());
                            break block50;
                        }
                    }
                    if (content != null) {
                        resp.getOutputStream().write(content.getBytes());
                    }
                    break block50;
                }
                if (util.matches(DATA_PATTERN)) {
                    PxUxDecoder decoder;
                    if (!util.acceptJson()) {
                        resp.sendError(406);
                        return;
                    }
                    util.respond(accept, "application/json");
                    writer = new OutputStreamWriter((OutputStream)resp.getOutputStream());
                    JSONWriter jsonWriter = QuickJSONWriter.make((Appendable)writer);
                    if (file != null) {
                        decoder = new PxUxDecoder(file, true, cx);
                    } else if (content != null) {
                        decoder = new PxUxDecoder(ord, new ByteArrayInputStream(content.getBytes()), true, cx);
                    } else {
                        resp.sendError(404);
                        return;
                    }
                    decoder.setProfileAppNames(UxBuilderServlet.getProfileAppNames(req));
                    decoder.decodeToJson(jsonWriter);
                } else {
                    resp.sendError(404);
                }
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context cx = (Context)req.getAttribute("niagara.context");
        try {
            RestUtil util = new RestUtil(req, resp);
            String escapedOrd = util.get(1);
            BOrd ord = BOrd.make((String)SlotPath.unescape((String)escapedOrd));
            OrdTarget target = ord.resolve(null, cx);
            if (util.matches(MEDIA_PATTERN)) {
                UxMediaUtil.setMediaInfo(target, req, resp, cx);
            } else {
                resp.sendError(404);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ServletException", e);
            WebUtil.sendSafeErrorToUser((HttpServletResponse)resp, (int)400, (Throwable)e, (Context)cx);
        }
    }

    private static String[] getProfileAppNames(HttpServletRequest req) {
        BWebProfileConfig config = (BWebProfileConfig)WebSessionUtil.getSession((HttpSession)req.getSession()).getAttribute("hxProfileConfig");
        if (config != null) {
            return config.makeWebProfile().getAppNames();
        }
        return null;
    }
}

