/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.analyzer;

import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.analyzer.BBoxFrameRecord;
import java.nio.charset.StandardCharsets;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.PatternFilter;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

public final class BBoxAnalyzer
extends BComponent
implements BBoxService.IBoxListener {
    public static final Property active = BBoxAnalyzer.newProperty((int)75, (boolean)false, null);
    public static final Property viewLogLimit = BBoxAnalyzer.newProperty((int)0, (int)4096, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)5)));
    public static final Property userPattern = BBoxAnalyzer.newProperty((int)0, (String)"*", null);
    public static final Property hostPattern = BBoxAnalyzer.newProperty((int)0, (String)"*", null);
    public static final Property totalFrames = BBoxAnalyzer.newProperty((int)67, (int)0, null);
    public static final Property lastNewFrameDateTime = BBoxAnalyzer.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property historyEnabled = BBoxAnalyzer.newProperty((int)64, (boolean)false, null);
    public static final Property historyId = BBoxAnalyzer.newProperty((int)0, (BValue)BHistoryId.make((String)"^", (String)"box"), null);
    public static final Property historyConfig = BBoxAnalyzer.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.DEFAULT, BBoxFrameRecord.TYPE.getTypeSpec()), null);
    public static final Topic newFrame = BBoxAnalyzer.newTopic((int)264, null);
    public static final Type TYPE = Sys.loadType(BBoxAnalyzer.class);
    private static final Log log = Log.getLog((String)"boxStationAnalyzer");
    private static final BIcon icon = BIcon.std((String)"magnifyingGlass.png");
    private volatile PatternFilter userFilter = new PatternFilter("*");
    private volatile PatternFilter hostFilter = new PatternFilter("*");
    private static Worker worker;
    private static final Queue queue;
    private static int startCount;

    public boolean getActive() {
        return this.getBoolean(active);
    }

    public void setActive(boolean v) {
        this.setBoolean(active, v, null);
    }

    public int getViewLogLimit() {
        return this.getInt(viewLogLimit);
    }

    public void setViewLogLimit(int v) {
        this.setInt(viewLogLimit, v, null);
    }

    public String getUserPattern() {
        return this.getString(userPattern);
    }

    public void setUserPattern(String v) {
        this.setString(userPattern, v, null);
    }

    public String getHostPattern() {
        return this.getString(hostPattern);
    }

    public void setHostPattern(String v) {
        this.setString(hostPattern, v, null);
    }

    public int getTotalFrames() {
        return this.getInt(totalFrames);
    }

    public void setTotalFrames(int v) {
        this.setInt(totalFrames, v, null);
    }

    public BAbsTime getLastNewFrameDateTime() {
        return (BAbsTime)this.get(lastNewFrameDateTime);
    }

    public void setLastNewFrameDateTime(BAbsTime v) {
        this.set(lastNewFrameDateTime, (BValue)v, null);
    }

    public boolean getHistoryEnabled() {
        return this.getBoolean(historyEnabled);
    }

    public void setHistoryEnabled(boolean v) {
        this.setBoolean(historyEnabled, v, null);
    }

    public BHistoryId getHistoryId() {
        return (BHistoryId)this.get(historyId);
    }

    public void setHistoryId(BHistoryId v) {
        this.set(historyId, (BValue)v, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    public void fireNewFrame(BBoxFrameRecord event) {
        this.fire(newFrame, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBoxService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        this.userFilter = new PatternFilter(this.getUserPattern());
        this.hostFilter = new PatternFilter(this.getHostPattern());
        Class<BBoxAnalyzer> clazz = BBoxAnalyzer.class;
        synchronized (BBoxAnalyzer.class) {
            ++startCount;
            if (worker == null) {
                worker = new Worker((Worker.ITodo)queue);
                worker.start("boxStationAnalyzer");
                if (log.isTraceOn()) {
                    log.trace("Starting Box Analyzer Worker Thread");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.requiresRegistering()) {
                this.getBoxService().registerListener((BBoxService.IBoxListener)this);
                this.setActive(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        this.getBoxService().unregisterListener((BBoxService.IBoxListener)this);
        this.setActive(false);
        Class<BBoxAnalyzer> clazz = BBoxAnalyzer.class;
        synchronized (BBoxAnalyzer.class) {
            if (--startCount <= 0 && worker != null) {
                worker.stop();
                worker = null;
                if (log.isTraceOn()) {
                    log.trace("Stopping Box Analyzer Worker Thread");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == userPattern) {
            this.userFilter = new PatternFilter(this.getUserPattern());
        } else if (property == hostPattern) {
            this.hostFilter = new PatternFilter(this.getHostPattern());
        } else if (property == historyEnabled) {
            if (this.requiresRegistering()) {
                this.getBoxService().registerListener((BBoxService.IBoxListener)this);
                this.setActive(true);
            } else {
                this.getBoxService().unregisterListener((BBoxService.IBoxListener)this);
                this.setActive(false);
            }
        }
    }

    public void subscribed() {
        if (this.isRunning() && this.requiresRegistering()) {
            this.getBoxService().registerListener((BBoxService.IBoxListener)this);
            this.setActive(true);
        }
    }

    public void unsubscribed() {
        if (this.isRunning() && !this.requiresRegistering()) {
            this.getBoxService().unregisterListener((BBoxService.IBoxListener)this);
            this.setActive(false);
        }
    }

    public void newRecord(BAbsTime timestamp, BBoxRecordType recordType, String userName, String host, int port, byte[] data) {
        final BBoxFrameRecord record = new BBoxFrameRecord();
        record.setTimestamp(timestamp);
        record.setUser(userName);
        record.setHost(host);
        record.setPort(port);
        record.setRecordType(recordType);
        record.setData(new String(data, StandardCharsets.UTF_8));
        if (this.userFilter.accept(record.getUser()) && this.hostFilter.accept(record.getHost())) {
            BBoxAnalyzer.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BBoxAnalyzer bBoxAnalyzer = BBoxAnalyzer.this;
                    synchronized (bBoxAnalyzer) {
                        BBoxAnalyzer.this.setTotalFrames(BBoxAnalyzer.this.getTotalFrames() + 1);
                        BBoxAnalyzer.this.setLastNewFrameDateTime(BAbsTime.now());
                    }
                    BBoxAnalyzer.this.fireNewFrame(record);
                    BBoxAnalyzer.this.recordToHistory(record);
                }
            });
        }
    }

    private BBoxService getBoxService() {
        return (BBoxService)this.getParent();
    }

    private boolean requiresRegistering() {
        return this.isSubscribed() || this.getHistoryEnabled();
    }

    private static void post(Runnable runnable) {
        queue.enqueue((Object)runnable);
    }

    private void recordToHistory(BBoxFrameRecord record) {
        if (!this.getHistoryEnabled()) {
            return;
        }
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                BHistoryConfig config = this.getHistoryConfig();
                config.setTimeZone(BTimeZone.getLocal());
                BHistoryId id = this.getHistoryId();
                id = id.fromShorthand(Sys.getStation().getStationName());
                config.setId(id);
                if (!conn.exists(id)) {
                    conn.createHistory(config);
                } else {
                    conn.reconfigureHistory(config);
                }
                BIHistory history = conn.getHistory(id);
                conn.append(history, (BIHistoryRecordSet)record);
                conn.flush(history);
            }
        }
        catch (Exception e) {
            log.error("Writing Box Analyzer History", (Throwable)e);
        }
    }

    static {
        queue = new Queue();
        startCount = 0;
    }
}

