/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore;

import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.tridium.opcUaCore.BUaArgument;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BUaArgumentVector
extends BVector {
    public static final Type TYPE = Sys.loadType(BUaArgumentVector.class);

    public Type getType() {
        return TYPE;
    }

    public Variant[] makeUserArguments(BVector userArg) {
        BUaArgument[] argDefs = (BUaArgument[])this.getChildren(BUaArgument.class);
        Variant[] variants = new Variant[argDefs.length];
        for (int i2 = 0; i2 < argDefs.length; ++i2) {
            NodeId uaTypeId = NodeId.parseNodeId(argDefs[i2].getUaArgType());
            BValue bValue = userArg.get("value" + i2);
            if (bValue == null) continue;
            variants[i2] = BUaArgumentVector.makeUaVariant(bValue, uaTypeId);
        }
        return variants;
    }

    public BVector makeResultVector(Variant[] results) {
        BVector retVector = new BVector();
        BUaArgument[] resultDefs = (BUaArgument[])this.getChildren(BUaArgument.class);
        for (int i2 = 0; i2 < results.length; ++i2) {
            NodeId nodeId = NodeId.parseNodeId(resultDefs[i2].getUaArgType());
            BValue bResult = BUaArgumentVector.variantToBValue(results[i2], nodeId);
            if (bResult == null) continue;
            retVector.add("result?", bResult);
        }
        return retVector;
    }

    private static BValue variantToBValue(Variant vValue, NodeId resultType) {
        String className = BuiltinsMap.ID_CLASS_MAP.getRight(resultType).getSimpleName();
        return BUaArgumentVector.variantToBValue(vValue, className);
    }

    private static BValue variantToBValue(Variant vValue, String className) {
        BString bValue = null;
        Object value = vValue.getValue();
        switch (className) {
            case "Boolean": {
                if (!(value instanceof Boolean)) break;
                bValue = BBoolean.make((boolean)((Boolean)value));
                break;
            }
            case "Byte": {
                if (!(value instanceof Byte)) break;
                bValue = BInteger.make((int)((Byte)value).byteValue());
                break;
            }
            case "UnsignedByte": {
                if (!(value instanceof UnsignedByte)) break;
                bValue = BInteger.make((int)((UnsignedByte)value).getValue());
                break;
            }
            case "Short": {
                if (!(value instanceof Short)) break;
                bValue = BInteger.make((int)((Short)value).shortValue());
                break;
            }
            case "UnsignedShort": {
                if (!(value instanceof UnsignedShort)) break;
                bValue = BInteger.make((int)((UnsignedShort)value).intValue());
                break;
            }
            case "Integer": {
                if (!(value instanceof Integer)) break;
                bValue = BInteger.make((int)((Integer)value));
                break;
            }
            case "UnsignedInteger": {
                if (!(value instanceof UnsignedInteger)) break;
                bValue = BLong.make((long)((UnsignedInteger)value).longValue());
                break;
            }
            case "Long": {
                if (!(value instanceof Long)) break;
                bValue = BLong.make((long)((Long)value));
                break;
            }
            case "UnsignedLong": {
                if (!(value instanceof UnsignedLong)) break;
                bValue = BLong.make((long)((UnsignedLong)value).longValue());
                break;
            }
            case "Float": {
                if (!(value instanceof Float)) break;
                bValue = BFloat.make((float)((Float)value).floatValue());
                break;
            }
            case "Double": {
                if (!(value instanceof Double)) break;
                bValue = BDouble.make((double)((Double)value));
                break;
            }
            case "ByteString": {
                if (!(value instanceof ByteString)) break;
                bValue = BString.make((String)((ByteString)value).toHex());
                break;
            }
            case "String": {
                if (!(value instanceof String)) break;
                bValue = BString.make((String)((String)value));
                break;
            }
            case "LocalizedText": {
                if (!(value instanceof LocalizedText)) break;
                bValue = BString.make((String)((LocalizedText)value).getText());
                break;
            }
        }
        return bValue;
    }

    private static Variant makeUaVariant(BValue bValue, NodeId uaTypeId) {
        String className = BuiltinsMap.ID_CLASS_MAP.getRight(uaTypeId).getSimpleName();
        Object value = null;
        switch (className) {
            case "Boolean": {
                if (!(bValue instanceof BBoolean)) break;
                value = ((BBoolean)bValue).getBoolean();
                break;
            }
            case "Byte": {
                if (!(bValue instanceof BInteger)) break;
                value = (byte)((BInteger)bValue).getInt();
                break;
            }
            case "UnsignedByte": {
                if (!(bValue instanceof BInteger)) break;
                value = UnsignedByte.valueOf(((BInteger)bValue).getInt());
                break;
            }
            case "Short": {
                if (!(bValue instanceof BInteger)) break;
                value = (short)((BInteger)bValue).getInt();
                break;
            }
            case "UnsignedShort": {
                if (!(bValue instanceof BInteger)) break;
                value = UnsignedShort.valueOf(((BInteger)bValue).getInt());
                break;
            }
            case "Integer": {
                if (!(bValue instanceof BInteger)) break;
                value = ((BInteger)bValue).getInt();
                break;
            }
            case "UnsignedInteger": {
                if (!(bValue instanceof BLong)) break;
                value = UnsignedInteger.valueOf(((BLong)bValue).getLong());
                break;
            }
            case "Long": {
                if (!(bValue instanceof BLong)) break;
                value = ((BLong)bValue).getLong();
                break;
            }
            case "UnsignedLong": {
                if (!(bValue instanceof BLong)) break;
                value = UnsignedLong.valueOf(((BLong)bValue).getLong());
                break;
            }
            case "Float": {
                if (!(bValue instanceof BFloat)) break;
                value = Float.valueOf(((BFloat)bValue).getFloat());
                break;
            }
            case "Double": {
                if (!(bValue instanceof BDouble)) break;
                value = ((BDouble)bValue).getDouble();
                break;
            }
            case "ByteString": {
                if (!(bValue instanceof BString)) break;
                value = ByteString.fromHex(((BString)bValue).getString());
                break;
            }
            case "String": {
                if (!(bValue instanceof BString)) break;
                value = ((BString)bValue).getString();
                break;
            }
            case "LocalizedText": {
                if (!(bValue instanceof BString)) break;
                value = new LocalizedText(((BString)bValue).getString());
                break;
            }
            default: {
                return Variant.NULL;
            }
        }
        return new Variant(value);
    }
}

