/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BUaAccessLevel
extends BBitString {
    public static final int RD = 1;
    public static final int WR = 2;
    public static final int HIST_RD = 4;
    public static final int HIST_WR = 8;
    public static final BUaAccessLevel rd = (BUaAccessLevel)new BUaAccessLevel(1).intern();
    public static final BUaAccessLevel wr = (BUaAccessLevel)new BUaAccessLevel(2).intern();
    public static final BUaAccessLevel hRd = (BUaAccessLevel)new BUaAccessLevel(4).intern();
    public static final BUaAccessLevel hWr = (BUaAccessLevel)new BUaAccessLevel(8).intern();
    public static final BUaAccessLevel DEFAULT = new BUaAccessLevel(0);
    public static final BUaAccessLevel EMPTY = new BUaAccessLevel(0);
    public static final BUaAccessLevel ALL = new BUaAccessLevel(15);
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;
    private int bits;

    public static BUaAccessLevel make(boolean v) {
        if (v) {
            return ALL;
        }
        return EMPTY;
    }

    public static BUaAccessLevel make(int bits) {
        if (bits == BUaAccessLevel.ALL.bits) {
            return ALL;
        }
        if (bits == BUaAccessLevel.EMPTY.bits) {
            return EMPTY;
        }
        return (BUaAccessLevel)new BUaAccessLevel(bits).intern();
    }

    private BUaAccessLevel(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public boolean includes(int mode) {
        return (this.bits & mode) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i2 = 0; i2 < ordinals.length; ++i2) {
            mask |= ordinals[i2];
        }
        return BUaAccessLevel.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public boolean isModes() {
        return this.bits == BUaAccessLevel.ALL.bits;
    }

    public String getEmptyTag() {
        return "none";
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BUaAccessLevel) {
            return ((BUaAccessLevel)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BUaAccessLevel.make(in.readInt());
    }

    public String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    public BObject decodeFromString(String s2) throws IOException {
        try {
            return BUaAccessLevel.make(Integer.parseInt(s2, 16));
        }
        catch (Exception e2) {
            throw new IOException("Invalid bits: " + s2);
        }
    }

    public String toString(Context cx) {
        if (this.bits == 0) {
            return "{}";
        }
        StringBuffer s2 = new StringBuffer();
        s2.append('{');
        if (this.includes(1)) {
            if (s2.length() > 1) {
                s2.append(" ");
            }
            s2.append(support.getDisplayTag(1, cx));
        }
        if (this.includes(2)) {
            if (s2.length() > 1) {
                s2.append(" ");
            }
            s2.append(support.getDisplayTag(2, cx));
        }
        if (this.includes(4)) {
            if (s2.length() > 1) {
                s2.append(" ");
            }
            s2.append(support.getDisplayTag(4, cx));
        }
        if (this.includes(8)) {
            if (s2.length() > 1) {
                s2.append(" ");
            }
            s2.append(support.getDisplayTag(8, cx));
        }
        s2.append('}');
        return s2.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "rd");
        support.add(2, "wr");
        support.add(4, "hRd");
        support.add(8, "hWr");
        TYPE = Sys.loadType(BUaAccessLevel.class);
    }
}

