/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.UnitType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.UnitTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32442")
public abstract class UnitTypeNodeBase
extends BaseObjectTypeNode
implements UnitType {
    private static GeneratedNodeInitializer<UnitTypeNode> OC;

    protected UnitTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<UnitTypeNode> generatedNodeInitializer = UnitTypeNodeBase.getUnitTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((UnitTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<UnitTypeNode> getUnitTypeNodeInitializer() {
        return OC;
    }

    public static void setUnitTypeNodeInitializer(GeneratedNodeInitializer<UnitTypeNode> generatedNodeInitializer) {
        OC = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getUnitSystemNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnitSystem");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getUnitSystem() {
        UaProperty uaProperty = this.getUnitSystemNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UnitSystem does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setUnitSystem(String string) {
        UaProperty uaProperty = this.getUnitSystemNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnitSystem failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnitSystem failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDisciplineNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Discipline");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDiscipline() {
        UaProperty uaProperty = this.getDisciplineNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDiscipline(String string) {
        UaProperty uaProperty = this.getDisciplineNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Discipline failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Discipline failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSymbolNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Symbol");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getSymbol() {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Symbol does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setSymbol(LocalizedText localizedText) {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Symbol failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Symbol failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

