/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.UadpDataSetMessageContentMask;
import com.prosysopc.ua.types.opcua.UadpDataSetWriterMessageType;
import com.prosysopc.ua.types.opcua.server.DataSetWriterMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.UadpDataSetWriterMessageTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21111")
public abstract class UadpDataSetWriterMessageTypeNodeBase
extends DataSetWriterMessageTypeNode
implements UadpDataSetWriterMessageType {
    private static GeneratedNodeInitializer<UadpDataSetWriterMessageTypeNode> OA;

    protected UadpDataSetWriterMessageTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<UadpDataSetWriterMessageTypeNode> generatedNodeInitializer = UadpDataSetWriterMessageTypeNodeBase.getUadpDataSetWriterMessageTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((UadpDataSetWriterMessageTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<UadpDataSetWriterMessageTypeNode> getUadpDataSetWriterMessageTypeNodeInitializer() {
        return OA;
    }

    public static void setUadpDataSetWriterMessageTypeNodeInitializer(GeneratedNodeInitializer<UadpDataSetWriterMessageTypeNode> generatedNodeInitializer) {
        OA = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UadpDataSetMessageContentMask getDataSetMessageContentMask() {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetMessageContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UadpDataSetMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetMessageContentMask(UadpDataSetMessageContentMask uadpDataSetMessageContentMask) {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMessageContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(uadpDataSetMessageContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetMessageContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConfiguredSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfiguredSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getConfiguredSize() {
        UaProperty uaProperty = this.getConfiguredSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConfiguredSize does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setConfiguredSize(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getConfiguredSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConfiguredSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConfiguredSize failed unexpectedly", statusException);
        }
    }

    public void setConfiguredSize(int n2) {
        this.setConfiguredSize(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getNetworkMessageNumber() {
        UaProperty uaProperty = this.getNetworkMessageNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NetworkMessageNumber does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageNumber(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getNetworkMessageNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NetworkMessageNumber failed unexpectedly", statusException);
        }
    }

    public void setNetworkMessageNumber(int n2) {
        this.setNetworkMessageNumber(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getDataSetOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getDataSetOffset() {
        UaProperty uaProperty = this.getDataSetOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetOffset does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setDataSetOffset(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getDataSetOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetOffset failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetOffset failed unexpectedly", statusException);
        }
    }

    public void setDataSetOffset(int n2) {
        this.setDataSetOffset(UnsignedShort.valueOf(n2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

